/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import java.util.Collection;
import java.util.Iterator;
import javax.media.opengl.GL2;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.Accumulator;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.RenderState;
import saf.v3d.scene.VSpatial;

public abstract class VComposite
extends VSpatial {
    protected Collection<VSpatial> children;
    protected boolean boundsDirty = false;

    public VComposite() {
        this.boundingSphere = new BoundingSphere(new Point3f(), 0.0f);
    }

    @Override
    public void invalidate(GL2 gl) {
        for (VSpatial child : this.children) {
            child.invalidate(gl);
        }
    }

    public void markBoundsDirty() {
        this.boundsDirty = true;
        this.dirty = true;
        if (this.parent != null) {
            this.parent.markBoundsDirty();
        }
    }

    public void addChild(VSpatial child) {
        this.markBoundsDirty();
        if (child.getParent() != null) {
            child.getParent().removeChild(child);
        }
        child.setParent(this);
        this.children.add(child);
    }

    public Iterable<VSpatial> children() {
        return this.children;
    }

    public void addChildren(VSpatial ... items) {
        VSpatial[] vSpatialArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            VSpatial child = vSpatialArray[n2];
            this.addChild(child);
            ++n2;
        }
    }

    public void removeChild(VSpatial child) {
        this.children.remove(child);
        child.setParent(null);
        this.markBoundsDirty();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public void removeAllChildren() {
        for (VSpatial child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
        this.boundsDirty = true;
    }

    @Override
    protected BoundingSphere doGetBoundingSphere() {
        if (this.boundsDirty) {
            if (this.children.isEmpty()) {
                this.boundingSphere = new BoundingSphere(new Point3f(), 0.0f);
            } else {
                Iterator<VSpatial> iter = this.children.iterator();
                this.boundingSphere = new BoundingSphere(iter.next().doGetBoundingSphere());
                while (iter.hasNext()) {
                    this.boundingSphere.merge(iter.next().doGetBoundingSphere());
                }
            }
        }
        return this.boundingSphere;
    }

    @Override
    protected void markAsDirty() {
        super.markAsDirty();
        for (VSpatial child : this.children) {
            child.markAsDirty();
        }
    }

    @Override
    public void updateWorldTransformation() {
        super.updateWorldTransformation();
        for (VSpatial child : this.children) {
            child.updateWorldTransformation();
        }
    }

    @Override
    protected void doDraw(GL2 gl, RenderState rState) {
        if (this.visible) {
            for (VSpatial child : this.children) {
                child.draw(gl, rState);
            }
        }
    }

    @Override
    public void intersects(Point3f point, Accumulator accumulator) {
        BoundingSphere sphere = this.getBoundingSphere();
        if (sphere.intersects(point)) {
            for (VSpatial child : this.children) {
                child.intersects(point, accumulator);
            }
        }
    }

    @Override
    public void intersects(Point3f rayOrigin, Vector3f rayDirection, Accumulator accumulator) {
        BoundingSphere sphere = this.getBoundingSphere();
        if (sphere.intersects(rayOrigin, rayDirection)) {
            for (VSpatial child : this.children) {
                child.intersects(rayOrigin, rayDirection, accumulator);
            }
        }
    }
}

