/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.scene.Position;
import saf.v3d.scene.VSpatial;

public class Label {
    private String text;
    private String[] lines;
    private VSpatial parent;
    private Point3f pt = new Point3f();
    private Point3f offset = new Point3f();
    private Color color = Color.BLUE;
    private Position position = Position.CENTER;
    private boolean textChanged = true;
    private Rectangle2D[] bounds;
    private PositionCalculator posCalc = new Center();
    private float maxX;
    private float totalHeight;

    public Label(String text, VSpatial parent) {
        this(text, parent, Position.SOUTH);
    }

    public Label(String text, VSpatial parent, Position position) {
        this.text = text;
        this.lines = text.split("\n");
        this.parent = parent;
        this.setPosition(position);
    }

    public void setOffset(float x, float y) {
        this.offset.set(x, y, 0.0f);
    }

    public Point3f getOffset() {
        return this.offset;
    }

    public void setPosition(Position position) {
        if (position != this.position) {
            this.position = position;
            if (position == Position.CENTER) {
                this.posCalc = new Center();
            } else if (position == Position.NORTH) {
                this.posCalc = new North();
            } else if (position == Position.SOUTH) {
                this.posCalc = new South();
            } else if (position == Position.EAST) {
                this.posCalc = new East();
            } else if (position == Position.WEST) {
                this.posCalc = new West();
            } else if (position == Position.NORTH_EAST) {
                this.posCalc = new NorthEast();
            } else if (position == Position.NORTH_WEST) {
                this.posCalc = new NorthWest();
            } else if (position == Position.SOUTH_WEST) {
                this.posCalc = new SouthWest();
            } else if (position == Position.SOUTH_EAST) {
                this.posCalc = new SouthEast();
            }
        }
    }

    private void updateLocation(TextRenderer renderer) {
        BoundingSphere sphere = this.parent.getLocalBoundingSphere();
        this.pt.set((Tuple3f)sphere.getCenterRef());
        this.parent.transform(this.pt);
        if (this.textChanged || this.bounds == null) {
            this.bounds = new Rectangle2D[this.lines.length];
            this.maxX = 0.0f;
            this.totalHeight = 0.0f;
            int i = 0;
            while (i < this.lines.length) {
                this.bounds[i] = renderer.getBounds(this.lines[i]);
                this.totalHeight = (float)((double)this.totalHeight + this.bounds[i].getHeight());
                this.maxX = (float)Math.max((double)this.maxX, this.bounds[i].getWidth());
                ++i;
            }
        }
        this.posCalc.calcPosition(this.pt, this.bounds, this.offset, sphere.getRadius() * this.parent.getLocalScale(), this.maxX, this.totalHeight);
    }

    public void fontChanged() {
        this.bounds = null;
    }

    public void drawText(TextRenderer renderer) {
        this.updateLocation(renderer);
        renderer.setColor(this.color);
        int y = 0;
        int i = 0;
        while (i < this.lines.length) {
            String line = this.lines[i];
            renderer.draw(line, (int)this.pt.x, (int)this.pt.y - y);
            if (i < this.bounds.length - 1) {
                y += (int)this.bounds[i + 1].getHeight() + 1;
            }
            ++i;
        }
    }

    public void setText(String text) {
        this.textChanged = !this.text.equals(text);
        this.text = text;
        this.lines = this.text.split("\n");
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private static class Center
    implements PositionCalculator {
        private Center() {
        }

        @Override
        public void calcPosition(Point3f pt, Rectangle2D[] bounds, Point3f offset, float radius, float width, float height) {
            if (bounds.length == 1) {
                pt.x = (float)((double)pt.x - (bounds[0].getWidth() / 2.0 + (double)offset.x));
                pt.y = (float)((double)pt.y - (bounds[0].getHeight() / 2.0 + (double)offset.y));
            } else {
                pt.x -= width / 2.0f + offset.x;
                pt.y = (float)((double)pt.y + (((double)height - bounds[0].getHeight()) / 2.0 + (double)offset.y));
            }
        }
    }

    private static class East
    implements PositionCalculator {
        private East() {
        }

        @Override
        public void calcPosition(Point3f pt, Rectangle2D[] bounds, Point3f offset, float radius, float width, float height) {
            if (bounds.length == 1) {
                pt.x += radius + offset.x;
                pt.y = (float)((double)pt.y - (bounds[0].getHeight() / 2.0 + (double)offset.y));
            } else {
                pt.x += radius + offset.x;
                pt.y = (float)((double)pt.y + (((double)height - bounds[0].getHeight()) / 2.0 + (double)offset.y));
            }
        }
    }

    private static class North
    implements PositionCalculator {
        private North() {
        }

        @Override
        public void calcPosition(Point3f pt, Rectangle2D[] bounds, Point3f offset, float radius, float width, float height) {
            if (bounds.length == 1) {
                pt.x = (float)((double)pt.x - (bounds[0].getWidth() / 2.0 + (double)offset.x));
                pt.y += radius + offset.y;
            } else {
                pt.x -= width / 2.0f + offset.x;
                pt.y = (float)((double)pt.y + ((double)(radius + offset.y + height) - bounds[0].getHeight() / 2.0));
            }
        }
    }

    private static class NorthEast
    implements PositionCalculator {
        private NorthEast() {
        }

        @Override
        public void calcPosition(Point3f pt, Rectangle2D[] bounds, Point3f offset, float radius, float width, float height) {
            if (bounds.length == 1) {
                pt.x += radius + offset.x;
                pt.y += radius + offset.y;
            } else {
                pt.x += radius + offset.x;
                pt.y = (float)((double)pt.y + ((double)(radius + offset.y + height) - bounds[0].getHeight() / 2.0));
            }
        }
    }

    private static class NorthWest
    implements PositionCalculator {
        private NorthWest() {
        }

        @Override
        public void calcPosition(Point3f pt, Rectangle2D[] bounds, Point3f offset, float radius, float width, float height) {
            if (bounds.length == 1) {
                pt.x = (float)((double)pt.x - ((double)(radius + offset.x) + bounds[0].getWidth()));
                pt.y += radius + offset.y;
            } else {
                pt.x -= radius + offset.x + width;
                pt.y = (float)((double)pt.y + ((double)(radius + offset.y + height) - bounds[0].getHeight() / 2.0));
            }
        }
    }

    private static interface PositionCalculator {
        public void calcPosition(Point3f var1, Rectangle2D[] var2, Point3f var3, float var4, float var5, float var6);
    }

    private static class South
    implements PositionCalculator {
        private South() {
        }

        @Override
        public void calcPosition(Point3f pt, Rectangle2D[] bounds, Point3f offset, float radius, float width, float height) {
            if (bounds.length == 1) {
                pt.x = (float)((double)pt.x - (bounds[0].getWidth() / 2.0 + (double)offset.x));
                pt.y = (float)((double)pt.y - ((double)radius + bounds[0].getHeight() + (double)offset.y));
            } else {
                pt.x -= width / 2.0f + offset.x;
                pt.y = (float)((double)pt.y - ((double)radius + bounds[0].getHeight() + (double)offset.y));
            }
        }
    }

    private static class SouthEast
    implements PositionCalculator {
        private SouthEast() {
        }

        @Override
        public void calcPosition(Point3f pt, Rectangle2D[] bounds, Point3f offset, float radius, float width, float height) {
            if (bounds.length == 1) {
                pt.x += radius + offset.x;
                pt.y = (float)((double)pt.y - ((double)radius + bounds[0].getHeight() + (double)offset.y));
            } else {
                pt.x += radius + offset.x;
                pt.y = (float)((double)pt.y - ((double)radius + bounds[0].getHeight() + (double)offset.y));
            }
        }
    }

    private static class SouthWest
    implements PositionCalculator {
        private SouthWest() {
        }

        @Override
        public void calcPosition(Point3f pt, Rectangle2D[] bounds, Point3f offset, float radius, float width, float height) {
            if (bounds.length == 1) {
                pt.x = (float)((double)pt.x - ((double)(radius + offset.x) + bounds[0].getWidth()));
                pt.y = (float)((double)pt.y - ((double)radius + bounds[0].getHeight() + (double)offset.y));
            } else {
                pt.x -= radius + offset.x + width;
                pt.y = (float)((double)pt.y - ((double)radius + bounds[0].getHeight() + (double)offset.y));
            }
        }
    }

    private static class West
    implements PositionCalculator {
        private West() {
        }

        @Override
        public void calcPosition(Point3f pt, Rectangle2D[] bounds, Point3f offset, float radius, float width, float height) {
            if (bounds.length == 1) {
                pt.x = (float)((double)pt.x - ((double)(radius + offset.x) + bounds[0].getWidth()));
                pt.y = (float)((double)pt.y - (bounds[0].getHeight() / 2.0 + (double)offset.y));
            } else {
                pt.x -= radius + offset.x + width;
                pt.y = (float)((double)pt.y + (((double)height - bounds[0].getHeight()) / 2.0 + (double)offset.y));
            }
        }
    }
}

