/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import java.util.concurrent.locks.Lock;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import saf.v3d.Canvas2D;
import saf.v3d.CanvasListener;
import saf.v3d.scene.VRoot;
import saf.v3d.scene.VSpatial;

public class Camera
implements CanvasListener {
    private GLAutoDrawable drawable;
    private Canvas2D canvas;
    private VRoot root;
    private float width;
    private float height;
    float scale = 1.0f;
    Matrix3f rotation;
    private Vector3f pan = new Vector3f();
    private Vector3f translate = new Vector3f();

    public Camera(Canvas2D canvas, GLAutoDrawable drawable) {
        this.drawable = drawable;
        this.canvas = canvas;
        this.root = new VRoot(this);
        this.root.markAsDirty();
        this.rotation = new Matrix3f();
        this.rotation.setIdentity();
    }

    public VRoot getRoot() {
        return this.root;
    }

    public void resetAndCenter() {
        Lock lock = this.canvas.getRenderLock();
        try {
            boolean isNaN;
            lock.lock();
            this.root.markBoundsDirty();
            Point3f center = this.root.getBoundingSphere().getCenterRef();
            boolean bl = isNaN = Float.isNaN(center.x) || Float.isNaN(center.y) || Float.isNaN(center.z);
            if (!isNaN) {
                this.pan.set((Tuple3f)new Vector3f());
                this.translate.x = this.width / 2.0f - center.x;
                this.translate.y = this.height / 2.0f - center.y;
                this.translate.z = 0.0f;
                this.scale = 1.0f;
            }
            this.root.markAsDirty();
        }
        finally {
            lock.unlock();
        }
    }

    public void reset() {
        Lock lock = this.canvas.getRenderLock();
        try {
            lock.lock();
            this.root.markAsDirty();
            this.pan.set((Tuple3f)new Vector3f());
            this.translate.set((Tuple3f)new Vector3f());
            this.scale = 1.0f;
        }
        finally {
            lock.unlock();
        }
    }

    public void pan(Vector3f pan) {
        Lock lock = this.canvas.getRenderLock();
        try {
            lock.lock();
            this.root.markAsDirty();
        }
        finally {
            lock.unlock();
        }
        this.translate.x += (pan.x - this.pan.x) * this.scale;
        this.translate.y += (pan.y - this.pan.y) * this.scale;
        this.pan.set((Tuple3f)pan);
    }

    public float getScale() {
        return this.scale;
    }

    public void getTranslate(Vector3f trans) {
        this.translate.get((Tuple3f)trans);
    }

    public void scale(float scale) {
        Lock lock = this.canvas.getRenderLock();
        try {
            lock.lock();
            this.root.markAsDirty();
            this.root.markBoundsDirty();
        }
        finally {
            lock.unlock();
        }
        this.scale = scale;
    }

    public void update() {
        this.drawable.display();
    }

    public void updateProjection(GL2 gl) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho((double)(-this.width / 2.0f * this.scale), (double)(this.width / 2.0f * this.scale), (double)(-this.height / 2.0f * this.scale), (double)(this.height / 2.0f * this.scale), -1.0, 1.0);
    }

    public void applyViewTransforms(GL2 gl) {
        gl.glTranslatef(this.translate.x - this.width / 2.0f, this.translate.y - this.height / 2.0f, 0.0f);
    }

    @Override
    public void init(GLAutoDrawable drawable, VRoot root) {
    }

    @Override
    public void reshape(GLAutoDrawable drawable, float width, float height, VRoot root) {
        this.height = height;
        this.width = width;
    }

    @Override
    public void dispose(GLAutoDrawable drawable) {
    }

    @Override
    public void vSpatialMoved(VSpatial spatial, Point3f localTrans) {
    }
}

