/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import javax.media.opengl.GL2;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.scene.Appearance;
import saf.v3d.scene.EdgeHead;
import saf.v3d.util.Utils3D;

public class ArrowHead2D
implements EdgeHead {
    private float topX;
    private float topY;
    private float botX;
    private float botY;
    private Point3f target;
    private Point3f source;

    public ArrowHead2D(Point3f source, Point3f target) {
        this.target = target;
        this.source = source;
    }

    @Override
    public void update(int edgeWidth) {
        float x1 = this.target.x;
        float y1 = this.target.y;
        float x2 = this.source.x;
        float y2 = this.source.y;
        float lineLen = this.target.distance(this.source);
        float sinTheta = (y1 - y2) / lineLen;
        float cosTheta = (x1 - x2) / lineLen;
        float length = 10.0f;
        float midY = y1 - sinTheta * length / 2.0f;
        float midX = x1 - cosTheta * length / 2.0f;
        double theta = Math.acos(cosTheta);
        double topTheta = theta + 1.5707963267948966;
        double botTheta = theta - 1.5707963267948966;
        double sinTopTheta = Math.sin(topTheta);
        double cosTopTheta = Math.cos(topTheta);
        double sinBotTheta = Math.sin(botTheta);
        double cosBotTheta = Math.cos(botTheta);
        if (y2 > y1) {
            this.topY = (float)((double)midY + sinTopTheta * (double)length / 2.0);
            this.botY = (float)((double)midY + sinBotTheta * (double)length / 2.0);
        } else {
            this.topY = (float)((double)midY - sinTopTheta * (double)length / 2.0);
            this.botY = (float)((double)midY - sinBotTheta * (double)length / 2.0);
        }
        this.topX = (float)((double)midX - cosTopTheta * (double)length / 2.0);
        this.botX = (float)((double)midX - cosBotTheta * (double)length / 2.0);
    }

    @Override
    public void draw(GL2 gl, Appearance appearance) {
        appearance.applyAppearance(gl);
        gl.glBegin(4);
        gl.glVertex2f(this.topX, this.topY);
        gl.glVertex2f(this.target.x, this.target.y);
        gl.glVertex2f(this.botX, this.botY);
        gl.glEnd();
    }

    @Override
    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    @Override
    public boolean intersects(Point3f point) {
        return Utils3D.triangleIntersect(point, new Point3f(this.topX, this.topY, 0.0f), new Point3f(this.target.x, this.target.y, 0.0f), new Point3f(this.botX, this.botY, 0.0f));
    }
}

