/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.render;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLProfile;
import javax.vecmath.Point3f;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.RenderState;

public class Texture2D {
    private static final String TEXT_RECT_ENABLED_KEY = "saf.v3d.tex.rect.enabled";
    private BufferedImage img;
    private Texture texture;
    private BoundingSphere sphere;
    private int listIndex;

    static {
        String prop = System.getProperty(TEXT_RECT_ENABLED_KEY, "false");
        boolean enabled = Boolean.parseBoolean(prop);
        TextureIO.setTexRectEnabled((boolean)enabled);
    }

    public Texture2D(String path) throws IOException {
        this.init(ImageIO.read(new File(path)));
    }

    public Texture2D(String path, float scale) throws IOException {
        this(ImageIO.read(new File(path)), scale);
    }

    public Texture2D(BufferedImage img, float scale) {
        if (scale == 1.0f) {
            this.init(img);
        } else {
            int width = (int)((float)img.getWidth() * scale);
            int height = (int)((float)img.getHeight() * scale);
            BufferedImage scaledImg = new BufferedImage(width, height, img.getType());
            AffineTransform at = AffineTransform.getScaleInstance(scale, scale);
            Graphics2D graphics = scaledImg.createGraphics();
            graphics.drawRenderedImage(img, at);
            graphics.dispose();
            this.init(scaledImg);
        }
    }

    public Texture2D(BufferedImage img) {
        this.init(img);
    }

    private void init(BufferedImage img) {
        this.img = img;
        this.sphere = new BoundingSphere(new Point3f(0.0f, 0.0f, 0.0f), Math.max((float)img.getHeight() / 2.0f, (float)img.getWidth() / 2.0f));
    }

    public void bind(GL2 gl) {
        if (this.texture == null) {
            this.createTexture(gl);
        }
        this.texture.bind((GL)gl);
    }

    public int getTarget(GL2 gl) {
        if (this.texture == null) {
            this.createTexture(gl);
        }
        return this.texture.getTarget();
    }

    public int enable(GL2 gl) {
        if (this.texture == null) {
            this.createTexture(gl);
        }
        this.texture.enable((GL)gl);
        return this.texture.getTarget();
    }

    public void disable(GL2 gl) {
        if (this.texture == null) {
            this.createTexture(gl);
        }
        this.texture.disable((GL)gl);
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void dispose(GL2 gl) {
        if (this.texture != null) {
            this.texture.destroy((GL)gl);
        }
        this.texture = null;
    }

    private void createTexture(GL2 gl) {
        this.texture = AWTTextureIO.newTexture((GLProfile)gl.getGLProfile(), (BufferedImage)this.img, (boolean)true);
        float width = (float)this.texture.getWidth() / 2.0f;
        float height = (float)this.texture.getHeight() / 2.0f;
        this.listIndex = gl.glGenLists(1);
        gl.glNewList(this.listIndex, 4864);
        gl.glBegin(7);
        TextureCoords tc = this.texture.getImageTexCoords();
        gl.glTexCoord2f(tc.left(), tc.bottom());
        gl.glVertex2f(-width, -height);
        gl.glTexCoord2f(tc.right(), tc.bottom());
        gl.glVertex2f(width, -height);
        gl.glTexCoord2f(tc.right(), tc.top());
        gl.glVertex2f(width, height);
        gl.glTexCoord2f(tc.left(), tc.top());
        gl.glVertex2f(-width, height);
        gl.glEnd();
        gl.glEndList();
    }

    public float getWidth() {
        return this.texture.getWidth();
    }

    public float getHeight() {
        return this.texture.getHeight();
    }

    public BoundingSphere getBounds() {
        return this.sphere;
    }

    public void draw(GL2 gl, RenderState rState) {
        gl.glCallList(this.listIndex);
    }
}

