/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.render;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.media.opengl.GL2;
import saf.v3d.render.CompositeTriangleIterator;
import saf.v3d.render.TriangleFanIterator;
import saf.v3d.render.TriangleIterator;
import saf.v3d.render.TriangleQIterator;
import saf.v3d.render.TriangleQSIterator;
import saf.v3d.render.TriangleStripIterator;
import saf.v3d.render.TriangleTriangleIterator;

public class RenderData {
    private FloatBuffer vertices;
    private List<Slice> slices = new ArrayList<Slice>();

    public RenderData(FloatBuffer vertices) {
        this.vertices = vertices;
    }

    public void defineSlice(int mode, int start) {
        this.slices.add(new Slice(mode, start));
        this.sortSlices();
    }

    public void renderImmediate(GL2 gl) {
        this.vertices.rewind();
        this.sortSlices();
        int i = 0;
        int n = this.slices.size();
        while (i < n) {
            Slice slice = this.slices.get(i);
            int startIndex = slice.start;
            int endIndex = i + 1 == n ? this.vertices.limit() : this.slices.get((int)(i + 1)).start;
            gl.glBegin(slice.mode);
            int j = startIndex;
            while (j < endIndex) {
                gl.glVertex3f(this.vertices.get(j), this.vertices.get(j + 1), this.vertices.get(j + 2));
                j += 3;
            }
            gl.glEnd();
            ++i;
        }
    }

    public void renderVBO(GL2 gl) {
        gl.glVertexPointer(3, 5126, 0, 0L);
        int i = 0;
        int n = this.slices.size();
        while (i < n) {
            Slice slice = this.slices.get(i);
            int startIndex = slice.start;
            int endIndex = i + 1 == n ? this.vertices.limit() : this.slices.get((int)(i + 1)).start;
            gl.glDrawArrays(slice.mode, startIndex / 3, (endIndex - startIndex) / 3);
            ++i;
        }
    }

    public FloatBuffer getVertices() {
        return this.vertices;
    }

    private void sortSlices() {
        Collections.sort(this.slices, new Comparator<Slice>(){

            @Override
            public int compare(Slice o1, Slice o2) {
                return o1.start < o2.start ? -1 : (o1.start > o2.start ? 1 : 0);
            }
        });
    }

    public TriangleIterator triangleIterator() {
        this.vertices.rewind();
        this.sortSlices();
        ArrayList<TriangleIterator> iterators = new ArrayList<TriangleIterator>();
        int i = 0;
        int n = this.slices.size();
        while (i < n) {
            Slice slice = this.slices.get(i);
            int startIndex = slice.start;
            int endIndex = i + 1 == n ? this.vertices.limit() : this.slices.get((int)(i + 1)).start;
            int mode = slice.mode;
            float[] buf = new float[endIndex - startIndex];
            this.vertices.position(startIndex);
            this.vertices.get(buf, 0, buf.length);
            if (mode == 5) {
                iterators.add(new TriangleStripIterator(FloatBuffer.wrap(buf)));
            } else if (mode == 6) {
                iterators.add(new TriangleFanIterator(FloatBuffer.wrap(buf)));
            } else if (mode == 4) {
                iterators.add(new TriangleTriangleIterator(FloatBuffer.wrap(buf)));
            } else if (mode == 7) {
                iterators.add(new TriangleQIterator(FloatBuffer.wrap(buf)));
            } else if (mode == 8) {
                iterators.add(new TriangleQSIterator(FloatBuffer.wrap(buf)));
            } else {
                throw new IllegalArgumentException("Unable to create triangle iterator for mode");
            }
            ++i;
        }
        return new CompositeTriangleIterator(iterators);
    }

    private static class Slice {
        int mode;
        int start;

        public Slice(int mode, int start) {
            this.mode = mode;
            this.start = start;
        }
    }
}

