/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.render;

import javax.media.opengl.GL2;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.PolygonRenderer;
import saf.v3d.render.RenderState;
import saf.v3d.render.Shape;
import saf.v3d.render.TriangleIterator;
import saf.v3d.util.Utils3D;

public class PolygonShape
implements Shape {
    protected BoundingSphere bounds;
    protected PolygonRenderer renderer;

    public PolygonShape(PolygonRenderer renderer) {
        this.renderer = renderer;
        this.bounds = Utils3D.createBoundingSphere(renderer.getVertices());
    }

    @Override
    public BoundingSphere getLocalBounds() {
        return this.bounds;
    }

    @Override
    public void render(GL2 gl, RenderState rState) {
        this.renderer.render(gl, rState);
    }

    @Override
    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        TriangleIterator iter = this.renderer.triangleIterator();
        Point3f p0 = new Point3f();
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        while (iter.hasNext()) {
            iter.next(p0, p1, p2);
            if (!Utils3D.triangleIntersect(p0, p1, p2, rayOrigin, rayDirection)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(Point3f point) {
        TriangleIterator iter = this.renderer.triangleIterator();
        Point3f p0 = new Point3f();
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        while (iter.hasNext()) {
            iter.next(p0, p1, p2);
            if (!Utils3D.triangleIntersect(point, p0, p1, p2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invalidate() {
        this.renderer.invalidate();
    }
}

