/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3f;
import saf.v3d.render.TriangleIterator;

public class CompositeTriangleIterator
implements TriangleIterator {
    private List<TriangleIterator> iterators = new ArrayList<TriangleIterator>();
    private int listIndex = 0;
    private TriangleIterator iterator;

    public CompositeTriangleIterator(Collection<TriangleIterator> iterators) {
        this.iterators.addAll(iterators);
        if (iterators.size() > 0) {
            this.iterator = this.iterators.get(0);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public void next(Point3f p1, Point3f p2, Point3f p3) {
        this.iterator.next(p1, p2, p3);
        if (!this.iterator.hasNext()) {
            ++this.listIndex;
            if (this.listIndex < this.iterators.size()) {
                this.iterator = this.iterators.get(this.listIndex);
            }
        }
    }
}

