/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.picking;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import saf.v3d.util.Utils3D;

public class BoundingSphere {
    private Point3f center = new Point3f();
    private float radius;

    public BoundingSphere(Point3f center, float radius) {
        this.center.set((Tuple3f)center);
        this.radius = radius;
    }

    public BoundingSphere(BoundingSphere sphere) {
        this(sphere.center, sphere.radius);
    }

    public Point3f getCenterRef() {
        return this.center;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean intersects(Point3f point) {
        Vector3f vec = new Vector3f();
        vec.sub((Tuple3f)this.center, (Tuple3f)point);
        return vec.lengthSquared() <= this.radius * this.radius;
    }

    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        Vector3f w = new Vector3f((Tuple3f)this.center);
        w.sub((Tuple3f)rayOrigin);
        float wsq = w.dot(w);
        float proj = w.dot(rayDirection);
        float rsq = this.radius * this.radius;
        if (proj < 0.0f && wsq > rsq) {
            return false;
        }
        float vsq = rayDirection.dot(rayDirection);
        return vsq * wsq - proj * proj <= vsq * rsq;
    }

    public BoundingSphere transform(float scale, Quat4f rotate, Vector3f translate) {
        Point3f center = new Point3f(this.center);
        Matrix4f matrix = new Matrix4f();
        matrix.setRotation(rotate);
        matrix.setTranslation(translate);
        matrix.setScale(scale);
        matrix.transform(center);
        this.center = center;
        this.radius *= scale;
        return this;
    }

    public BoundingSphere merge(BoundingSphere sphere) {
        if (sphere.radius == 0.0f) {
            return this;
        }
        Vector3f diff = new Vector3f((Tuple3f)sphere.center);
        diff.sub((Tuple3f)this.center);
        float distSq = diff.dot(diff);
        float radiusDiff = sphere.radius - this.radius;
        if (distSq <= radiusDiff * radiusDiff) {
            if (this.radius > sphere.radius) {
                return this;
            }
            this.center = new Point3f(sphere.center);
            this.radius = sphere.radius;
            return this;
        }
        float dist = (float)Math.sqrt(distSq);
        float radius = 0.5f * (this.radius + sphere.radius + dist);
        if (!Utils3D.isZero(dist)) {
            diff.scale((radius - this.radius) / dist);
            this.center.add((Tuple3f)diff);
        }
        this.radius = radius;
        return this;
    }

    public String toString() {
        return "center: " + this.center + ", radius: " + this.radius;
    }
}

