/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.picking;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import saf.v3d.Canvas;
import saf.v3d.picking.PickEvent;
import saf.v3d.picking.PickListener;
import saf.v3d.scene.VSpatial;
import saf.v3d.util.RayCreator;

public abstract class AbstractPickSupport
extends MouseAdapter {
    protected boolean mousePressed = false;
    protected int x;
    protected int y;
    private int modifiers;
    private List<PickListener> listeners = new ArrayList<PickListener>();
    protected RayCreator rayCreator = new RayCreator();
    protected Canvas canvas;

    public AbstractPickSupport(Canvas canvas) {
        this.canvas = canvas;
    }

    public void addPickListener(PickListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            this.mousePressed = true;
            this.x = e.getX();
            this.y = e.getY();
            this.modifiers = e.getModifiers();
            this.canvas.update();
        }
    }

    protected void firePickEvent(List<VSpatial> items) {
        PickEvent evt = new PickEvent(this.modifiers, items);
        for (PickListener listener : this.listeners) {
            listener.pickPerformed(evt);
        }
    }
}

