/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.grid;

import com.jogamp.common.nio.Buffers;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.grid.GridColorMap;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.RenderState;
import saf.v3d.render.Shape;

public class GridMesh
implements Shape {
    private GridColorMap colorMap;
    private boolean rowMajor;
    private boolean update;
    private FloatBuffer colorBuf;
    private BoundingSphere sphere;
    private int rows;
    private int cols;
    private int major;
    private int minor;
    private int numVertInStrip;
    private float unitSize;
    private int verticesIndex;
    private int colorsIndex;
    private boolean invalid = true;

    public GridMesh(int rows, int cols, float unitSize, GridColorMap colorMap) {
        this.colorMap = colorMap;
        this.rows = rows;
        this.cols = cols;
        this.unitSize = unitSize;
        this.minor = Math.min(rows, cols);
        this.major = Math.max(rows, cols);
        this.numVertInStrip = (this.major + 1) * 2;
        this.rowMajor = rows > cols;
        this.colorBuf = Buffers.newDirectFloatBuffer((int)(this.numVertInStrip * this.minor * 3));
        Point3f center = new Point3f((float)cols * unitSize / 2.0f, (float)rows * unitSize / 2.0f, 0.0f);
        this.sphere = new BoundingSphere(center, center.distance(new Point3f(0.0f, 0.0f, 0.0f)));
    }

    private void initializeVBO(GL gl) {
        int[] vboIndices = new int[2];
        gl.glGenBuffers(vboIndices.length, vboIndices, 0);
        int vertCount = this.numVertInStrip * this.minor;
        FloatBuffer vertices = Buffers.newDirectFloatBuffer((int)(vertCount * 2));
        if (this.rowMajor) {
            int i = 0;
            while (i < this.minor) {
                float x = (float)i * this.unitSize;
                float y = 0.0f;
                int v = 0;
                while (v < this.numVertInStrip / 2) {
                    vertices.put(x);
                    vertices.put(y);
                    vertices.put(x + this.unitSize);
                    vertices.put(y);
                    y += this.unitSize;
                    ++v;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.minor) {
                float y = (float)i * this.unitSize;
                float x = 0.0f;
                int v = 0;
                while (v < this.numVertInStrip / 2) {
                    vertices.put(x);
                    vertices.put(y);
                    vertices.put(x);
                    vertices.put(y + this.unitSize);
                    x += this.unitSize;
                    ++v;
                }
                ++i;
            }
        }
        this.verticesIndex = vboIndices[0];
        vertices.rewind();
        gl.glBindBuffer(34962, this.verticesIndex);
        gl.glBufferData(34962, (long)(vertCount * 2 * 4), (Buffer)vertices, 35044);
        this.updateColors();
        this.colorsIndex = vboIndices[1];
        gl.glBindBuffer(34962, this.colorsIndex);
        this.colorBuf.rewind();
        gl.glBufferData(34962, (long)(this.colorBuf.limit() * 4), (Buffer)this.colorBuf, 35048);
        this.invalid = false;
    }

    public void update() {
        this.update = true;
        this.updateColors();
    }

    private void updateColors() {
        this.colorBuf.rewind();
        Color3f color = new Color3f();
        if (this.rowMajor) {
            int min = 0;
            while (min < this.minor) {
                int x = min;
                int y = 0;
                this.colorMap.getColor(x, y, color);
                this.colorBuf.put(color.x);
                this.colorBuf.put(color.y);
                this.colorBuf.put(color.z);
                this.colorBuf.put(color.x);
                this.colorBuf.put(color.y);
                this.colorBuf.put(color.z);
                int i = 2;
                while (i < this.numVertInStrip) {
                    this.colorMap.getColor(x, y, color);
                    this.colorBuf.put(color.x);
                    this.colorBuf.put(color.y);
                    this.colorBuf.put(color.z);
                    this.colorBuf.put(color.x);
                    this.colorBuf.put(color.y);
                    this.colorBuf.put(color.z);
                    i += 2;
                    ++y;
                }
                ++min;
            }
        } else {
            int min = 0;
            while (min < this.minor) {
                int y = min;
                int x = 0;
                this.colorMap.getColor(x, y, color);
                this.colorBuf.put(color.x);
                this.colorBuf.put(color.y);
                this.colorBuf.put(color.z);
                this.colorBuf.put(color.x);
                this.colorBuf.put(color.y);
                this.colorBuf.put(color.z);
                int i = 2;
                while (i < this.numVertInStrip) {
                    this.colorMap.getColor(x, y, color);
                    this.colorBuf.put(color.x);
                    this.colorBuf.put(color.y);
                    this.colorBuf.put(color.z);
                    this.colorBuf.put(color.x);
                    this.colorBuf.put(color.y);
                    this.colorBuf.put(color.z);
                    i += 2;
                    ++x;
                }
                ++min;
            }
        }
    }

    @Override
    public BoundingSphere getLocalBounds() {
        return this.sphere;
    }

    @Override
    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    @Override
    public boolean intersects(Point3f point) {
        return point.x >= 0.0f && point.x <= (float)this.cols * this.unitSize && point.y >= 0.0f && point.y <= (float)this.rows * this.unitSize;
    }

    public int[] getCellLocation(Point3f point) {
        if (this.intersects(point)) {
            int x = (int)Math.floor(point.x / this.unitSize);
            int y = (int)Math.floor(point.y / this.unitSize);
            return new int[]{x, y};
        }
        return null;
    }

    @Override
    public void render(GL2 gl, RenderState state) {
        if (this.invalid) {
            this.initializeVBO((GL)gl);
        }
        gl.glShadeModel(7424);
        gl.glBindBuffer(34962, this.verticesIndex);
        gl.glVertexPointer(2, 5126, 0, 0L);
        gl.glEnableClientState(32884);
        gl.glBindBuffer(34962, this.colorsIndex);
        if (this.update) {
            this.colorBuf.rewind();
            gl.glBufferSubData(34962, 0L, (long)(this.colorBuf.limit() * 4), (Buffer)this.colorBuf);
            this.update = false;
        }
        gl.glColorPointer(3, 5126, 0, 0L);
        gl.glEnableClientState(32886);
        int major = Math.max(this.rows, this.cols);
        int minor = Math.min(this.rows, this.cols);
        int vertsInStrip = (major + 1) * 2;
        int i = 0;
        while (i < minor) {
            gl.glDrawArrays(5, vertsInStrip * i, vertsInStrip);
            ++i;
        }
        gl.glDisableClientState(32884);
        gl.glDisableClientState(32886);
        gl.glShadeModel(7425);
        state.vboIndex = this.colorsIndex;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }
}

