/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.event;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import saf.v3d.event.InputHandler;
import saf.v3d.scene.VSpatial;

public class MouseRotate
extends InputHandler {
    private float prevMouseX;
    private float prevMouseY;
    private float rotX;
    private float rotY;
    private float ox;
    private float oy;
    private GLAutoDrawable canvas;

    public MouseRotate(GLAutoDrawable canvas, float rotX, float rotY) {
        this.canvas = canvas;
        this.rotX = this.ox = rotX;
        this.rotY = this.oy = rotY;
    }

    public void process(GL2 gl) {
        gl.glRotatef(-this.rotX, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(this.rotY, 0.0f, 1.0f, 0.0f);
    }

    public void process(VSpatial node) {
        Quat4f xQuat = new Quat4f();
        xQuat.set(new AxisAngle4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(-this.rotX)));
        Quat4f yQuat = new Quat4f();
        yQuat.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(this.rotY)));
        yQuat.mul(xQuat);
        AxisAngle4f angle = new AxisAngle4f();
        angle.set(yQuat);
        node.rotate((float)Math.toDegrees(angle.angle), angle.x, angle.y, angle.z);
    }

    public void reset() {
        this.rotX = this.ox;
        this.rotY = this.oy;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if ((evt.getModifiers() & 0x10) != 0 && this.isEnabled) {
            this.prevMouseX = evt.getX();
            this.prevMouseY = evt.getY();
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if ((evt.getModifiers() & 0x10) != 0 && !evt.isAltDown() && this.isEnabled) {
            int x = evt.getX();
            int y = evt.getY();
            Dimension size = evt.getComponent().getSize();
            float thetaY = 360.0f * (((float)x - this.prevMouseX) / (float)size.width);
            float thetaX = 360.0f * ((this.prevMouseY - (float)y) / (float)size.height);
            this.prevMouseX = x;
            this.prevMouseY = y;
            this.rotX += thetaX;
            this.rotY += thetaY;
            this.canvas.display();
        }
    }

    public String toString() {
        return String.format("Rotate: rotx: %f, roty: %f, rotz: %f", Float.valueOf(this.rotX), Float.valueOf(this.rotY), Float.valueOf(0.0f));
    }
}

