/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d;

import com.jogamp.common.nio.Buffers;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.vecmath.Point3f;
import saf.v3d.AppearanceFactory;
import saf.v3d.CanvasListener;
import saf.v3d.NamedShapeCreator;
import saf.v3d.render.DisplayListRenderer;
import saf.v3d.render.LineListRenderer;
import saf.v3d.render.Renderer;
import saf.v3d.render.Texture2D;
import saf.v3d.scene.VComposite;
import saf.v3d.scene.VImage2D;
import saf.v3d.scene.VNode;
import saf.v3d.scene.VRoot;
import saf.v3d.scene.VShape;
import saf.v3d.scene.VSpatial;
import saf.v3d.util.BezierCurveTessellator;
import saf.v3d.util.Tessellator;

public class ShapeFactory2D
implements CanvasListener {
    private Map<String, Texture2D> textureCache = new HashMap<String, Texture2D>();
    private Map<Object, Renderer> rendererCache = new HashMap<Object, Renderer>();
    private Map<String, ShapeCreator> namedShapes = new HashMap<String, ShapeCreator>();
    private Tessellator tessellator = new Tessellator();

    public void invalidateRenderers(GL2 gl) {
        for (Renderer renderer : this.rendererCache.values()) {
            renderer.dispose(gl);
        }
        for (Renderer renderer : this.rendererCache.values()) {
            renderer.invalidate();
        }
    }

    public NamedShapeCreator createNamedShape(String name) {
        return new ShapeCreator(name, this);
    }

    public void registerImage(String name, BufferedImage img) {
        this.registerImage(name, img, 1.0f);
    }

    public void registerImage(String name, BufferedImage img, float scale) {
        this.namedShapes.remove(name);
        Texture2D data = this.textureCache.get(name);
        if (data == null) {
            data = new Texture2D(img, scale);
            this.textureCache.put(name, data);
        }
    }

    public void registerImage(String name, String path) throws IOException {
        this.registerImage(name, path, 1.0f);
    }

    public void registerImage(String name, String path, float scale) throws IOException {
        this.namedShapes.remove(name);
        Texture2D data = this.textureCache.get(name);
        if (data == null) {
            data = new Texture2D(path, scale);
            this.textureCache.put(name, data);
        }
    }

    public boolean isNameRegistered(String name) {
        return this.namedShapes.containsKey(name) || this.textureCache.containsKey(name);
    }

    public VSpatial getNamedSpatial(String name) {
        if (this.namedShapes.containsKey(name)) {
            return this.getNamedShape(name);
        }
        if (this.textureCache.containsKey(name)) {
            return new VImage2D(this.textureCache.get(name));
        }
        return null;
    }

    private VNode getNamedShape(String name) {
        ShapeCreator creator = this.namedShapes.get(name);
        return creator.createShape();
    }

    private void registerNamedShape(String name, ShapeCreator creator) {
        this.textureCache.remove(name);
        this.namedShapes.put(name, creator);
    }

    public VImage2D createImage(String path) throws IOException {
        return this.createImage(path, 1.0f);
    }

    public VImage2D createImage(String path, float scale) throws IOException {
        String key = String.valueOf(path) + scale;
        Texture2D data = this.textureCache.get(key);
        if (data == null) {
            data = new Texture2D(path, scale);
            this.textureCache.put(key, data);
        }
        return new VImage2D(data);
    }

    public VImage2D createImage(String id, BufferedImage img) {
        Texture2D data = this.textureCache.get(id);
        if (data == null) {
            data = new Texture2D(img);
            this.textureCache.put(id, data);
        }
        return new VImage2D(data);
    }

    public VShape createRectangle(int width, int height) {
        return this.createRectangle(width, height, true);
    }

    public VShape createRectangle(int width, int height, boolean colorUpdatable) {
        return this.createShape(new Rectangle2D.Float((float)(-width) / 2.0f, (float)(-height) / 2.0f, width, height), colorUpdatable);
    }

    private boolean isClosed(Path2D path) {
        float[] coords = new float[6];
        int ret = 3;
        PathIterator iter = path.getPathIterator(null);
        while (!iter.isDone()) {
            ret = iter.currentSegment(coords);
            iter.next();
        }
        return ret == 4;
    }

    private LineListRenderer createLineRenderer(Path2D path) {
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Integer> moveToIndices = new ArrayList<Integer>();
        float[] coords = new float[6];
        int vertIndex = 0;
        PathIterator iter = path.getPathIterator(null);
        while (!iter.isDone()) {
            int ret = iter.currentSegment(coords);
            if (ret == 0 || ret == 1) {
                if (ret == 0) {
                    moveToIndices.add(vertIndex);
                }
                vertices.add(Float.valueOf(coords[0]));
                vertices.add(Float.valueOf(coords[1]));
                vertices.add(Float.valueOf(0.0f));
                vertIndex += 3;
            } else if (ret == 3) {
                int vertsSize = vertices.size();
                Point3f a = new Point3f(((Float)vertices.get(vertsSize - 3)).floatValue(), ((Float)vertices.get(vertsSize - 2)).floatValue(), 0.0f);
                Point3f b = new Point3f(coords[0], coords[1], 0.0f);
                Point3f c = new Point3f(coords[2], coords[3], 0.0f);
                Point3f d = new Point3f(coords[4], coords[5], 0.0f);
                float[] verts = new BezierCurveTessellator(a, b, c, d).tessellate(20);
                int i = 0;
                int n = verts.length;
                while (i < n) {
                    vertices.add(Float.valueOf(verts[i]));
                    vertices.add(Float.valueOf(verts[i + 1]));
                    vertices.add(Float.valueOf(0.0f));
                    i += 2;
                }
                vertices.add(Float.valueOf(d.x));
                vertices.add(Float.valueOf(d.y));
                vertices.add(Float.valueOf(0.0f));
            } else if (ret != 4) {
                throw new IllegalArgumentException("Quadratic curves are not yet supported.");
            }
            iter.next();
        }
        FloatBuffer buf = Buffers.newDirectFloatBuffer((int)vertices.size());
        for (Float val : vertices) {
            buf.put(val.floatValue());
        }
        int[] moveTos = new int[moveToIndices.size()];
        int i = 0;
        for (Integer val : moveToIndices) {
            moveTos[i++] = val;
        }
        return new LineListRenderer(buf, moveTos);
    }

    public VShape createShape(Shape shape) {
        return this.createShape(shape, true);
    }

    public VShape createShape(Shape shape, boolean colorUpdateable) {
        return new VShape(this.createRenderer(shape).createShape(), colorUpdateable);
    }

    private Renderer createRenderer(Shape shape) {
        Renderer renderer = this.rendererCache.get(shape);
        if (renderer == null) {
            Path2D.Float path = new Path2D.Float(shape);
            Rectangle2D bounds = path.getBounds2D();
            renderer = bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0 ? this.createLineRenderer(path) : (this.isClosed(path) ? this.tessellator.createRenderer(path) : this.createLineRenderer(path));
            if (renderer.getVertices().limit() == 0) {
                renderer = this.createLineRenderer(path);
            }
            this.rendererCache.put(shape, renderer);
        }
        return renderer;
    }

    private Renderer createLineRenderer(Shape shape) {
        Renderer renderer = this.rendererCache.get(shape);
        if (renderer == null) {
            renderer = this.createLineRenderer(new Path2D.Float(shape));
            this.rendererCache.put(shape, renderer);
        }
        return renderer;
    }

    public void dispose() {
        this.textureCache.clear();
        this.rendererCache.clear();
        this.namedShapes.clear();
    }

    @Override
    public void dispose(GLAutoDrawable drawable) {
        if (drawable.getContext() != null) {
            GL2 gl = drawable.getGL().getGL2();
            for (Texture2D texture : this.textureCache.values()) {
                texture.dispose(gl);
            }
            for (Renderer renderer : this.rendererCache.values()) {
                renderer.dispose(gl);
            }
        }
        this.textureCache.clear();
        this.rendererCache.clear();
    }

    private FloatBuffer createCircleGeom(float radius, int slices) {
        int count = (slices + 2) * 3;
        FloatBuffer buf = Buffers.newDirectFloatBuffer((int)count);
        buf.put(0.0f);
        buf.put(0.0f);
        buf.put(0.0f);
        float interval = (float)(Math.PI * 2 / (double)slices);
        int s = slices;
        while (s >= 0) {
            float angle = 0.0f;
            if (s != slices) {
                angle = (float)s * interval;
            }
            float sa = (float)Math.sin(angle);
            float ca = (float)Math.cos(angle);
            buf.put(sa * radius);
            buf.put(ca * radius);
            buf.put(0.0f);
            --s;
        }
        buf.rewind();
        return buf;
    }

    public VShape createCircle(float radius, int slices) {
        return this.createCircle(radius, slices, true);
    }

    public VShape createCircle(float radius, int slices, boolean colorUpdatable) {
        String key = "circle:" + radius + ":" + slices;
        Renderer renderer = this.rendererCache.get(key);
        if (renderer == null) {
            FloatBuffer buf = this.createCircleGeom(radius, slices);
            renderer = new DisplayListRenderer(buf, 6);
            this.rendererCache.put(key, renderer);
        }
        return new VShape(renderer.createShape(), colorUpdatable);
    }

    @Override
    public void init(GLAutoDrawable drawable, VRoot root) {
    }

    @Override
    public void reshape(GLAutoDrawable drawable, float width, float height, VRoot root) {
    }

    @Override
    public void vSpatialMoved(VSpatial spatial, Point3f localTrans) {
    }

    private static class ShapeCreator
    implements NamedShapeCreator {
        private String name;
        private List<ShapeProperties> shapes = new ArrayList<ShapeProperties>();
        private List<VShapeProperties> vShapeProps = new ArrayList<VShapeProperties>();
        private ShapeFactory2D shapeFactory;

        public ShapeCreator(String name, ShapeFactory2D factory) {
            this.name = name;
            this.shapeFactory = factory;
        }

        VNode createShape() {
            VComposite node = null;
            for (VShapeProperties data : this.vShapeProps) {
                VShape shape = new VShape(data.renderer.createShape(), data.colorUpdateable);
                shape.setAppearance(AppearanceFactory.createColorAppearance(data.color));
                if (node == null) {
                    node = new VNode(shape);
                    continue;
                }
                node.addChild(shape);
            }
            return node;
        }

        @Override
        public void addShape(Shape shape, Color color, boolean canUpdateColor) {
            Rectangle2D bounds = shape.getBounds2D();
            if (!(bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0 || bounds.getWidth() < 0.0 || bounds.getHeight() < 0.0)) {
                this.shapes.add(new ShapeProperties(shape, color, false, canUpdateColor));
            }
        }

        @Override
        public void addLine(Shape shape, Color color, boolean canUpdateColor) {
            this.shapes.add(new ShapeProperties(shape, color, true, canUpdateColor));
        }

        @Override
        public void registerShape() {
            RectangularShape bounds = null;
            for (ShapeProperties shapeData : this.shapes) {
                if (bounds == null) {
                    bounds = new Rectangle2D.Float();
                    ((Rectangle2D.Float)bounds).setRect(shapeData.shape.getBounds2D());
                }
                ((Rectangle2D)bounds).add(shapeData.shape.getBounds2D());
            }
            AffineTransform trans = AffineTransform.getTranslateInstance(-bounds.getCenterX(), -bounds.getCenterY());
            for (ShapeProperties shapeData : this.shapes) {
                Shape newShape = trans.createTransformedShape(shapeData.shape);
                Renderer renderer = null;
                renderer = shapeData.isLine ? this.shapeFactory.createLineRenderer(newShape) : this.shapeFactory.createRenderer(newShape);
                this.vShapeProps.add(new VShapeProperties(renderer, shapeData.color, shapeData.colorUpdatable));
            }
            this.shapeFactory.registerNamedShape(this.name, this);
        }

        private static class ShapeProperties {
            Shape shape;
            Color color;
            boolean isLine;
            boolean colorUpdatable;

            public ShapeProperties(Shape shape, Color color, boolean isLine, boolean colorUpdatable) {
                this.shape = shape;
                this.color = color;
                this.isLine = isLine;
                this.colorUpdatable = colorUpdatable;
            }
        }

        private static class VShapeProperties {
            Renderer renderer;
            Color color;
            boolean colorUpdateable;

            public VShapeProperties(Renderer renderer, Color color, boolean colorUpdateable) {
                this.renderer = renderer;
                this.color = color;
                this.colorUpdateable = colorUpdateable;
            }
        }
    }
}

