/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d;

import javax.media.opengl.GL2;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.RenderState;
import saf.v3d.render.Shape;

public class BoxShape2D
implements Shape {
    private float width;
    private float height;
    private BoundingSphere sphere;
    private int listIndex;
    private boolean invalid = true;

    public BoxShape2D(float width, float height) {
        this.width = width;
        this.height = height;
        float radius = Math.max(width / 2.0f, height / 2.0f);
        this.sphere = new BoundingSphere(new Point3f(width / 2.0f, height / 2.0f, 0.0f), radius);
    }

    private void initDL(GL2 gl) {
        this.listIndex = gl.glGenLists(1);
        gl.glNewList(this.listIndex, 4864);
        gl.glBegin(2);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, this.height, 0.0f);
        gl.glVertex3f(this.width, this.height, 0.0f);
        gl.glVertex3f(this.width, 0.0f, 0.0f);
        gl.glEnd();
        gl.glEndList();
        this.invalid = false;
    }

    @Override
    public BoundingSphere getLocalBounds() {
        return this.sphere;
    }

    @Override
    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        return false;
    }

    @Override
    public boolean intersects(Point3f point) {
        return false;
    }

    @Override
    public void render(GL2 gl, RenderState state) {
        if (this.invalid) {
            this.initDL(gl);
        }
        state.appearance.applyAppearance(gl);
        gl.glLineWidth(1.0f);
        state.lineWidth = 1;
        gl.glCallList(this.listIndex);
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }
}

