/*
 * Decompiled with CFR 0.152.
 */
package simphony.util.messages;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import simphony.util.messages.MessageEvent;
import simphony.util.messages.TaskMessage;
import simphony.util.messages.TaskMessageCallback;
import simphony.util.messages.TaskMessageListener;

public class StackTaskMessageListener
extends TaskMessageListener {
    Stack<TaskMessage> messageStack = new Stack();
    Set<Object> targetSet = new HashSet<Object>();
    TaskMessageCallback callback;

    public StackTaskMessageListener(TaskMessageCallback callback) {
        this.callback = callback;
    }

    @Override
    protected synchronized void processTaskMessage(TaskMessage message) {
        if (message.getStatus().equals((Object)TaskMessage.TaskStatus.STARTED)) {
            this.callback.working(true, message.getMessage());
            this.targetSet.add(message.getKey());
            this.messageStack.push(message);
        } else if (message.getStatus().equals((Object)TaskMessage.TaskStatus.WORKING)) {
            this.callback.working(true, message.getMessage());
        } else {
            this.targetSet.remove(message.getKey());
            if (this.targetSet.size() == 0) {
                this.callback.working(false, "");
            } else {
                this.callback.working(true, this.nextMessage(message));
            }
        }
    }

    private String nextMessage(TaskMessage message) {
        Object key = message.getKey();
        if (this.messageStack.size() > 0) {
            if (this.messageStack.peek().getKey().equals(key)) {
                this.messageStack.pop();
            }
            while (this.messageStack.size() > 0) {
                if (this.targetSet.contains(this.messageStack.peek().getKey())) break;
                this.messageStack.pop();
            }
        }
        if (this.messageStack.size() > 0) {
            return this.messageStack.peek().getMessage();
        }
        return null;
    }

    @Override
    public void messageReceived(MessageEvent arg0) {
        if (arg0.getMessage() instanceof TaskMessage) {
            this.processTaskMessage((TaskMessage)arg0.getMessage());
        }
    }
}

