/*
 * Decompiled with CFR 0.152.
 */
package simphony.util.messages;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import simphony.util.messages.MessageCenter;
import simphony.util.messages.MessageEvent;
import simphony.util.messages.MessageEventListener;

public class Log4jMessageListener
implements MessageEventListener {
    public static final String INTERNAL_ANCHOR = "MessageCenter.INTERNAL";
    public static final String CONFIG_FILE_NAME = "MessageCenter.log4j.properties";
    private Logger logger;

    static {
        if (new File(CONFIG_FILE_NAME).exists()) {
            PropertyConfigurator.configure((String)CONFIG_FILE_NAME);
        }
    }

    private static Logger getLogger(String name) {
        return Logger.getLogger((String)("MessageCenter.INTERNAL." + name));
    }

    public Log4jMessageListener(Class clazz) {
        this.logger = Log4jMessageListener.getLogger(clazz.getName());
    }

    public Log4jMessageListener(String name) {
        this.logger = Log4jMessageListener.getLogger(name);
    }

    public Log4jMessageListener() {
        this.logger = Logger.getLogger((String)INTERNAL_ANCHOR);
    }

    @Override
    public void messageReceived(MessageEvent event) {
        if (event.getThrowable() != null) {
            this.logger.log((Priority)event.getLevel(), (Object)this.getMessage(event), event.getThrowable());
        } else {
            this.logger.log((Priority)event.getLevel(), (Object)this.getMessage(event));
        }
    }

    protected String getMessage(MessageEvent event) {
        String message = event.getMessage() == null ? "null" : event.getMessage().toString();
        Object[] metaData = event.getMetaData();
        if (metaData != null && metaData.length > 0) {
            message = String.valueOf(message) + " metaData=" + Arrays.toString(metaData);
        }
        return message;
    }

    public static void loadDefaultSettings() {
        PropertyConfigurator.configure((URL)Log4jMessageListener.class.getResource(CONFIG_FILE_NAME));
    }

    public static void main(String[] args) {
        Log4jMessageListener.loadDefaultSettings();
        MessageCenter.getMessageCenter(Log4jMessageListener.class).fatal("blas", null, new Object[0]);
    }
}

