/*
 * Decompiled with CFR 0.152.
 */
package simphony.util.messages;

import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Level;
import simphony.util.messages.MessageEvent;
import simphony.util.messages.MessageEventListener;

public abstract class AbstractMessageListener
implements MessageEventListener {
    private HashSet<Level> listeningLevels = new HashSet();

    public AbstractMessageListener() {
    }

    public AbstractMessageListener(Level ... listeningLevels) {
        this();
        Level[] levelArray = listeningLevels;
        int n = listeningLevels.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            this.listeningLevels.add(level);
            ++n2;
        }
    }

    public AbstractMessageListener(Iterable<Level> listeningLevels) {
        this();
        for (Level level : listeningLevels) {
            this.listeningLevels.add(level);
        }
    }

    @Override
    public void messageReceived(MessageEvent event) {
        if (this.listeningLevels.size() == 0 || this.listeningLevels.contains(event.getLevel())) {
            this.handleMessage(event);
        }
    }

    public void addListeningLevel(Level level) {
        this.listeningLevels.add(level);
    }

    public void removeListeningLevel(Level level) {
        this.listeningLevels.remove(level);
    }

    public Collection getListeningLevels() {
        return this.listeningLevels;
    }

    protected abstract void handleMessage(MessageEvent var1);
}

