/*
 * Decompiled with CFR 0.152.
 */
package simphony.util.error;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import simphony.util.error.ErrorEvent;
import simphony.util.error.ErrorHandler;

public class ErrorCenter {
    private static List<ErrorHandler> errorHandlers = new ArrayList<ErrorHandler>();

    public static ErrorCenter getErrorCenter() {
        return new ErrorCenter();
    }

    private ErrorCenter() {
    }

    public boolean error(int errorCode, Object info, Throwable error, Object ... metaData) {
        return this.fireErrorEvent(errorCode, info, error, metaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireErrorEvent(int errorCode, Object info, Throwable error, Object ... metaData) {
        ErrorEvent event = new ErrorEvent(error, errorCode, info, metaData);
        boolean handled = false;
        List<ErrorHandler> list = errorHandlers;
        synchronized (list) {
            for (ErrorHandler listener : errorHandlers) {
                if (!listener.handleError(event)) continue;
                handled = true;
            }
        }
        if (!handled) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new RuntimeException(error);
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorHandler(ErrorHandler handler) {
        List<ErrorHandler> list = errorHandlers;
        synchronized (list) {
            errorHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorHandler(ErrorHandler handler) {
        List<ErrorHandler> list = errorHandlers;
        synchronized (list) {
            errorHandlers.remove(handler);
        }
    }

    public Collection<ErrorHandler> getErrorHandlers() {
        return Collections.unmodifiableCollection(errorHandlers);
    }
}

