/*
 * Decompiled with CFR 0.152.
 */
package simphony.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import simphony.util.messages.MessageCenter;

public class ThreadUtilities {
    private static Lock rieLock = new ReentrantLock();
    private static Lock riewLock = new ReentrantLock();

    public static void runInEventThread(Runnable runnable) {
        rieLock.lock();
        if (EventQueue.isDispatchThread()) {
            new Runner(rieLock, runnable).run();
        } else {
            EventQueue.invokeLater(runnable);
            rieLock.unlock();
        }
    }

    public static synchronized void runLaterInEventThread(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void runInEventThreadAndWait(Runnable runnable) {
        try {
            riewLock.lock();
            if (EventQueue.isDispatchThread()) {
                new Runner(riewLock, runnable).run();
            } else {
                EventQueue.invokeAndWait(runnable);
                riewLock.unlock();
            }
        }
        catch (InvocationTargetException e) {
            riewLock.unlock();
            MessageCenter.getMessageCenter(ThreadUtilities.class).error("Error in invokeAndWait", e, new Object[0]);
        }
        catch (InterruptedException e) {
            riewLock.unlock();
            MessageCenter.getMessageCenter(ThreadUtilities.class).error("Error in invokeAndWait", e, new Object[0]);
        }
    }

    private static class Runner {
        private Runnable runnable;
        private Lock lock;

        private Runner(Lock lock, Runnable runnable) {
            this.lock = lock;
            this.runnable = runnable;
        }

        public void run() {
            this.lock.unlock();
            this.runnable.run();
        }
    }
}

