/*
 * Decompiled with CFR 0.152.
 */
package simphony.settings;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import simphony.settings.SettingsIO;

public class SettingsRegistry
extends Hashtable<String, Object> {
    public static final String REGISTRY_ID_KEY = "SettingsRegistryId";
    private static final long serialVersionUID = 1315247041894184896L;
    private static final Map<String, SettingsRegistry> registryMap = new HashMap<String, SettingsRegistry>();
    private SettingsRegistry next;

    public SettingsRegistry(String registryId) {
        if (registryId != null) {
            this.putHere(REGISTRY_ID_KEY, registryId);
        }
    }

    public synchronized void setRegistryId(String registryId) {
        this.putHere(REGISTRY_ID_KEY, registryId);
    }

    public synchronized String getRegistryId() {
        return super.get(REGISTRY_ID_KEY).toString();
    }

    @Override
    public synchronized Object get(Object key) {
        Object superResult = super.get(key);
        if (superResult != null) {
            return superResult;
        }
        if (this.next != null) {
            return this.next.get(key);
        }
        return null;
    }

    @Override
    public synchronized Object put(String key, Object value) {
        SettingsRegistry regWithKey = this.findRegistryWithKey(key);
        if (regWithKey != null) {
            return regWithKey.putHere(key, value);
        }
        return this.putHere(key, value);
    }

    public synchronized Object putHere(String key, Object value) {
        return super.put(key, value);
    }

    protected SettingsRegistry findRegistryWithKey(String key) {
        if (super.get(key) != null) {
            return this;
        }
        if (this.next == null) {
            return null;
        }
        SettingsRegistry regWithKey = this.next.findRegistryWithKey(key);
        if (regWithKey != null) {
            return regWithKey;
        }
        return null;
    }

    public synchronized SettingsRegistry getNext() {
        return this.next;
    }

    public synchronized void setNext(SettingsRegistry next) {
        this.next = next;
    }

    public static SettingsRegistry getRegistry(String registryId, String fileName) {
        SettingsRegistry registry = registryMap.get(registryId);
        if (registry != null) {
            return registry;
        }
        try {
            registry = SettingsIO.loadSettings(registryId, fileName);
        }
        catch (Exception ex) {
            registry = new SettingsRegistry(registryId);
        }
        return SettingsRegistry.register(registry);
    }

    public static SettingsRegistry getRegistry(String registryId) {
        return registryMap.get(registryId);
    }

    public static SettingsRegistry register(SettingsRegistry registry) {
        registryMap.put(registry.getRegistryId(), registry);
        return registry;
    }
}

