/*
 * Decompiled with CFR 0.152.
 */
package simphony.settings;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import simphony.settings.SettingsRegistry;

public class SettingsIO {
    public static final String SETTINGS_FILE_NAME = "SettingsFileName";
    public static boolean USE_DOM_DRIVER = false;

    private static XStream getXStream() {
        if (USE_DOM_DRIVER) {
            return new XStream((HierarchicalStreamDriver)new DomDriver());
        }
        return new XStream();
    }

    public static SettingsRegistry loadSettings(String registryId, String fileName) {
        XStream xstream = SettingsIO.getXStream();
        SettingsRegistry registry = null;
        File settingsFile = new File(fileName);
        if (!settingsFile.exists()) {
            registry = new SettingsRegistry(registryId);
        } else {
            try {
                registry = (SettingsRegistry)xstream.fromXML((Reader)new FileReader(fileName));
            }
            catch (FileNotFoundException ex) {
                registry = new SettingsRegistry(registryId);
            }
            registry.setRegistryId(registryId);
            registry.put(SETTINGS_FILE_NAME, (Object)fileName);
        }
        return registry;
    }

    public static void storeSettings(SettingsRegistry registry, String fileName) throws IOException {
        XStream xstream = SettingsIO.getXStream();
        SettingsRegistry nextRegistry = registry.getNext();
        xstream.toXML((Object)registry, (Writer)new FileWriter(fileName));
        registry.setNext(nextRegistry);
    }
}

