/*
 * Decompiled with CFR 0.152.
 */
package saf.core.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.java.plugin.JpfException;
import org.java.plugin.ObjectFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.DefaultPluginsCollector;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.util.ExtendedProperties;
import org.xml.sax.SAXException;
import saf.core.runtime.PluginAttributes;
import saf.core.runtime.PluginReader;
import saf.core.runtime.SimpleAttribute;
import simphony.util.messages.MessageCenter;

public class Boot {
    private static final String PLUGIN_FOLDER_PROP = "pluginFolders";
    private static final String PLUGIN_DESCRIPTOR_PROP = "plugin.descriptors";
    private static String RUNTIME_DIR_ROOT = "./";
    private static String PLUGIN_RESTRICT_PREFIX = "plugin.restrict.";
    private static final String CORE_PLUGIN_ID = "saf.core.runtime";
    private MessageCenter center = MessageCenter.getMessageCenter(Boot.class);

    public PluginManager init(String[] args) {
        if (args.length > 1) {
            RUNTIME_DIR_ROOT = args[1];
        }
        System.setProperty("applicationRoot", RUNTIME_DIR_ROOT);
        this.center = MessageCenter.getMessageCenter(Boot.class);
        try {
            Properties props = new Properties();
            File file = new File(RUNTIME_DIR_ROOT, "boot.properties");
            InputStream strm = file.exists() ? new FileInputStream(file) : this.getClass().getClassLoader().getResourceAsStream("boot.properties");
            try {
                props.load(strm);
            }
            finally {
                strm.close();
            }
            props.put("applicationRoot", RUNTIME_DIR_ROOT);
            return this.initializePluginManager(this.findPluginLocations(props), props);
        }
        catch (Exception ex) {
            this.center.error(ex.getMessage(), ex, new Object[0]);
            return null;
        }
    }

    private void run(PluginManager pluginManager, String[] args) {
        try {
            Plugin corePlugin = pluginManager.getPlugin(CORE_PLUGIN_ID);
            if (corePlugin == null) {
                throw new Exception("Cannot find core plugin");
            }
            corePlugin.getClass().getMethod("run", String[].class).invoke((Object)corePlugin, new Object[]{args});
        }
        catch (Exception ex) {
            this.center.error(ex.getMessage(), ex, new Object[0]);
        }
    }

    private PluginManager initializePluginManager(Collection locations, Properties props) throws JpfException, IOException, ParserConfigurationException, SAXException {
        ObjectFactory fac = ObjectFactory.newInstance((ExtendedProperties)new ExtendedProperties(props));
        PluginManager pluginManager = fac.createManager();
        ArrayList<PluginManager.PluginLocation> validLocations = new ArrayList<PluginManager.PluginLocation>();
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>();
        for (Object key : props.keySet()) {
            if (!key.toString().startsWith(PLUGIN_RESTRICT_PREFIX)) continue;
            String strKey = key.toString();
            String restrictId = strKey.substring(strKey.lastIndexOf(".") + 1, strKey.length());
            String restrictVal = props.getProperty(strKey);
            restrictions.add(new Restriction(restrictId, restrictVal));
        }
        if (restrictions.size() > 0) {
            for (PluginManager.PluginLocation location : locations) {
                PluginReader reader = new PluginReader(location.getManifestLocation());
                PluginAttributes pluginAttribs = reader.parse();
                boolean pass = true;
                for (Restriction restriction : restrictions) {
                    if (restriction.pass(pluginAttribs)) continue;
                    pass = false;
                    break;
                }
                if (!pass) continue;
                validLocations.add(location);
            }
        } else {
            validLocations.addAll(locations);
        }
        Map map = pluginManager.publishPlugins(validLocations.toArray(new PluginManager.PluginLocation[validLocations.size()]));
        IntegrityCheckReport integrityCheckReport = pluginManager.getRegistry().checkIntegrity(pluginManager.getPathResolver(), true);
        if (integrityCheckReport.countErrors() != 0) {
            this.center.fatal(this.integrityCheckReport2str(integrityCheckReport), new RuntimeException("Invalid plugin configuration"), new Object[0]);
            System.exit(1);
        }
        for (Identity id : map.values()) {
            PluginDescriptor desc = pluginManager.getRegistry().getPluginDescriptor(id.getId());
            pluginManager.getPluginClassLoader(desc);
        }
        return pluginManager;
    }

    private String integrityCheckReport2str(IntegrityCheckReport report) {
        StringBuffer buf = new StringBuffer();
        for (IntegrityCheckReport.ReportItem item : report.getItems()) {
            if (item.getSeverity() != 1) continue;
            buf.append(item.getMessage());
            buf.append("\n\n\n");
        }
        buf.append("full integrity check report:\r\n");
        buf.append("-------------- REPORT BEGIN -----------------\r\n");
        for (IntegrityCheckReport.ReportItem item : report.getItems()) {
            buf.append("\tseverity=").append(item.getSeverity()).append("; code=").append(item.getCode()).append("; message=").append(item.getMessage()).append("; source=").append(item.getSource()).append("\r\n");
        }
        buf.append("-------------- REPORT END -----------------");
        return buf.toString();
    }

    private Collection findPluginLocations(Properties props) throws Exception {
        DefaultPluginsCollector collector = new DefaultPluginsCollector();
        ExtendedProperties eprops = new ExtendedProperties(props);
        if (props.containsKey(PLUGIN_DESCRIPTOR_PROP)) {
            eprops.put((Object)"org.java.plugin.boot.pluginsLocationsDescriptors", (Object)props.getProperty(PLUGIN_DESCRIPTOR_PROP));
        } else {
            String pluginFolder = String.valueOf(RUNTIME_DIR_ROOT) + props.getProperty(PLUGIN_FOLDER_PROP);
            eprops.put((Object)"org.java.plugin.boot.pluginsRepositories", (Object)pluginFolder);
        }
        collector.configure(eprops);
        Collection locations = collector.collectPluginLocations();
        String exclude = props.getProperty("pluginFolders.exclude", "");
        StringTokenizer tok = new StringTokenizer(exclude, ",");
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tok.hasMoreTokens()) {
            String loc = tok.nextToken().trim();
            try {
                URL url = new File(loc).getCanonicalFile().toURI().toURL();
                urls.add(url);
            }
            catch (IOException ex) {
                this.center.warn((Object)"Error finding directory to exclude from plugin search", ex, new Object[0]);
            }
        }
        if (urls.size() > 0) {
            Iterator iter = locations.iterator();
            while (iter.hasNext()) {
                PluginManager.PluginLocation loc = (PluginManager.PluginLocation)iter.next();
                for (URL url : urls) {
                    if (!loc.getContextLocation().toExternalForm().startsWith(url.toExternalForm())) continue;
                    iter.remove();
                }
            }
        }
        return locations;
    }

    public static void main(String[] args) {
        Boot boot = new Boot();
        PluginManager manager = boot.init(args);
        boot.run(manager, args);
    }

    private static class Restriction {
        private String id;
        private String val;

        private Restriction(String id, String val) {
            this.id = id;
            this.val = val;
        }

        private boolean pass(PluginAttributes pAttribs) {
            SimpleAttribute attrib = pAttribs.getAttribute(this.id);
            if (attrib == null) {
                return false;
            }
            return attrib.getValue().equals(this.val);
        }
    }
}

