/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualizationOGL2D;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple3f;
import repast.simphony.visualization.LayoutUpdater;
import repast.simphony.visualizationOGL2D.AbstractDisplayLayerOGL2D;
import repast.simphony.visualizationOGL2D.SpatialWrapper;
import repast.simphony.visualizationOGL2D.StyleOGL2D;
import saf.v3d.AppearanceFactory;
import saf.v3d.scene.Appearance;
import saf.v3d.scene.Label;
import saf.v3d.scene.TextureLayer;
import saf.v3d.scene.TextureRenderable;
import saf.v3d.scene.VLabelLayer;
import saf.v3d.scene.VLayer;
import saf.v3d.scene.VShape;
import saf.v3d.scene.VSpatial;

public class StyledDisplayLayerOGL2D
extends AbstractDisplayLayerOGL2D<StyleOGL2D> {
    private TextureLayer textureLayer = new TextureLayer();
    private List<SpatialWrapper> textureToRemove = new ArrayList<SpatialWrapper>();
    private List<SpatialWrapper> textureToAdd = new ArrayList<SpatialWrapper>();
    private List<SpatialWrapper> layerToRemove = new ArrayList<SpatialWrapper>();
    private List<SpatialWrapper> layerToAdd = new ArrayList<SpatialWrapper>();

    public StyledDisplayLayerOGL2D(StyleOGL2D<?> style, VLayer layer) {
        super(style, layer);
        layer.getParent().addChild((VSpatial)this.textureLayer);
    }

    private VLabelLayer getLabelLayer(Font font, boolean antialias) {
        VLabelLayer labelLayer = (VLabelLayer)this.labelLayers.get(font);
        if (labelLayer == null) {
            labelLayer = new VLabelLayer(font, antialias);
            this.labelLayers.put(font, labelLayer);
            this.layer.getParent().addChild((VSpatial)labelLayer);
        }
        return labelLayer;
    }

    private void applyStyle(Object obj, SpatialWrapper wrapper) {
        Color paint = ((StyleOGL2D)this.style).getColor(obj);
        VSpatial item = wrapper.getChild();
        if (paint != null) {
            item.setAppearance((Appearance)AppearanceFactory.createColorAppearance((Color)paint));
        }
        item.scale(((StyleOGL2D)this.style).getScale(obj));
        item.rotate2D(((StyleOGL2D)this.style).getRotation(obj));
        int borderSize = ((StyleOGL2D)this.style).getBorderSize(obj);
        if (borderSize > 0 && item instanceof VShape) {
            ((VShape)item).setBorderStrokeSize(borderSize);
            ((VShape)item).setBorderColor(((StyleOGL2D)this.style).getBorderColor(obj));
        }
        LabelEntry entry = (LabelEntry)wrapper.getProperty("DisplayLayerOGL2D.LABEL_KEY");
        String label = ((StyleOGL2D)this.style).getLabel(obj);
        if (label != null && !label.equals("")) {
            Font font = ((StyleOGL2D)this.style).getLabelFont(obj);
            if (font != null) {
                VLabelLayer labelLayer;
                if (entry.label == null) {
                    entry.label = new Label(label, (VSpatial)wrapper);
                    entry.font = font;
                    labelLayer = this.getLabelLayer(font, true);
                    labelLayer.addLabel(entry.label);
                }
                entry.label.setColor(((StyleOGL2D)this.style).getLabelColor(obj));
                entry.label.setPosition(((StyleOGL2D)this.style).getLabelPosition(obj));
                entry.label.setText(label);
                entry.label.setOffset(((StyleOGL2D)this.style).getLabelXOffset(obj), ((StyleOGL2D)this.style).getLabelYOffset(obj));
                if (!entry.font.equals(font)) {
                    this.getLabelLayer(entry.font, true).removeLabel(entry.label);
                    labelLayer = this.getLabelLayer(font, true);
                    labelLayer.addLabel(entry.label);
                    entry.label.fontChanged();
                    entry.font = font;
                }
            }
        } else if (entry.label != null) {
            ((VLabelLayer)this.labelLayers.get(entry.font)).removeLabel(entry.label);
        }
    }

    private void updateSpatial(Object obj, SpatialWrapper wrapper) {
        VSpatial spatial = wrapper.getChild();
        VSpatial newSpatial = ((StyleOGL2D)this.style).getVSpatial(obj, spatial);
        if (newSpatial != null && newSpatial != spatial) {
            newSpatial.translate((Tuple3f)spatial.getLocalTranslation());
            newSpatial.scale(spatial.getLocalScale());
            if (spatial instanceof TextureRenderable) {
                this.textureToRemove.add(wrapper);
                if (newSpatial instanceof TextureRenderable) {
                    this.textureToAdd.add(wrapper);
                } else {
                    this.layerToAdd.add(wrapper);
                }
                wrapper.setNextChild(newSpatial);
            } else {
                if (newSpatial instanceof TextureRenderable) {
                    this.layerToRemove.add(wrapper);
                    this.textureToAdd.add(wrapper);
                }
                wrapper.setChild(newSpatial);
            }
        }
    }

    private SpatialWrapper createSpatial(Object obj) {
        SpatialWrapper wrapper = new SpatialWrapper(((StyleOGL2D)this.style).getVSpatial(obj, null));
        this.objMap.put(obj, wrapper);
        wrapper.putProperty("DisplayLayerOGL2D.MODEL_OBJECT_KEY", obj);
        return wrapper;
    }

    private void processRemoved() {
        for (Object obj : this.toBeRemoved) {
            SpatialWrapper item = (SpatialWrapper)((Object)this.objMap.remove(obj));
            if (item == null) continue;
            if (item.getChild() instanceof TextureRenderable) {
                this.textureLayer.removeChild((VSpatial)item);
            } else {
                this.layer.removeChild((VSpatial)item);
            }
            LabelEntry entry = (LabelEntry)item.getProperty("DisplayLayerOGL2D.LABEL_KEY");
            if (entry.label == null) continue;
            this.getLabelLayer(entry.font, true).removeLabel(entry.label);
        }
        this.toBeRemoved.clear();
    }

    private void updateExistingSpatials(LayoutUpdater updater) {
        for (VSpatial vSpatial : this.layer.children()) {
            this.updateSpatial((SpatialWrapper)vSpatial, updater);
        }
        for (VSpatial vSpatial : this.textureLayer.children()) {
            this.updateSpatial((SpatialWrapper)vSpatial, updater);
        }
        for (SpatialWrapper spatialWrapper : this.textureToRemove) {
            this.textureLayer.removeChild((VSpatial)spatialWrapper);
            spatialWrapper.updateChild();
        }
        for (VSpatial vSpatial : this.layerToRemove) {
            this.layer.removeChild(vSpatial);
        }
        for (VSpatial vSpatial : this.textureToAdd) {
            this.textureLayer.addChild(vSpatial);
        }
        for (VSpatial vSpatial : this.layerToAdd) {
            this.layer.addChild(vSpatial);
        }
        this.textureToAdd.clear();
        this.textureToRemove.clear();
        this.layerToAdd.clear();
        this.layerToRemove.clear();
    }

    private void updateSpatial(SpatialWrapper wrapper, LayoutUpdater updater) {
        Object obj = wrapper.getProperty("DisplayLayerOGL2D.MODEL_OBJECT_KEY");
        this.updateSpatial(obj, wrapper);
        this.applyStyle(obj, wrapper);
        if (updater.getUpdateItemsLocation()) {
            float[] location = updater.getLayout().getLocation(obj);
            wrapper.getChild().translate(location[0], location[1], 0.0f);
        }
    }

    private void processAdded(LayoutUpdater updater) {
        for (Object obj : this.toBeAdded) {
            SpatialWrapper wrapper = this.createSpatial(obj);
            wrapper.putProperty("DisplayLayerOGL2D.LABEL_KEY", new LabelEntry());
            this.applyStyle(obj, wrapper);
            VSpatial item = wrapper.getChild();
            float[] location = updater.getLayout().getLocation(obj);
            item.translate(location[0], location[1], 0.0f);
            if (item instanceof TextureRenderable) {
                this.textureLayer.addChild((VSpatial)wrapper);
                continue;
            }
            this.layer.addChild((VSpatial)wrapper);
        }
        this.toBeAdded.clear();
    }

    @Override
    public void update(LayoutUpdater updater) {
        this.processRemoved();
        this.updateExistingSpatials(updater);
        this.processAdded(updater);
    }

    private static class LabelEntry {
        public Font font;
        public Label label;

        private LabelEntry() {
        }
    }
}

