/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualizationOGL2D;

import java.util.ArrayList;
import javax.media.opengl.GL2;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.Accumulator;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.picking.DefaultAccumulator;
import saf.v3d.render.RenderState;
import saf.v3d.render.Texture2D;
import saf.v3d.scene.TextureRenderable;
import saf.v3d.scene.VComposite;
import saf.v3d.scene.VSpatial;

public class SpatialWrapper
extends VComposite
implements TextureRenderable {
    private VSpatial nextChild;

    public SpatialWrapper(VSpatial child) {
        this.children = new ArrayList();
        this.setChild(child);
    }

    public void setNextChild(VSpatial child) {
        this.nextChild = child;
    }

    public void updateChild() {
        this.setChild(this.nextChild);
        this.nextChild = null;
    }

    public Texture2D getTextureData() {
        return ((TextureRenderable)this.getChild()).getTextureData();
    }

    public Point3f transform(Point3f pt) {
        return this.getChild().transform(pt);
    }

    public VSpatial getChild() {
        return (VSpatial)((ArrayList)this.children).get(0);
    }

    public void setChild(VSpatial child) {
        if (this.children.size() > 0) {
            child.translate((Tuple3f)this.getChild().getLocalTranslation());
        }
        this.removeAllChildren();
        this.addChild(child);
    }

    public float getLocalScale() {
        return this.getChild().getLocalScale();
    }

    public void draw(GL2 gl, RenderState state) {
        this.getChild().draw(gl, state);
    }

    public void updateWorldTransformation() {
        VSpatial child = this.getChild();
        VComposite parent = this.getParent();
        child.setParent(parent);
        this.getChild().updateWorldTransformation();
        child.setParent((VComposite)this);
    }

    protected BoundingSphere doGetBoundingSphere() {
        if (this.boundsDirty) {
            VSpatial child = this.getChild();
            Quat4f rotation = new Quat4f();
            rotation.set(child.getWorldRotation());
            rotation.normalize();
            this.boundingSphere = new BoundingSphere(child.getLocalBoundingSphere());
            this.boundingSphere.transform(child.getWorldScale(), rotation, child.getWorldTranslation());
        }
        return this.boundingSphere;
    }

    public BoundingSphere getLocalBoundingSphere() {
        return this.getChild().getLocalBoundingSphere();
    }

    public void intersects(Point3f point, Accumulator accumulator) {
        BoundingSphere sphere = this.getBoundingSphere();
        if (sphere.intersects(point)) {
            DefaultAccumulator tmp = new DefaultAccumulator();
            this.getChild().intersects(point, (Accumulator)tmp);
            if (tmp.size() > 0) {
                accumulator.add((VSpatial)this);
            }
        }
    }

    public void intersects(Point3f rayOrigin, Vector3f rayDirection, Accumulator accumulator) {
        BoundingSphere sphere = this.getBoundingSphere();
        if (sphere.intersects(rayOrigin, rayDirection)) {
            DefaultAccumulator tmp = new DefaultAccumulator();
            this.getChild().intersects(rayOrigin, rayDirection, accumulator);
            if (tmp.size() > 0) {
                accumulator.add((VSpatial)this);
            }
        }
    }
}

