/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualizationOGL2D;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGCircleElementBridge;
import org.apache.batik.bridge.SVGEllipseElementBridge;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.SVGLineElementBridge;
import org.apache.batik.bridge.SVGPathElementBridge;
import org.apache.batik.bridge.SVGPolygonElementBridge;
import org.apache.batik.bridge.SVGRectElementBridge;
import org.apache.batik.bridge.SVGShapeElementBridge;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGSVGElement;
import saf.v3d.NamedShapeCreator;
import saf.v3d.ShapeFactory2D;

public class SVGToNamedShape {
    private static final String COLOR_FIXED = "fixedColor";
    private String path;
    private String name;
    private Map<String, String> props;

    public SVGToNamedShape(String path, String name) {
        this(path, name, null);
    }

    public SVGToNamedShape(String path, String name, Map<String, String> props) {
        this.path = path;
        this.name = name;
        this.props = props;
    }

    private SVGOMDocument createDocument() throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        String uri = new File(this.path).toURI().toString();
        return (SVGOMDocument)f.createDocument(uri);
    }

    private ShapeData getShapeData(ShapePainter shapePainter) {
        if (shapePainter instanceof CompositeShapePainter) {
            CompositeShapePainter painter = (CompositeShapePainter)shapePainter;
            int j = 0;
            while (j < painter.getShapePainterCount()) {
                ShapeData data = this.getShapeData(painter.getShapePainter(j));
                if (data != null) {
                    return data;
                }
                ++j;
            }
        } else if (shapePainter instanceof FillShapePainter) {
            Paint paint = ((FillShapePainter)shapePainter).getPaint();
            if (paint != null) {
                return new ShapeData((Color)paint, false);
            }
        } else if (shapePainter instanceof StrokeShapePainter) {
            Paint paint = ((StrokeShapePainter)shapePainter).getPaint();
            return new ShapeData((Color)paint, true);
        }
        return null;
    }

    public void createShape(ShapeFactory2D shapeFactory) throws IOException {
        SVGOMDocument doc = this.createDocument();
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = this.createContext(doc);
        builder.build(ctx, (Document)doc);
        NamedShapeCreator creator = shapeFactory.createNamedShape(this.name);
        SVGSVGElement root = doc.getRootElement();
        ArrayList<GeneralPath> shapes = new ArrayList<GeneralPath>();
        Rectangle2D.Float rect = new Rectangle2D.Float();
        this.processNode((Element)root, creator, ctx, shapes, rect);
        if (this.props != null) {
            this.transformShapes(shapes, rect);
        }
        creator.registerShape();
    }

    private void transformShapes(List<GeneralPath> shapes, Rectangle2D bounds) {
        float height;
        float imgWidth = (float)bounds.getWidth();
        float imgHeight = (float)bounds.getHeight();
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (this.props.containsKey("bsq_size")) {
            int size = Integer.parseInt(this.props.get("bsq_size"));
            if (imgWidth > imgHeight) {
                scaleX = (float)size / imgWidth;
                height = imgHeight * scaleX;
                scaleY = height / imgHeight;
            } else {
                scaleY = (float)size / imgHeight;
                float width = imgWidth * scaleY;
                scaleX = width / imgWidth;
            }
        } else {
            float width = imgWidth;
            height = imgHeight;
            if (this.props.containsKey("width")) {
                width = Integer.parseInt(this.props.get("width"));
            }
            if (this.props.containsKey("height")) {
                height = Integer.parseInt(this.props.get("height"));
            }
            if (width != imgWidth) {
                scaleX = width / imgWidth;
                if (height != imgHeight) {
                    scaleY = height / imgHeight;
                } else {
                    scaleY = scaleX;
                    height = (int)(imgHeight * scaleY);
                }
            } else if (height != imgHeight) {
                scaleX = scaleY = height / imgHeight;
                width = (int)(imgWidth * scaleX);
            }
        }
        float scale = 1.0f;
        if (this.props.containsKey("scale")) {
            scale = Float.parseFloat(this.props.get("scale"));
        }
        scaleX *= scale;
        scaleY *= scale;
        for (GeneralPath shape : shapes) {
            shape.transform(AffineTransform.getScaleInstance(scaleX, -scaleY));
        }
    }

    private SVGShapeElementBridge lookupBridge(Element node) {
        String name = node.getLocalName();
        if (name.equals("path")) {
            return new SVGPathElementBridge();
        }
        if (name.equals("rect")) {
            return new SVGRectElementBridge();
        }
        if (name.equals("circle")) {
            return new SVGCircleElementBridge();
        }
        if (name.equals("ellipse")) {
            return new SVGEllipseElementBridge();
        }
        if (name.equals("polygon")) {
            return new SVGPolygonElementBridge();
        }
        if (name.equals("line")) {
            return new SVGLineElementBridge();
        }
        return null;
    }

    private boolean isColorFixed(Element node) {
        NodeList nodes = node.getElementsByTagName("desc");
        if (nodes.getLength() > 0) {
            return ((Element)nodes.item(0)).getTextContent().equals(COLOR_FIXED);
        }
        nodes = node.getElementsByTagName("svg:desc");
        if (nodes.getLength() > 0) {
            return ((Element)nodes.item(0)).getTextContent().equals(COLOR_FIXED);
        }
        return false;
    }

    private void accumulateTransforms(Node node, List<AffineTransform> trans, BridgeContext ctx) {
        if (node != null && node.getLocalName().equals("g")) {
            SVGGElementBridge bridge = new SVGGElementBridge();
            GraphicsNode gNode = bridge.createGraphicsNode(ctx, (Element)node);
            trans.add(gNode.getTransform());
            this.accumulateTransforms(node.getParentNode(), trans, ctx);
        }
    }

    private void processNode(Element node, NamedShapeCreator creator, BridgeContext ctx, List<GeneralPath> shapes, Rectangle2D rect) {
        SVGShapeElementBridge bridge = this.lookupBridge(node);
        if (bridge != null) {
            ShapeNode shapeNode = (ShapeNode)bridge.createGraphicsNode(ctx, node);
            bridge.buildGraphicsNode(ctx, node, (GraphicsNode)shapeNode);
            GeneralPath shape = new GeneralPath(shapeNode.getShape());
            LinkedList<AffineTransform> transforms = new LinkedList<AffineTransform>();
            transforms.add(shapeNode.getTransform());
            this.accumulateTransforms(node.getParentNode(), transforms, ctx);
            for (AffineTransform trans : transforms) {
                shape.transform(trans);
            }
            ShapeData data = this.getShapeData(shapeNode.getShapePainter());
            if (data != null) {
                boolean canUpdateColor;
                boolean bl = canUpdateColor = !this.isColorFixed(node);
                if (data.isLine) {
                    creator.addLine((Shape)shape, data.color, canUpdateColor);
                } else {
                    creator.addShape((Shape)shape, data.color, canUpdateColor);
                }
            }
            shapes.add(shape);
            if (rect.getWidth() == 0.0 && rect.getHeight() == 0.0) {
                rect.setRect(shape.getBounds());
            } else {
                Rectangle2D.union(rect, shape.getBounds(), rect);
            }
        }
        Node childNode = node.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeType() == 1) {
                this.processNode((Element)childNode, creator, ctx, shapes, rect);
            }
            childNode = childNode.getNextSibling();
        }
    }

    private BridgeContext createContext(SVGOMDocument doc) {
        if (doc.isSVG12()) {
            return new SVG12BridgeContext((UserAgent)new UserAgentAdapter());
        }
        return new BridgeContext((UserAgent)new UserAgentAdapter());
    }

    static class ShapeData {
        boolean isLine;
        Color color;

        ShapeData(Color color, boolean isLine) {
            this.color = color;
            this.isLine = isLine;
        }
    }
}

