/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D.layout;

import cern.jet.random.engine.DRand;
import cern.jet.random.engine.RandomEngine;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.vecmath.Point3d;
import repast.simphony.visualization.visualization3D.layout.DimensionLocal;
import repast.simphony.visualization.visualization3D.layout.JungVertexLocationFunction;

public class JungRandomVertexLocationDecorator
implements JungVertexLocationFunction {
    RandomEngine rand;
    Map<Object, Object> v_locations = new HashMap<Object, Object>();
    Dimension dim;
    double z;

    public JungRandomVertexLocationDecorator(Dimension d) {
        this.rand = new DRand((int)new Date().getTime());
        this.dim = d;
    }

    public JungRandomVertexLocationDecorator(Dimension d, boolean zValue) {
        if (zValue) {
            this.rand = new DRand((int)new Date().getTime());
            this.dim = (DimensionLocal)d;
        }
    }

    public JungRandomVertexLocationDecorator(Dimension d, int seed) {
        this.rand = new DRand(seed);
        this.dim = d;
    }

    public void reset() {
        this.v_locations.clear();
    }

    @Override
    public double[] getLocation(Object o) {
        Point2D location = (Point2D)this.v_locations.get(o);
        if (location == null) {
            location = new Point2D.Double(this.rand.nextDouble() * (double)this.dim.width, this.rand.nextDouble() * (double)this.dim.height);
            this.v_locations.put(o, location);
        }
        double[] coords = new double[]{location.getX(), location.getY()};
        return coords;
    }

    @Override
    public double[] getLocation(Object o, boolean threeD) {
        if (!threeD) {
            return null;
        }
        Point3d location = (Point3d)this.v_locations.get(o);
        if (location == null) {
            location = new Point3d(this.rand.nextDouble() * (double)this.dim.width, this.rand.nextDouble() * (double)this.dim.height, this.rand.nextDouble() * ((DimensionLocal)this.dim).getZ());
            this.v_locations.put(o, location);
        }
        double[] coords = new double[]{location.x, location.y, location.z};
        return coords;
    }

    @Override
    public Iterator getVertexIterator() {
        return this.v_locations.keySet().iterator();
    }
}

