/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D.layout;

import java.util.ConcurrentModificationException;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.visualization.visualization3D.layout.JungGraphElementAccessor;
import repast.simphony.visualization.visualization3D.layout.JungNetworkLayout;

public class JungRadiusGraphElementAccessor
implements JungGraphElementAccessor {
    protected JungNetworkLayout layout;
    protected double maxDistance;

    public JungRadiusGraphElementAccessor(JungNetworkLayout l) {
        this(l, Math.sqrt(Double.MAX_VALUE));
    }

    public JungRadiusGraphElementAccessor(JungNetworkLayout l, double maxDistance) {
        this.maxDistance = maxDistance;
        this.layout = l;
    }

    @Override
    public Object getVertex(double x, double y) {
        return this.getVertex(x, y, this.maxDistance);
    }

    public Object getVertex(double x, double y, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        Object closest = null;
        while (true) {
            try {
                for (Object v : this.layout.getGraph().getNodes()) {
                    double dy;
                    double[] p = this.layout.getCoordinates(v);
                    double dx = p[0] - x;
                    double dist = dx * dx + (dy = p[1] - y) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public RepastEdge getEdge(double x, double y) {
        return this.getEdge(x, y, this.maxDistance);
    }

    public RepastEdge getEdge(double x, double y, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        RepastEdge closest = null;
        while (true) {
            try {
                for (RepastEdge e : this.layout.getGraph().getEdges()) {
                    double distance2;
                    if (e.getSource() == null && e.getTarget() == null) continue;
                    Object v1 = e.getSource();
                    Object v2 = e.getTarget();
                    double[] p1 = this.layout.getCoordinates(v1);
                    double[] p2 = this.layout.getCoordinates(v2);
                    double x1 = p1[0];
                    double y1 = p1[1];
                    double x2 = p2[0];
                    double y2 = p2[1];
                    if (x1 == x2 && y1 == y2) continue;
                    double b = ((y - y1) * (y2 - y1) + (x - x1) * (x2 - x1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    if (b <= 0.0) {
                        distance2 = (x - x1) * (x - x1) + (y - y1) * (y - y1);
                    } else if (b >= 1.0) {
                        distance2 = (x - x2) * (x - x2) + (y - y2) * (y - y2);
                    } else {
                        double x3 = x1 + b * (x2 - x1);
                        double y3 = y1 + b * (y2 - y1);
                        distance2 = (x - x3) * (x - x3) + (y - y3) * (y - y3);
                    }
                    if (!(distance2 < minDistance)) continue;
                    minDistance = distance2;
                    closest = e;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public void setLayout(JungNetworkLayout l) {
        this.layout = l;
    }
}

