/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D.layout;

import java.util.Iterator;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import javolution.util.FastMap;
import repast.simphony.random.RandomHelper;
import repast.simphony.space.graph.Network;
import repast.simphony.visualization.Box;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.VisualizationProperties;

public class GEM3DLayout
implements Layout<Object, Network> {
    private Network graph;
    private Point3f center = new Point3f();
    private int optEdgeLength;
    private int minEdgeLengthS;
    private int optEdgeLengthS;
    private int tempMax;
    private int tempInit;
    private int temperature;
    private int endTemp;
    private int rounds;
    private int round = 0;
    private int maxAttraction;
    private int shake;
    private float gravity = 0.1f;
    private double alphaRotationCos;
    private double alphaOscillationCos;
    private double sigmaOscillation = 1.0;
    private double sigmaRotation = 0.01f;
    private float[] location = new float[3];
    private Map<Object, VertexData> dataMap = new FastMap();

    public void setProjection(Network projection) {
        this.graph = projection;
    }

    public void setLayoutProperties(VisualizationProperties props) {
    }

    public VisualizationProperties getLayoutProperties() {
        return null;
    }

    public float[] getLocation(Object o) {
        VertexData data = this.dataMap.get(o);
        data.pos.get(this.location);
        return this.location;
    }

    private void setParameters() {
        int maxVertexWidth = 150;
        int vertCount = this.graph.size();
        double factor = Math.sqrt((double)(this.graph.numEdges() * 2) / (double)vertCount);
        factor = Math.max(1.0, factor);
        this.optEdgeLength = (int)(factor * (double)maxVertexWidth);
        this.optEdgeLengthS = this.optEdgeLength * this.optEdgeLength;
        this.minEdgeLengthS = maxVertexWidth * maxVertexWidth;
        this.tempInit = this.optEdgeLength;
        this.tempMax = 2 * this.optEdgeLength;
        this.temperature = this.tempInit * vertCount;
        this.endTemp = (int)((float)this.temperature * 0.01f);
        this.shake = (int)((float)this.optEdgeLength / 2.0f);
        this.maxAttraction = 64 * this.optEdgeLengthS;
        double alphaOscillation = 1.0471975511965976;
        this.alphaOscillationCos = Math.cos(alphaOscillation / 2.0);
        double alphaRotation = 1.0471975511965976;
        this.alphaRotationCos = Math.abs(Math.cos((Math.PI + alphaRotation) / 2.0));
        this.rounds = 50 * vertCount;
    }

    private void init() {
        this.center.set(0.0f, 0.0f, 0.0f);
        this.dataMap.clear();
        this.round = 0;
        int scale = (int)(Math.sqrt(this.graph.size()) / 2.0 * (double)this.optEdgeLength);
        Iterator iter = this.graph.getNodes().iterator();
        while (iter.hasNext()) {
            VertexData data = new VertexData(scale);
            this.dataMap.put(iter.next(), data);
        }
    }

    private Vector3f calcImpulse(Object vertex) {
        Vector3f impulse = new Vector3f();
        impulse.x = RandomHelper.getUniform().nextFloatFromTo((float)(-(this.shake / 2)), (float)(this.shake + 1));
        impulse.y = RandomHelper.getUniform().nextFloatFromTo((float)(-(this.shake / 2)), (float)(this.shake + 1));
        impulse.z = RandomHelper.getUniform().nextFloatFromTo((float)(-(this.shake / 2)), (float)(this.shake + 1));
        VertexData data = this.dataMap.get(vertex);
        Vector3f pos = data.pos;
        int vertexCount = this.graph.size();
        impulse.x += (this.center.x / (float)vertexCount - pos.x) * this.gravity;
        impulse.y += (this.center.y / (float)vertexCount - pos.y) * this.gravity;
        impulse.z += (this.center.z / (float)vertexCount - pos.z) * this.gravity;
        Vector3f delta = new Vector3f();
        for (Object other : this.graph.getNodes()) {
            if (other.equals(vertex)) continue;
            Vector3f otherPos = this.dataMap.get(other).pos;
            delta.sub((Tuple3f)pos, (Tuple3f)otherPos);
            float lengthSq = delta.lengthSquared();
            if (lengthSq == 0.0f) continue;
            delta.scale((float)this.optEdgeLengthS / lengthSq);
            impulse.add((Tuple3f)delta);
            if (!(lengthSq < (float)this.minEdgeLengthS)) continue;
            impulse.add((Tuple3f)delta);
        }
        int weight = (int)((double)this.optEdgeLengthS * (1.0 + (double)this.graph.getDegree(vertex) / 2.0));
        for (Object other : this.graph.getSuccessors(vertex)) {
            Vector3f otherPos = this.dataMap.get(other).pos;
            delta.sub((Tuple3f)pos, (Tuple3f)otherPos);
            float lengthSq = delta.lengthSquared();
            lengthSq = Math.min(lengthSq, (float)this.maxAttraction);
            if (!(lengthSq > (float)this.minEdgeLengthS)) continue;
            delta.scale(lengthSq / (float)weight);
            impulse.sub((Tuple3f)delta);
        }
        return impulse;
    }

    private void temperatureUpdate(Object vertex, Vector3f impulse) {
        VertexData data = this.dataMap.get(vertex);
        float temp = data.heat;
        float impulseLength = impulse.length();
        if (impulseLength != 0.0f) {
            impulse.scale(temp / impulseLength);
            data.pos.add((Tuple3f)impulse);
            this.center.add((Tuple3f)impulse);
            float dataImpLengthS = data.impulse.lengthSquared();
            float impulseLengthS = impulse.lengthSquared();
            if (dataImpLengthS != 0.0f && impulseLengthS != 0.0f) {
                this.temperature = (int)((float)this.temperature - data.heat);
                double cos = (double)data.impulse.dot(impulse) / Math.sqrt(dataImpLengthS * impulseLengthS);
                double absCos = Math.abs(cos);
                if (absCos >= this.alphaOscillationCos) {
                    temp = (float)((double)temp + this.sigmaOscillation * cos);
                }
                if (absCos <= this.alphaRotationCos) {
                    data.skewXY = (float)((double)data.skewXY + this.sigmaRotation * (double)(data.impulse.x * impulse.y - data.impulse.y * impulse.x < 0.0f ? -1 : 1));
                    data.skewYZ = (float)((double)data.skewYZ + this.sigmaRotation * (double)(data.impulse.y * impulse.z - data.impulse.z * impulse.y < 0.0f ? -1 : 1));
                    data.skewZX = (float)((double)data.skewZX + this.sigmaRotation * (double)(data.impulse.z * impulse.x - data.impulse.x * impulse.z < 0.0f ? -1 : 1));
                }
                double d = (1.0f - Math.abs(data.skewXY)) * (1.0f - Math.abs(data.skewYZ)) * (1.0f - Math.abs(data.skewZX));
                data.heat = temp = (float)Math.min((double)this.tempMax, (double)temp * Math.pow(d, 0.3333333333333333));
                this.temperature = (int)((float)this.temperature + data.heat);
            }
            data.impulse.set((Tuple3f)impulse);
        }
    }

    private void iterate() {
        for (Object vertex : this.graph.getNodes()) {
            Vector3f impulse = this.calcImpulse(vertex);
            this.temperatureUpdate(vertex, impulse);
        }
    }

    public void update() {
        this.setParameters();
        this.init();
        while (this.round++ < this.rounds && this.temperature > this.endTemp) {
            this.iterate();
        }
        Point3f barycenter = new Point3f(0.0f, 0.0f, 0.0f);
        for (Object vertex : this.graph.getNodes()) {
            Vector3f pos = this.dataMap.get(vertex).pos;
            barycenter.add((Tuple3f)pos);
        }
        int size = this.graph.size();
        barycenter.x /= (float)size;
        barycenter.y /= (float)size;
        barycenter.z /= (float)size;
        float maxLength = 0.0f;
        for (Object vertex : this.graph.getNodes()) {
            float length = new Point3f((Tuple3f)this.dataMap.get(vertex).pos).distance(barycenter);
            if (!(length > maxLength)) continue;
            maxLength = length;
        }
        if (maxLength == 0.0f) {
            maxLength = 1.0f;
        }
        for (VertexData data : this.dataMap.values()) {
            data.pos.x = 0.8f * (data.pos.x - barycenter.x) / maxLength;
            data.pos.y = 0.8f * (data.pos.y - barycenter.y) / maxLength;
            data.pos.z = 0.8f * (data.pos.z - barycenter.z) / maxLength;
        }
    }

    public String getName() {
        return "Gem 3D";
    }

    public Box getBoundingBox() {
        return null;
    }

    class VertexData {
        Vector3f impulse = new Vector3f();
        Vector3f pos = new Vector3f();
        float skewXY;
        float skewYZ;
        float skewZX;
        float heat;

        public VertexData(int scale) {
            this.pos.x = RandomHelper.getUniform().nextFloatFromTo((float)(-(scale / 2)), (float)(scale + 1));
            this.pos.y = RandomHelper.getUniform().nextFloatFromTo((float)(-(scale / 2)), (float)(scale + 1));
            this.pos.z = RandomHelper.getUniform().nextFloatFromTo((float)(-(scale / 2)), (float)(scale + 1));
            GEM3DLayout.this.center.add((Tuple3f)this.pos);
            this.heat = GEM3DLayout.this.tempInit;
        }
    }
}

