/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D.layout;

import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.impl.DenseDoubleMatrix3D;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.Dimension;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import javax.vecmath.Vector3f;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.visualization.Box;
import repast.simphony.visualization.visualization3D.layout.DimensionLocal;
import repast.simphony.visualization.visualization3D.layout.JungNetworkLayout;
import repast.simphony.visualization.visualization3D.layout.JungRandomVertexLocationDecorator;
import repast.simphony.visualization.visualization3D.layout.JungVertexLocationFunction;

public class FR3DLayout<T>
extends JungNetworkLayout<T> {
    private static final Object FR_KEY = "edu.uci.ics.jung.FR_Visualization_Key";
    private double forceConstant;
    private double temperature = 0.0;
    private int currentIteration = 0;
    private String status = null;
    private int mMaxIterations = 700;
    private double attraction_multiplier = 0.75;
    private double attraction_constant;
    private double repulsion_multiplier = 0.75;
    private double repulsion_constant;
    private Object key = null;
    private double EPSILON = 1.0E-6;
    private DimensionLocal currentSize;
    private int yD;
    private int xD;
    private int zD;

    public void setAttractionMultiplier(double attraction) {
        this.attraction_multiplier = attraction;
    }

    @Override
    protected void initializeLocations() {
        try {
            for (Object o : this.getVisibleGraph().getNodes()) {
                double[] coord = this.returnMatchingCoordinate(o);
                if (coord == null) {
                    coord = new double[3];
                    this.locationData.put(o, coord);
                }
                if (!this.dontmove.contains(o)) {
                    this.initializeLocation(o, coord, this.currentSize);
                }
                this.initialize_local_vertex(o);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.initializeLocations();
        }
    }

    protected void initializeLocation(Object o, double[] coord, DimensionLocal d) {
        this.locationData.put(o, this.vertex_locations.getLocation(o, true));
    }

    public void setRepulsionMultiplier(double repulsion) {
        this.repulsion_multiplier = repulsion;
    }

    @Override
    public void update() {
        this.initialize_local();
        this.resetVisibleEdgesAndVertices();
        this.initializeLocations();
        while (this.currentIteration < 100) {
            this.advancePositions();
        }
        this.currentIteration = 0;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void forceMove(Object picked, double x, double y, double z) {
        super.forceMove(picked, x, y, z);
    }

    @Override
    protected void initialize_local() {
        this.temperature = this.getCurrentSize().getWidth() / 100.0;
        this.forceConstant = Math.sqrt(this.getCurrentSize().getHeight() * this.getCurrentSize().getWidth() * this.getCurrentSize().getZ() / (double)this.getVisibleGraph().size());
        this.attraction_constant = this.attraction_multiplier * this.forceConstant;
        this.repulsion_constant = this.repulsion_multiplier * this.forceConstant;
    }

    public Object getKey() {
        if (this.key == null) {
            try {
                this.key = new Pair((Object)this, FR_KEY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.key;
    }

    public void initialize(DimensionLocal size) {
        this.initialize(size, (JungVertexLocationFunction)new JungRandomVertexLocationDecorator((Dimension)size, true));
    }

    public void initialize(DimensionLocal size, JungVertexLocationFunction v_locations) {
        this.currentSize = size;
        this.vertex_locations = v_locations;
        this.initialize_local();
        this.initializeLocations();
    }

    @Override
    protected void initialize_local_vertex(Object o) {
        if (!this.objectData.containsKey(o)) {
            this.objectData.put(o, new FRVertexData());
        }
    }

    @Override
    public synchronized void advancePositions() {
        ++this.currentIteration;
        this.status = "VV: " + this.getVisibleVertices().size() + " IT: " + this.currentIteration + " temp: " + this.temperature;
        while (true) {
            try {
                for (Object v1 : this.getVisibleVertices()) {
                    if (this.dontMove(v1)) continue;
                    this.calcRepulsion(v1);
                }
            }
            catch (ConcurrentModificationException iter) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (RepastEdge e : this.getVisibleEdges()) {
                    this.calcAttraction(e);
                }
            }
            catch (ConcurrentModificationException iter) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object v : this.getVisibleVertices()) {
                    if (this.dontMove(v)) continue;
                    this.calcPositions(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.cool();
    }

    public synchronized void calcPositions(Object v) {
        FRVertexData fvd = this.getFRData(v);
        if (fvd == null) {
            return;
        }
        double[] xyz = this.getCoordinates(v);
        double deltaLength = Math.max(this.EPSILON, Math.sqrt(fvd.disp.get(0, 0, 0) * fvd.disp.get(0, 0, 0) + (fvd.disp.get(1, 0, 0) * fvd.disp.get(1, 0, 0) + fvd.disp.get(2, 0, 0) * fvd.disp.get(2, 0, 0))));
        double newXDisp = fvd.getXDisp() / deltaLength * Math.min(deltaLength, this.temperature);
        if (Double.isNaN(newXDisp)) {
            try {
                throw new Exception("Unexpected mathematical result in FRLayout:calcPositions [xdisp]");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        double newYDisp = fvd.getYDisp() / deltaLength * Math.min(deltaLength, this.temperature);
        double newZDisp = fvd.getZDisp() / deltaLength * Math.min(deltaLength, this.temperature);
        xyz[0] = xyz[0] + newXDisp;
        xyz[1] = xyz[1] + newYDisp;
        xyz[2] = xyz[2] + newZDisp;
        double newXPos = xyz[0];
        double borderWidth = this.getCurrentSize().getWidth() / 50.0;
        if (newXPos < borderWidth) {
            newXPos = borderWidth + Math.random() * borderWidth * 2.0;
        } else if (newXPos > this.getCurrentSize().getWidth() - borderWidth) {
            newXPos = this.getCurrentSize().getWidth() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        double newYPos = xyz[1];
        if (newYPos < borderWidth) {
            newYPos = borderWidth + Math.random() * borderWidth * 2.0;
        } else if (newYPos > this.getCurrentSize().getHeight() - borderWidth) {
            newYPos = this.getCurrentSize().getHeight() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        double newZPos = xyz[2];
        if (newZPos < borderWidth) {
            newZPos = borderWidth + Math.random() * borderWidth * 2.0;
        } else if (newZPos > this.getCurrentSize().getZ() - borderWidth) {
            newZPos = this.getCurrentSize().getZ() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        xyz[0] = newXPos;
        xyz[1] = newYPos;
        xyz[2] = newZPos;
    }

    public void calcAttraction(RepastEdge e) {
        Object v1 = e.getSource();
        Object v2 = e.getTarget();
        double[] p1 = this.getCoordinates(v1);
        double[] p2 = this.getCoordinates(v2);
        if (p1 == null || p2 == null) {
            return;
        }
        double xDelta = p1[0] - p2[0];
        double yDelta = p1[1] - p2[1];
        double zDelta = p1[2] - p2[2];
        double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta));
        this.initialize_local();
        double force = deltaLength * deltaLength / this.attraction_constant;
        if (Double.isNaN(force)) {
            try {
                throw new Exception("Unexpected mathematical result in FRLayout:calcPositions [force]");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        FRVertexData fvd1 = this.getFRData(v1);
        FRVertexData fvd2 = this.getFRData(v2);
        fvd1.decrementDisp(xDelta / deltaLength * force, yDelta / deltaLength * force, zDelta / deltaLength * force);
        fvd2.incrementDisp(xDelta / deltaLength * force, yDelta / deltaLength * force, zDelta / deltaLength * force);
    }

    public void calcRepulsion(Object v1) {
        FRVertexData fvd1 = this.getFRData(v1);
        if (fvd1 == null) {
            return;
        }
        fvd1.setDisp(0.0, 0.0, 0.0);
        try {
            for (Object v2 : this.getVisibleVertices()) {
                if (this.dontMove(v2) || v1 == v2) continue;
                double[] p1 = this.getCoordinates(v1);
                double[] p2 = this.getCoordinates(v2);
                if (p1 == null || p2 == null) continue;
                double xDelta = p1[0] - p2[0];
                double yDelta = p1[1] - p2[1];
                double zDelta = p1[2] - p2[2];
                double deltaLength = Math.max(this.EPSILON, Math.sqrt(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta));
                double force = this.repulsion_constant * this.repulsion_constant / deltaLength;
                if (Double.isNaN(force)) {
                    try {
                        throw new Exception("Unexpected mathematical result in FRLayout:calcPositions [repulsion]");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                fvd1.incrementDisp(xDelta / deltaLength * force, yDelta / deltaLength * force, zDelta / deltaLength * force);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calcRepulsion(v1);
        }
    }

    private void cool() {
        this.temperature *= 1.0 - (double)this.currentIteration / (double)this.mMaxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.mMaxIterations = maxIterations;
    }

    public FRVertexData getFRData(Object o) {
        return (FRVertexData)this.objectData.get(o);
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return this.currentIteration > this.mMaxIterations;
    }

    @Override
    public float[] getLocation(Object obj) {
        float[] coords = this.getLocation(obj, true);
        Vector3f v3f = new Vector3f();
        v3f.set(coords);
        return coords;
    }

    @Override
    public void setProjection(Network projection) {
        this.baseGraph = projection;
        this.visibleGraph = projection;
        Iterable edges = projection.getEdges();
        this.visibleEdges = this.addEdgesOrVertices(edges);
        Iterable nodes = projection.getNodes();
        this.visibleVertices = this.addEdgesOrVertices(nodes);
        this.dontmove = new HashSet();
        this.locationData = new HashMap();
        this.objectData = new HashMap();
        this.currentSize = new DimensionLocal(1, 1, 1);
        this.initialize(this.currentSize);
    }

    @Override
    public DimensionLocal getCurrentSize() {
        return this.currentSize;
    }

    public int getX() {
        return this.xD;
    }

    public void setX(int x) {
        this.xD = x;
    }

    public int getY() {
        return this.yD;
    }

    public void setY(int y) {
        this.yD = y;
    }

    public int getZ() {
        return this.zD;
    }

    public void setZ(int z) {
        this.zD = z;
    }

    public Box getBoundingBox() {
        return new Box();
    }

    public static class FRVertexData {
        private DoubleMatrix3D disp;

        public FRVertexData() {
            this.initialize();
        }

        public void initialize() {
            this.disp = new DenseDoubleMatrix3D(3, 1, 1);
        }

        public double getXDisp() {
            return this.disp.get(0, 0, 0);
        }

        public double getYDisp() {
            return this.disp.get(1, 0, 0);
        }

        public double getZDisp() {
            return this.disp.get(2, 0, 0);
        }

        public void setDisp(double x, double y, double z) {
            this.disp.set(0, 0, 0, x);
            this.disp.set(1, 0, 0, y);
            this.disp.set(2, 0, 0, z);
        }

        public void incrementDisp(double x, double y, double z) {
            this.disp.set(0, 0, 0, this.disp.get(0, 0, 0) + x);
            this.disp.set(1, 0, 0, this.disp.get(1, 0, 0) + y);
            this.disp.set(2, 0, 0, this.disp.get(2, 0, 0) + z);
        }

        public void decrementDisp(double x, double y, double z) {
            this.disp.set(0, 0, 0, this.disp.get(0, 0, 0) - x);
            this.disp.set(1, 0, 0, this.disp.get(1, 0, 0) - y);
            this.disp.set(2, 0, 0, this.disp.get(2, 0, 0) - z);
        }
    }
}

