/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.visualization3D.Label;
import repast.simphony.visualization.visualization3D.Transformer;
import repast.simphony.visualization.visualization3D.style.Style3D;
import repast.simphony.visualization.visualization3D.style.TaggedAppearance;
import repast.simphony.visualization.visualization3D.style.TaggedBranchGroup;

public class VisualItem3D<T> {
    protected BranchGroup branchGroup;
    protected BranchGroup oldUserBranch;
    protected BranchGroup newUserBranch;
    protected TaggedBranchGroup taggedBranchGroup;
    protected Color3f color = new Color3f();
    protected Point3f location = new Point3f();
    protected float[] scale;
    protected TransformGroup translateGroup;
    protected TransformGroup rotationGroup;
    protected TransformGroup scaleGroup;
    protected Transformer transformer = new Transformer();
    protected T visualizedObject;
    protected boolean moved = true;
    protected Map<Shape3D, TaggedAppearance> shapes = new HashMap<Shape3D, TaggedAppearance>();
    protected Map<Shape3D, TaggedAppearance> changedMap = new HashMap<Shape3D, TaggedAppearance>();
    protected Label label;

    public VisualItem3D(TaggedBranchGroup tGroup, T obj, Label label) {
        this.label = label;
        this.taggedBranchGroup = tGroup;
        this.visualizedObject = obj;
        this.translateGroup = this.createTransformGroup();
        this.rotationGroup = this.createTransformGroup();
        this.scaleGroup = this.createTransformGroup();
        this.translateGroup.addChild((Node)this.rotationGroup);
        this.rotationGroup.addChild((Node)this.scaleGroup);
        BranchGroup intermediateGroup = new BranchGroup();
        intermediateGroup.setCapability(17);
        intermediateGroup.setCapability(13);
        intermediateGroup.setCapability(12);
        intermediateGroup.setCapability(14);
        intermediateGroup.addChild((Node)this.taggedBranchGroup.getBranchGroup());
        this.scaleGroup.addChild((Node)intermediateGroup);
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(17);
        this.branchGroup.setCapability(14);
        this.branchGroup.setCapability(13);
        this.branchGroup.addChild((Node)this.translateGroup);
        this.oldUserBranch = this.taggedBranchGroup.getBranchGroup();
        this.oldUserBranch.setCapability(3);
        this.initShape(this.taggedBranchGroup.getBranchGroup());
    }

    private TransformGroup createTransformGroup() {
        TransformGroup transGroup = new TransformGroup();
        transGroup.setCapability(12);
        transGroup.setCapability(17);
        transGroup.setCapability(18);
        transGroup.setCapability(3);
        return transGroup;
    }

    public Iterator<Shape3D> shapes() {
        return this.shapes.keySet().iterator();
    }

    public TaggedAppearance getShapeAppearance(Shape3D shape) {
        return this.shapes.get(shape);
    }

    public void setShapeAppearance(Shape3D shape, TaggedAppearance appearance) {
        if (appearance != null) {
            this.changedMap.put(shape, appearance);
            this.shapes.put(shape, appearance);
        }
    }

    public TaggedBranchGroup getTaggedBranchGroup() {
        return this.taggedBranchGroup;
    }

    public void setTaggedBranchGroup(TaggedBranchGroup tGroup) {
        this.initShape(tGroup.getBranchGroup());
        this.oldUserBranch = this.taggedBranchGroup.getBranchGroup();
        this.newUserBranch = tGroup.getBranchGroup();
        this.newUserBranch.setCapability(17);
        this.newUserBranch.setCapability(3);
        this.taggedBranchGroup = tGroup;
    }

    private void initShape(BranchGroup group) {
        this.shapes.clear();
        this.findShape((Group)group);
    }

    private void findShape(Group group) {
        int i = 0;
        int n = group.numChildren();
        while (i < n) {
            Node node = group.getChild(i);
            if (node instanceof Shape3D) {
                this.shapes.put((Shape3D)node, null);
            } else if (node instanceof Group) {
                this.findShape((Group)node);
            }
            ++i;
        }
    }

    public Point3f getLocation() {
        return this.location;
    }

    public void setLocation(Point3f location) {
        boolean bl = this.moved = !this.location.equals((Tuple3f)location);
        if (this.moved) {
            this.location = location;
            this.transformer.setTranslation(this.location);
        }
    }

    public void setLocation(float[] location) {
        boolean bl = this.moved = location[0] != this.location.x || location[1] != this.location.y || location[2] != this.location.z;
        if (this.moved) {
            this.location.set(location);
            this.transformer.setTranslation(this.location);
        }
    }

    public boolean hasMoved() {
        return this.moved;
    }

    public void setLocation() {
        this.transformer.setTranslation(this.location);
    }

    public void setScale(float x, float y, float z) {
        this.transformer.setScale(x, y, z);
    }

    public float[] getScale() {
        return this.scale;
    }

    public void addTo(BranchGroup group) {
        this.branchGroup.compile();
        group.addChild((Node)this.branchGroup);
    }

    public void applyTransform() {
        BranchGroup labelGroup;
        for (Map.Entry<Shape3D, TaggedAppearance> entry : this.changedMap.entrySet()) {
            if (entry.getValue().getAppearance() == null) continue;
            entry.getKey().setAppearance(entry.getValue().getAppearance());
        }
        BranchGroup group = (BranchGroup)this.scaleGroup.getChild(0);
        if (this.newUserBranch != null) {
            this.newUserBranch.compile();
            group.removeChild((Node)this.oldUserBranch);
            group.addChild((Node)this.newUserBranch);
            this.oldUserBranch = this.newUserBranch;
            this.newUserBranch = null;
        }
        if ((labelGroup = this.label.getBranchGroup(this.location, (Group)this.oldUserBranch)) != null) {
            labelGroup.compile();
            this.branchGroup.addChild((Node)labelGroup);
        }
        this.changedMap.clear();
        this.moved = false;
        this.transformer.apply(this.translateGroup, this.rotationGroup, this.scaleGroup);
    }

    public void removeFrom(BranchGroup parent) {
        parent.removeChild((Node)this.branchGroup);
    }

    public T getVisualizedObject() {
        return this.visualizedObject;
    }

    public void setRotation(AxisAngle4f rotation) {
        this.transformer.setRotation(rotation);
    }

    public void setLabel(String label, Style3D.LabelPosition position) {
        this.label.setLabel(label);
        this.label.setPosition(position);
    }

    public String getLabel() {
        return this.label.getLabel();
    }

    public Style3D.LabelPosition getLabelPosition() {
        return this.label.getPosition();
    }

    public void setLabelColor(Color color) {
        if (color != null) {
            this.label.setColor(color);
        }
    }

    public Color getLabelColor() {
        return this.label.getColor();
    }

    public void setLabelFont(Font font) {
        if (font != null) {
            this.label.setFont(font);
        }
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setLabelOffset(float offset) {
        this.label.setOffset(offset);
    }

    public void updateTaggedBranchGroup(Style3D style) {
        BranchGroup oldBg = this.taggedBranchGroup.getBranchGroup();
        TaggedBranchGroup newTaggedBranchGroup = style.getBranchGroup(this.visualizedObject, this.taggedBranchGroup);
        if (!(newTaggedBranchGroup == null || oldBg != null && newTaggedBranchGroup.getBranchGroup().equals(oldBg) && newTaggedBranchGroup.equals(this.taggedBranchGroup))) {
            this.setTaggedBranchGroup(newTaggedBranchGroup);
        }
    }

    public void updateAppearance(Style3D style) {
        for (Map.Entry<Shape3D, TaggedAppearance> entry : this.shapes.entrySet()) {
            Shape3D shape = entry.getKey();
            TaggedAppearance oldAppearance = entry.getValue();
            TaggedAppearance appearance = style.getAppearance(this.visualizedObject, oldAppearance, shape.getUserData());
            if (appearance == null || appearance.equals(oldAppearance)) continue;
            this.setShapeAppearance(shape, appearance);
        }
    }

    public void updateLabel(Style3D style) {
        String label = style.getLabel(this.visualizedObject, this.getLabel());
        if (label != null && label.length() == 0) {
            label = null;
        }
        this.setLabel(label, style.getLabelPosition(this.visualizedObject, this.getLabelPosition()));
        if (label != null && label.length() > 0) {
            this.setLabelColor(style.getLabelColor(this.visualizedObject, this.getLabelColor()));
            this.setLabelFont(style.getLabelFont(this.visualizedObject, this.getLabelFont()));
            this.setLabelOffset(style.getLabelOffset(this.visualizedObject));
        }
    }

    public void updateScale(Style3D style) {
        this.scale = style.getScale(this.visualizedObject);
        if (this.scale != null) {
            this.setScale(this.scale[0], this.scale[1], this.scale[2]);
        }
    }

    public void updateRotation(Style3D style) {
        float[] point = style.getRotation(this.visualizedObject);
        if (point != null) {
            this.setRotation(new AxisAngle4f(point));
        }
    }

    public void updateLocation(Layout layout) {
    }

    public void updateLocation(Point3f source, float sourceRadius, Point3f target, float targetRadius) {
    }
}

