/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Transformer {
    protected Transform3D translate = new Transform3D();
    protected Transform3D scaling = new Transform3D();
    protected Transform3D rotation = new Transform3D();
    protected Transform3D rotX = new Transform3D();
    protected Transform3D rotY = new Transform3D();
    protected Transform3D rotZ = new Transform3D();
    protected boolean locationChanged;
    protected boolean scaleChanged;
    protected boolean rotationChanged;
    protected boolean rotXChanged;
    protected boolean rotYChanged;
    protected boolean rotZChanged;

    public void setTranslation(Point3f translation) {
        this.locationChanged = true;
        this.translate.setTranslation(new Vector3f((Tuple3f)translation));
    }

    public void setScale(float x, float y, float z) {
        Vector3d scale = new Vector3d();
        this.scaling.getScale(scale);
        if (scale.x != (double)x || scale.y != (double)y || scale.z != (double)z) {
            this.scaling.setScale(new Vector3d((double)x, (double)y, (double)z));
            this.scaleChanged = true;
        }
    }

    public void setRotationX(double angle) {
        this.rotX.rotX(angle);
        this.rotXChanged = true;
    }

    public void setRotationY(double angle) {
        this.rotY.rotY(angle);
        this.rotYChanged = true;
    }

    public void setRotationZ(double angle) {
        this.rotZ.rotZ(angle);
        this.rotZChanged = true;
    }

    public void setRotation(AxisAngle4f rotation) {
        this.rotation.setRotation(rotation);
        this.rotationChanged = true;
    }

    public void apply(TransformGroup translateGroup, TransformGroup rotationGroup, TransformGroup scaleGroup) {
        if (this.rotationChanged) {
            rotationGroup.setTransform(this.rotation);
        }
        if (this.scaleChanged) {
            scaleGroup.setTransform(this.scaling);
        }
        if (this.locationChanged) {
            translateGroup.setTransform(this.translate);
        }
        this.rotZChanged = false;
        this.rotYChanged = false;
        this.rotXChanged = false;
        this.scaleChanged = false;
        this.rotationChanged = false;
        this.locationChanged = false;
    }
}

