/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import java.util.Iterator;
import javax.media.j3d.Group;
import javax.media.j3d.Shape3D;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.visualization3D.AbstractDisplayLayer3D;
import repast.simphony.visualization.visualization3D.AgentLabel;
import repast.simphony.visualization.visualization3D.Label;
import repast.simphony.visualization.visualization3D.NodeVisualItem;
import repast.simphony.visualization.visualization3D.VisualItem3D;
import repast.simphony.visualization.visualization3D.style.DefaultStyle3D;
import repast.simphony.visualization.visualization3D.style.Style3D;
import repast.simphony.visualization.visualization3D.style.TaggedAppearance;
import repast.simphony.visualization.visualization3D.style.TaggedBranchGroup;

public class DisplayLayer3D
extends AbstractDisplayLayer3D {
    public DisplayLayer3D(Style3D style, Group topGroup) {
        super(style, topGroup);
        if (style == null) {
            this.style = new DefaultStyle3D();
        }
    }

    protected VisualItem3D createVisualItem(Object obj) {
        TaggedBranchGroup rep = this.style.getBranchGroup(obj, null);
        NodeVisualItem item = new NodeVisualItem(rep, obj, this.createLabel());
        Iterator<Shape3D> iter = item.shapes();
        while (iter.hasNext()) {
            Shape3D shape = iter.next();
            TaggedAppearance attrib = this.style.getAppearance(obj, null, shape.getUserData());
            item.setShapeAppearance(shape, attrib);
        }
        return item;
    }

    @Override
    protected void createItemsForAddedObjects(Layout layout, boolean doLayout) {
        if (doLayout) {
            for (Object obj : this.objsToAdd) {
                VisualItem3D item = this.createVisualItem(obj);
                this.visualItemMap.put(obj, item);
                float[] location = layout.getLocation(obj);
                item.setLocation(location);
                this.adder.addItemForAddition(item);
            }
        } else {
            for (Object obj : this.objsToAdd) {
                VisualItem3D item = this.createVisualItem(obj);
                this.visualItemMap.put(obj, item);
                this.adder.addItemForAddition(item);
            }
        }
        this.objsToAdd.clear();
    }

    @Override
    protected Label createLabel() {
        return new AgentLabel();
    }

    @Override
    public void doUpdate(Layout layout, boolean updateLocation) {
        if (updateLocation) {
            for (VisualItem3D item : this.visualItemMap.values()) {
                item.updateLocation(layout);
                item.updateLabel(this.style);
                item.updateScale(this.style);
                item.updateRotation(this.style);
                item.updateTaggedBranchGroup(this.style);
                item.updateAppearance(this.style);
            }
        } else {
            for (VisualItem3D item : this.visualItemMap.values()) {
                item.updateLabel(this.style);
                item.updateScale(this.style);
                item.updateRotation(this.style);
                item.updateTaggedBranchGroup(this.style);
                item.updateAppearance(this.style);
            }
        }
    }
}

