/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import com.sun.j3d.utils.picking.PickTool;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import repast.simphony.space.Dimensions;
import repast.simphony.valueLayer.ValueLayer;
import repast.simphony.visualization.visualization3D.DataGeometry;
import repast.simphony.visualization.visualization3D.DataGeometryUpdater;
import repast.simphony.visualization.visualization3D.DataUpdateBehavior;
import repast.simphony.visualization.visualization3D.Display3D;
import repast.simphony.visualization.visualization3D.MeshGridGeometry;
import repast.simphony.visualization.visualization3D.ShapeFactory;
import repast.simphony.visualization.visualization3D.ValueDisplayLayer3D;
import repast.simphony.visualization.visualization3D.style.DefaultValueLayerStyle3D;
import repast.simphony.visualization.visualization3D.style.ValueLayerStyle3D;

public class DefaultValueDisplayLayer3D
implements ValueDisplayLayer3D {
    private ValueLayerStyle3D style;
    private int xDim;
    private int zDim;
    private int xOffset;
    private int zOffset;
    private BranchGroup branchGroup;
    private Display3D display;
    private DataGeometry dataGeom;
    private Map<String, ValueLayer> layerMap = new HashMap<String, ValueLayer>();

    public DefaultValueDisplayLayer3D(ValueLayerStyle3D style, Group topGroup, Display3D display) {
        this.display = display;
        if (style == null) {
            style = new DefaultValueLayerStyle3D();
        }
        this.style = style;
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(13);
        this.branchGroup.setCapability(14);
        topGroup.addChild((Node)this.branchGroup);
    }

    public void registerGrid(Group parent) {
        float unitSize = this.style.getCellSize();
        Shape3D grid = ShapeFactory.createWireframeSquare(unitSize, this.xDim, this.zDim, new Color(0, 0, 0, 0));
        Transform3D gridTrans = new Transform3D();
        float offset = -unitSize / 2.0f;
        gridTrans.setTranslation(new Vector3f(offset, offset, -offset));
        TransformGroup grp = new TransformGroup(gridTrans);
        grp.addChild((Node)grid);
        parent.addChild((Node)grp);
        grid.setPickable(false);
    }

    @Override
    public void addDataLayer(ValueLayer layer) {
        int[] dims = layer.getDimensions().toIntArray(null);
        int[] origin = layer.getDimensions().originToIntArray(null);
        if (dims.length > 3 || dims.length == 3 && dims[2] != 0) {
            throw new IllegalArgumentException("Data Layers with more than 2 dimensions are unsupported");
        }
        this.layerMap.put(layer.getName(), layer);
        this.xDim = Math.max(dims[0], this.xDim);
        this.zDim = Math.max(dims[1], this.zDim);
        this.xOffset = origin[0];
        this.zOffset = origin[1];
    }

    @Override
    public void setStyle(ValueLayerStyle3D style) {
        this.style = style;
    }

    @Override
    public void init(Behavior masterBehavior) {
        this.dataGeom = new MeshGridGeometry(this.xDim, this.zDim, this.xOffset, this.zOffset);
        Shape3D shape = new Shape3D(this.dataGeom.getGeometry(this.style));
        PickTool.setCapabilities((Node)shape, (int)4100);
        shape.setAppearance(this.getAppearance());
        Transform3D trans = new Transform3D();
        trans.setTranslation(new Vector3f(-((float)this.xDim / 2.0f), 0.0f, (float)this.zDim / 2.0f));
        Transform3D scale = new Transform3D();
        float size = this.style.getCellSize();
        scale.setScale(new Vector3d((double)size, 1.0, (double)size));
        scale.mul(trans);
        TransformGroup transGroup = new TransformGroup(scale);
        transGroup.addChild((Node)shape);
        this.branchGroup.addChild((Node)transGroup);
        this.branchGroup.compile();
        DataGeometryUpdater updater = new DataGeometryUpdater(this.dataGeom);
        DataUpdateBehavior behavior = new DataUpdateBehavior(this.dataGeom.getGeometry(this.style), updater, masterBehavior);
        behavior.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
        this.display.getSceneRoot().addChild((Node)behavior);
    }

    private Appearance getAppearance() {
        Appearance appearance = new Appearance();
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCullFace(0);
        polyAttrib.setPolygonMode(2);
        polyAttrib.setBackFaceNormalFlip(true);
        appearance.setPolygonAttributes(polyAttrib);
        Material material = new Material();
        material.setAmbientColor(0.15f, 0.15f, 0.15f);
        material.setSpecularColor(0.0f, 0.0f, 0.0f);
        appearance.setMaterial(material);
        return appearance;
    }

    @Override
    public void update() {
        this.dataGeom.update(this.style);
    }

    @Override
    public void applyUpdates() {
    }

    public Object findObjForShape(Shape3D shape, Point3d intersectPoint) {
        if (shape.getGeometry().equals(this.dataGeom.getGeometry(this.style))) {
            int x = (int)intersectPoint.x;
            int y = (int)(-intersectPoint.z);
            for (Map.Entry<String, ValueLayer> entry : this.layerMap.entrySet()) {
                ValueLayer layer = entry.getValue();
                Dimensions dims = layer.getDimensions();
                if (!((double)x < dims.getWidth()) || !((double)y < dims.getHeight())) continue;
                return String.valueOf(entry.getKey()) + ": " + layer.get(new double[]{x, y});
            }
        }
        return null;
    }
}

