/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import java.util.BitSet;

public class BehaviorTracker {
    private boolean renderStarted = false;
    private boolean renderFinished = false;
    private int behaviorCount = 0;
    private BitSet bitSet = new BitSet();

    public int registerBehavior() {
        return this.behaviorCount++;
    }

    public void deregisterBehavior(int index) {
        this.bitSet.clear(index);
    }

    public void renderStarted() {
        this.renderStarted = true;
    }

    public void behaviorCompleted(int id) {
        this.bitSet.clear(id);
    }

    public void reset() {
        this.renderStarted = false;
        this.renderFinished = false;
        if (this.behaviorCount > 0) {
            this.bitSet.set(0, this.behaviorCount);
        }
    }

    public boolean isRenderFinished() {
        return this.renderStarted && this.renderFinished && this.bitSet.isEmpty();
    }

    public void end() {
        this.renderFinished = true;
    }
}

