/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class AppearanceFactory {
    private static Color3f tmpColor = new Color3f();

    public static Appearance setColoredAppearance(Appearance appearance, Color color) {
        if (appearance == null) {
            appearance = AppearanceFactory.createAppearance();
        }
        ColoringAttributes ca = new ColoringAttributes();
        ca.setCapability(0);
        ca.setCapability(1);
        ca.setColor(new Color3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f));
        appearance.setColoringAttributes(ca);
        return appearance;
    }

    public static Appearance setTransparentAppearance(Appearance appearance, int mode, float transVal) {
        if (appearance == null) {
            appearance = AppearanceFactory.createAppearance();
        }
        TransparencyAttributes trans = new TransparencyAttributes(mode, transVal);
        appearance.setTransparencyAttributes(trans);
        return appearance;
    }

    public static Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setCapability(8);
        appearance.setCapability(9);
        appearance.setCapability(14);
        appearance.setCapability(15);
        appearance.setCapability(0);
        appearance.setCapability(1);
        appearance.setCapability(10);
        appearance.setCapability(11);
        appearance.setPolygonAttributes(new PolygonAttributes());
        appearance.getPolygonAttributes().setCapability(2);
        appearance.getPolygonAttributes().setCapability(3);
        return appearance;
    }

    private static boolean materialColorEquals(Material mat, Color3f color) {
        if (mat == null) {
            return false;
        }
        mat.getDiffuseColor(tmpColor);
        return color.equals((Tuple3f)tmpColor);
    }

    public static Appearance setMaterialAppearance(Appearance appearance, Color color) {
        if (appearance == null) {
            appearance = AppearanceFactory.createAppearance();
        }
        Color3f colorf = new Color3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        Material material = appearance.getMaterial();
        if (!AppearanceFactory.materialColorEquals(material, colorf)) {
            if (material == null) {
                material = new Material();
                material.setCapability(0);
                material.setCapability(1);
                appearance.setMaterial(material);
            }
            material.setDiffuseColor(colorf);
        }
        return appearance;
    }

    public static Appearance setPolygonAppearance(Appearance appearance, PolygonDraw draw) {
        if (appearance == null) {
            appearance = AppearanceFactory.createAppearance();
        }
        PolygonAttributes pa = appearance.getPolygonAttributes();
        if (draw == PolygonDraw.FILL) {
            pa.setPolygonMode(2);
        } else if (draw == PolygonDraw.LINE) {
            pa.setPolygonMode(1);
        } else {
            pa.setPolygonMode(0);
        }
        return appearance;
    }

    public static enum PolygonDraw {
        FILL,
        LINE,
        POINT;

    }
}

