/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization3D;

import com.sun.j3d.exp.swing.JCanvas3D;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Behavior;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import repast.simphony.space.graph.Network;
import repast.simphony.space.projection.Projection;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.ui.Imageable;
import repast.simphony.valueLayer.ValueLayer;
import repast.simphony.visualization.AbstractDisplay;
import repast.simphony.visualization.AddedRemovedLayoutUpdater;
import repast.simphony.visualization.DisplayData;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.IDisplayLayer;
import repast.simphony.visualization.IntervalLayoutUpdater;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.LayoutUpdater;
import repast.simphony.visualization.MovedLayoutUpdater;
import repast.simphony.visualization.UpdateLayoutUpdater;
import repast.simphony.visualization.decorator.ProjectionDecorator3D;
import repast.simphony.visualization.visualization3D.AbstractDisplayLayer3D;
import repast.simphony.visualization.visualization3D.ValueDisplayLayer3D;
import repast.simphony.visualization.visualization3D.style.EdgeStyle3D;
import repast.simphony.visualization.visualization3D.style.Style3D;
import repast.simphony.visualization.visualization3D.style.ValueLayerStyle3D;

public abstract class AbstractDisplay3D
extends AbstractDisplay
implements WindowListener {
    protected DisplayData<?> initData;
    protected Map<Class, AbstractDisplayLayer3D> displayMap = new HashMap<Class, AbstractDisplayLayer3D>();
    protected Map<Network, AbstractDisplayLayer3D> networkMap = new HashMap<Network, AbstractDisplayLayer3D>();
    protected ValueDisplayLayer3D valueLayer;
    protected ValueLayerStyle3D valueLayerStyle;
    protected Layout layout;
    protected boolean iconified = false;
    protected JPanel panel;
    private boolean addWindowListener = true;
    private LayoutUpdater layoutUpdater;
    protected Map<String, ProjectionDecorator3D> decoratorMap;

    public AbstractDisplay3D(DisplayData<?> data, Layout layout) {
        this.initData = data;
        this.layout = layout;
        this.layoutUpdater = new UpdateLayoutUpdater(layout);
        this.decoratorMap = new HashMap<String, ProjectionDecorator3D>();
    }

    public void init() {
        if (this.initData.getProjectionCount() > 0) {
            for (Object obj : this.initData.objects()) {
                this.addObject(obj);
            }
            for (Projection proj : this.initData.getProjections()) {
                proj.addProjectionListener((ProjectionListener)this);
            }
        }
        for (ValueLayer layer : this.initData.getValueLayers()) {
            if (this.valueLayer == null) {
                this.valueLayer = this.createValueLayerDisplayLayer(null);
            }
            this.valueLayer.addDataLayer(layer);
        }
    }

    public void registerStyle(Class clazz, Style3D style) {
        AbstractDisplayLayer3D layer = this.displayMap.get(clazz);
        if (layer == null) {
            layer = this.createDisplayLayer(style);
            this.displayMap.put(clazz, layer);
        } else {
            layer.setStyle(style);
        }
    }

    public Iterable<Class> getRegisteredAgents() {
        return this.displayMap.keySet();
    }

    public void registerDecorator(ProjectionDecorator3D decorator) {
        this.decoratorMap.put(decorator.getProjection().getName(), decorator);
    }

    public void registerNetworkStyle(Network network, EdgeStyle3D style) {
        AbstractDisplayLayer3D layer = this.networkMap.get(network);
        if (layer == null) {
            layer = this.createEdgeLayer(style, network);
            this.networkMap.put(network, layer);
        } else {
            layer.setStyle(style);
        }
    }

    public void registerValueLayerStyle(ValueLayerStyle3D style) {
        if (this.valueLayer == null || this.valueLayer instanceof DummyValueDisplayLayer) {
            this.valueLayer = this.createValueLayerDisplayLayer(style);
        } else {
            this.valueLayer.setStyle(style);
        }
        this.valueLayerStyle = style;
    }

    public void createPanel() {
        this.panel = new ImageablePanel();
        this.panel.setMinimumSize(new Dimension(10, 10));
        this.panel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Window window;
                if (e.getChangeFlags() == 2L && AbstractDisplay3D.this.addWindowListener && AbstractDisplay3D.this.panel != null && (window = SwingUtilities.getWindowAncestor(AbstractDisplay3D.this.panel)) != null) {
                    window.addWindowListener(AbstractDisplay3D.this);
                    AbstractDisplay3D.this.addWindowListener = false;
                }
            }
        });
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
        this.layoutUpdater.setLayout(layout);
    }

    public void setLayoutFrequency(IDisplay.LayoutFrequency frequency, int interval) {
        if (frequency == IDisplay.LayoutFrequency.AT_UPDATE) {
            this.layoutUpdater = new UpdateLayoutUpdater(this.layout);
        } else if (frequency == IDisplay.LayoutFrequency.AT_INTERVAL) {
            this.layoutUpdater = new IntervalLayoutUpdater(this.layout, interval);
        } else if (frequency == IDisplay.LayoutFrequency.ON_NEW) {
            this.layoutUpdater = new AddedRemovedLayoutUpdater(this.layout);
        } else if (frequency == IDisplay.LayoutFrequency.ON_MOVE) {
            this.layoutUpdater = new MovedLayoutUpdater(this.layout);
        }
    }

    public synchronized void update() {
        if (this.getCanvas() != null && !this.getCanvas().isDisplayable()) {
            return;
        }
        this.layoutUpdater.update();
        for (IDisplayLayer iDisplayLayer : this.displayMap.values()) {
            iDisplayLayer.update(this.layoutUpdater);
        }
        for (IDisplayLayer iDisplayLayer : this.networkMap.values()) {
            iDisplayLayer.update(this.layoutUpdater);
        }
        this.valueLayer.update();
    }

    protected abstract AbstractDisplayLayer3D createDisplayLayer(Style3D var1);

    protected abstract AbstractDisplayLayer3D createEdgeLayer(EdgeStyle3D var1, Network var2);

    protected abstract ValueDisplayLayer3D createValueLayerDisplayLayer(ValueLayerStyle3D var1);

    @Override
    protected void addObject(Object obj) {
        AbstractDisplayLayer3D layer = this.findLayer(obj);
        if (layer != null) {
            layer.addObject(obj);
            this.layoutUpdater.addTriggerCondition(LayoutUpdater.Condition.ADDED);
        }
    }

    protected AbstractDisplayLayer3D findLayer(Object obj) {
        Class<?> objClass = obj.getClass();
        AbstractDisplayLayer3D layer = this.displayMap.get(objClass);
        if (layer == null) {
            for (Class clazz : this.displayMap.keySet()) {
                if (!clazz.isAssignableFrom(objClass)) continue;
                layer = this.displayMap.get(clazz);
                break;
            }
        }
        return layer;
    }

    @Override
    protected void moveObject(Object o) {
        this.layoutUpdater.addTriggerCondition(LayoutUpdater.Condition.MOVED);
    }

    @Override
    protected void removeObject(Object obj) {
        AbstractDisplayLayer3D layer = this.findLayer(obj);
        if (layer != null) {
            layer.removeObject(obj);
            this.layoutUpdater.addTriggerCondition(LayoutUpdater.Condition.REMOVED);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.iconified = false;
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.iconified = true;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public DisplayData<?> getInitData() {
        return this.initData;
    }

    public abstract JCanvas3D getCanvas();

    static class DummyValueDisplayLayer
    implements ValueDisplayLayer3D {
        DummyValueDisplayLayer() {
        }

        @Override
        public void applyUpdates() {
        }

        @Override
        public void setStyle(ValueLayerStyle3D style) {
        }

        @Override
        public void update() {
        }

        @Override
        public void addDataLayer(ValueLayer layer) {
        }

        @Override
        public void init(Behavior masterBehavior) {
        }
    }

    static class ImageablePanel
    extends JPanel
    implements Imageable {
        public ImageablePanel(LayoutManager layout, boolean isDoubleBuffered) {
            super(layout, isDoubleBuffered);
        }

        public ImageablePanel(LayoutManager layout) {
            super(layout);
        }

        public ImageablePanel(boolean isDoubleBuffered) {
            super(isDoubleBuffered);
        }

        public ImageablePanel() {
        }

        public BufferedImage getImage() {
            Component comp = this.getComponent(0);
            Rectangle rect = new Rectangle(comp.getLocationOnScreen(), comp.getSize());
            try {
                Robot robot = new Robot(this.getGraphicsConfiguration().getDevice());
                return robot.createScreenCapture(rect);
            }
            catch (AWTException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

