/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization2D;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.piccolo2d.PNode;
import org.piccolo2d.nodes.PPath;
import org.piccolo2d.nodes.PText;
import org.piccolo2d.util.PBounds;
import repast.simphony.visualization.Layout;
import repast.simphony.visualization.LayoutUpdater;
import repast.simphony.visualization.visualization2D.DisplayLayer2D;
import repast.simphony.visualization.visualization2D.RepastCanvas2D;
import repast.simphony.visualization.visualization2D.style.Style2D;

public class StyledDisplayLayer2D
extends DisplayLayer2D<Object, PNode> {
    private static final long serialVersionUID = 7275726272264198637L;
    Style2D style;
    RepastCanvas2D canvas;
    private Set<Object> addedObjects;
    private List<PNode> addedNodes;
    private List<PNode> removedNodes;
    private Set<Object> removedObjects;
    private Lock lock = new ReentrantLock();
    private PBounds tmpBounds = new PBounds();
    public static final String LABEL_KEY = "LABEL";
    public static final String AGENT_KEY = "AGENT";
    public static final String BOUNDS_KEY = "BOUNDS";
    public static final String PAINT_KEY = "PAINT";
    public static final String STROKE_KEY = "STROKE";
    public static final String STROKE_PAINT_KEY = "STROKE PAINT";
    public static final String COORD_KEY = "COORDS";
    public static final String NODE_STYLE_ID = "NODE_STYLE";
    public static final String ROTATION_MODE = "ROTATION";

    public StyledDisplayLayer2D(Style2D s, RepastCanvas2D canvas) {
        this.style = s;
        this.canvas = canvas;
        canvas.addLayer(this);
        this.addedObjects = new HashSet<Object>();
        this.removedObjects = new HashSet<Object>();
        this.addedNodes = new ArrayList<PNode>();
        this.removedNodes = new ArrayList<PNode>();
    }

    @Override
    public void addObject(Object o) {
        try {
            this.lock.lock();
            this.removedObjects.remove(o);
            this.addedObjects.add(o);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void updateNode(PNode node, Layout layout, boolean doLayout) {
        Object o = node.getAttribute((Object)AGENT_KEY);
        this.applyUpdatesToNode(node);
        if (doLayout) {
            float[] loc = layout.getLocation(o);
            node.setOffset(this.putCoordLocation(node, loc));
            this.applyUpdatesToNode(node);
        }
    }

    protected void applyUpdatesToNode(PNode node) {
        PText label;
        double rot;
        Paint paint;
        Object o = node.getAttribute((Object)AGENT_KEY);
        Object nodeStyle = node.getAttribute((Object)NODE_STYLE_ID);
        if (nodeStyle != null) {
            this.style.getPNode(o, node);
        }
        if (!(paint = this.style.getPaint(o)).equals(node.getPaint())) {
            node.setPaint(paint);
        }
        if (node.getBooleanAttribute((Object)ROTATION_MODE, false) && (rot = this.style.getRotation(o)) != node.getRotation()) {
            node.rotateAboutPoint(rot - node.getRotation(), node.getBounds().getCenter2D());
        }
        Rectangle2D bounds = this.style.getBounds(o);
        this.tmpBounds.setRect(bounds);
        if (!node.getBounds().equals((Object)this.tmpBounds)) {
            node.setBounds(bounds);
        }
        if (node instanceof PPath) {
            ((PPath)node).setStroke(this.style.getStroke(o));
            ((PPath)node).setStrokePaint(this.style.getStrokePaint(o));
        }
        if ((label = this.style.getLabel(o)) != null) {
            PText oldLabel = (PText)node.getAttribute((Object)LABEL_KEY);
            if (oldLabel != null) {
                node.removeChild((PNode)oldLabel);
            }
            node.addAttribute((Object)LABEL_KEY, (Object)label);
            AffineTransform trans = new AffineTransform();
            trans.setToScale(1.0, -1.0);
            label.transformBy(trans);
            node.addChild((PNode)label);
        }
        double scale = 0.0;
        if (!this.style.isScaled(o)) {
            scale = 1.0 / this.canvas.getCamera().getViewScale();
        } else if (scale != 0.0) {
            node.setScale(scale);
        }
        Point2D oldPoint = node.getOffset();
        Point2D newPoint = (Point2D)node.getAttribute((Object)COORD_KEY);
        if (newPoint != null && oldPoint.distanceSq(newPoint) != 0.0) {
            node.setOffset(newPoint);
        }
    }

    @Override
    public void update(LayoutUpdater updater) {
        try {
            this.lock.lock();
            this.addAddedObjects(updater.getLayout());
            this.removeRemovedObjects();
            int i = 0;
            while (i < this.getChildrenCount()) {
                PNode node = this.getChild(i);
                this.updateNode(node, updater.getLayout(), updater.getUpdateItemsLocation());
                ++i;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void applyUpdates() {
        for (PNode node : this.addedNodes) {
            this.addChild(node);
        }
        for (PNode node : this.removedNodes) {
            if (node.getParent() == null) continue;
            this.removeChild(node);
        }
        int i = 0;
        while (i < this.getChildrenCount()) {
            PNode node = this.getChild(i);
            this.applyUpdatesToNode(node);
            ++i;
        }
        this.removedNodes.clear();
        this.addedNodes.clear();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> findObjsForItems(Collection<PNode> pnodes) {
        ArrayList<Object> objs = new ArrayList<Object>();
        HashSet<PNode> nodes = new HashSet<PNode>(pnodes);
        Map map = this.visualItemMap;
        synchronized (map) {
            Set entries = this.visualItemMap.entrySet();
            for (Map.Entry entry : entries) {
                PNode mapNode = (PNode)entry.getValue();
                if (!nodes.contains(mapNode)) continue;
                nodes.remove(mapNode);
                objs.add(entry.getKey());
            }
        }
        return objs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findObjForItem(PNode node) {
        ArrayList objs = new ArrayList();
        Map map = this.visualItemMap;
        synchronized (map) {
            Set entries = this.visualItemMap.entrySet();
            for (Map.Entry entry : entries) {
                PNode mapNode = (PNode)entry.getValue();
                if (!node.equals(mapNode)) continue;
                return entry.getKey();
            }
        }
        return objs;
    }

    @Override
    public void removeObject(Object o) {
        try {
            this.lock.lock();
            if (!this.addedObjects.remove(o)) {
                this.removedObjects.add(o);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void addAddedObjects(Layout layout) {
        for (Object object : this.addedObjects) {
            PNode node = this.createVisualItem(object);
            node.addAttribute((Object)AGENT_KEY, object);
            if (!this.style.isScaled(object)) {
                node.setScale(1.0 / this.canvas.getCamera().getViewScale());
            }
            float[] location = layout.getLocation(object);
            Point2D pt = this.putCoordLocation(node, location);
            node.setOffset(pt);
            this.addedNodes.add(node);
        }
        this.addedObjects.clear();
    }

    private Point2D putCoordLocation(PNode node, float[] location) {
        PBounds bounds = node.getBounds();
        Point2D.Double pt = (Point2D.Double)node.getAttribute((Object)COORD_KEY);
        double r = Math.sqrt(bounds.width * bounds.width + bounds.height * bounds.height) / 2.0;
        double phi = Math.atan(bounds.height / bounds.width);
        double xOffset = r * Math.cos(node.getRotation() + phi);
        double yOffset = r * Math.sin(node.getRotation() + phi);
        pt.x = (double)location[0] - xOffset;
        pt.y = (double)location[1] - yOffset;
        return pt;
    }

    protected PNode createVisualItem(Object o) {
        PNode node = this.style.getPNode(o, null);
        node.setPaint(this.style.getPaint(o));
        node.setBounds(this.style.getBounds(o));
        node.rotateAboutPoint(this.style.getRotation(o) - node.getRotation(), node.getBounds().getCenter2D());
        node.addAttribute((Object)COORD_KEY, (Object)new Point2D.Double(0.0, 0.0));
        this.visualItemMap.put(o, node);
        return node;
    }

    protected void removeRemovedObjects() {
        int count = 0;
        for (Object object : this.removedObjects) {
            PNode node = (PNode)this.visualItemMap.remove(object);
            if (node == null) continue;
            this.removedNodes.add(node);
            ++count;
        }
        this.removedObjects.clear();
    }

    public void setStyle(Style2D style) {
        this.style = style;
    }

    @Override
    public PNode getVisualItem(Object o) {
        return (PNode)this.visualItemMap.get(o);
    }
}

