/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.visualization2D;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.piccolo2d.PCamera;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PLayer;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEventFilter;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.util.PAffineTransform;
import repast.simphony.visualization.visualization2D.Display2D;
import repast.simphony.visualization.visualization2D.DisplayLayer2D;

public class RepastCanvas2D
extends PCanvas {
    private static final long serialVersionUID = 291436309770995502L;
    private double mousePositionX;
    private double mousePositionY;
    PInputEventListener currentListener;
    Map<Class, DisplayLayer2D> layerMap = new HashMap<Class, DisplayLayer2D>();

    public RepastCanvas2D() {
        this.setSize(Display2D.DISPLAY_WIDTH, Display2D.DISPLAY_HEIGHT);
        PAffineTransform viewTransform = this.getCamera().getViewTransform();
        viewTransform.scale(1.0, -1.0);
        this.getCamera().setViewTransform((AffineTransform)viewTransform);
        this.getPanEventHandler().setEventFilter(new PInputEventFilter(4));
        this.getZoomEventHandler().setEventFilter(new PInputEventFilter(8));
        this.resetHomeView();
        this.addMouseWheelListener(new repastPiccoloMouseWheelListener());
        this.addMouseMotionListener(new repastPiccoloMouseMotionListener());
        this.setDefaultRenderQuality(0);
    }

    public void addLayer(PLayer layer) {
        this.getRoot().addChild((PNode)layer);
        this.getCamera().addLayer(layer);
    }

    public void setTool(PBasicInputEventHandler ev) {
        if (this.currentListener != null) {
            this.removeInputEventListener(this.currentListener);
        }
        this.currentListener = ev;
        super.addInputEventListener((PInputEventListener)ev);
    }

    public void setLayerTool(PBasicInputEventHandler ev, Class clazz) {
        DisplayLayer2D layer = this.layerMap.get(clazz);
        layer.setListener((PInputEventListener)ev);
        if (this.currentListener != null) {
            this.removeInputEventListener(this.currentListener);
        }
    }

    public void setViewBounds(Rectangle2D bounds) {
        this.getCamera().animateViewToCenterBounds(bounds, true, 0L);
    }

    public void resetHomeView() {
        this.getCamera().animateViewToCenterBounds((Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, 500.0f, 500.0f), true, 0L);
    }

    public class repastPiccoloMouseMotionListener
    implements MouseMotionListener {
        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            RepastCanvas2D.this.mousePositionX = e.getX();
            RepastCanvas2D.this.mousePositionY = e.getY();
        }
    }

    public class repastPiccoloMouseWheelListener
    implements MouseWheelListener {
        private double minScale = 0.0;
        private double maxScale = Double.MAX_VALUE;

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            PCamera camera = RepastCanvas2D.this.getCamera();
            double dx = -e.getWheelRotation();
            double scaleDelta = 1.0 + 0.1 * dx;
            double currentScale = camera.getViewScale();
            double newScale = currentScale * scaleDelta;
            if (newScale < this.minScale) {
                scaleDelta = this.minScale / currentScale;
            }
            if (this.maxScale > 0.0 && newScale > this.maxScale) {
                scaleDelta = this.maxScale / currentScale;
            }
            Point2D point = camera.localToView((Point2D)new Point2D.Double(RepastCanvas2D.this.mousePositionX, RepastCanvas2D.this.mousePositionY));
            camera.scaleViewAboutPoint(scaleDelta, point.getX(), point.getY());
        }
    }
}

