/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.piccolo2d.PNode;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.visualization.LayoutUpdater;
import repast.simphony.visualization.network.PEdge;
import repast.simphony.visualization.visualization2D.Display2D;
import repast.simphony.visualization.visualization2D.DisplayLayer2D;
import repast.simphony.visualization.visualization2D.RepastCanvas2D;
import repast.simphony.visualization.visualization2D.style.EdgeStyle2D;

public class NetworkDisplayLayer2D
extends DisplayLayer2D<RepastEdge, PEdge>
implements ProjectionListener {
    private static final long serialVersionUID = -1976427158589343866L;
    EdgeStyle2D style;
    Display2D display;
    Set<RepastEdge> edgesToAdd;
    List<PEdge> nodesToAdd;
    List<PEdge> nodesToRemove;
    Set<RepastEdge> edgesToRemove;
    private Lock lock = new ReentrantLock();
    public static final String REL_KEY = "Relationship";

    public NetworkDisplayLayer2D(Network<?> net, EdgeStyle2D style, Display2D display, RepastCanvas2D canvas) {
        this.style = style;
        this.display = display;
        this.edgesToAdd = new HashSet<RepastEdge>();
        this.nodesToAdd = new ArrayList<PEdge>();
        this.nodesToRemove = new ArrayList<PEdge>();
        this.edgesToRemove = new HashSet<RepastEdge>();
        canvas.addLayer(this);
        net.addProjectionListener((ProjectionListener)this);
        for (RepastEdge edge : net.getEdges()) {
            this.edgesToAdd.add(edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> findObjsForItems(Collection<PNode> pnodes) {
        ArrayList<Object> objs = new ArrayList<Object>();
        HashSet<PNode> nodes = new HashSet<PNode>(pnodes);
        Map map = this.visualItemMap;
        synchronized (map) {
            Set entries = this.visualItemMap.entrySet();
            for (Map.Entry entry : entries) {
                PNode mapNode = (PNode)entry.getValue();
                if (!nodes.contains(mapNode)) continue;
                nodes.remove(mapNode);
                objs.add(entry.getKey());
            }
        }
        return objs;
    }

    public void setStyle(EdgeStyle2D style) {
        this.style = style;
    }

    public void addEdge(RepastEdge edge) {
        try {
            this.lock.lock();
            this.edgesToRemove.remove(edge);
            this.edgesToAdd.add(edge);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeEdge(RepastEdge edge) {
        try {
            this.lock.lock();
            if (!this.edgesToAdd.remove(edge)) {
                this.edgesToRemove.add(edge);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void update(LayoutUpdater updater) {
        try {
            this.lock.lock();
            this.addAddedEdges();
            this.removeRemovedEdges();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void addAddedEdges() {
        for (RepastEdge rEdge : this.edgesToAdd) {
            PNode source = this.display.getVisualItem(rEdge.getSource());
            PNode target = this.display.getVisualItem(rEdge.getTarget());
            if (source == null || target == null) continue;
            PEdge edge = new PEdge(source, target);
            edge.addAttribute(REL_KEY, rEdge);
            this.visualItemMap.put(rEdge, edge);
            this.nodesToAdd.add(edge);
        }
        this.edgesToAdd.clear();
    }

    protected void removeRemovedEdges() {
        for (RepastEdge rEdge : this.edgesToRemove) {
            PEdge edge = (PEdge)((Object)this.visualItemMap.remove(rEdge));
            if (edge == null) continue;
            this.nodesToRemove.add(edge);
        }
        this.edgesToRemove.clear();
    }

    @Override
    public void applyUpdates() {
        for (PEdge edge : this.nodesToAdd) {
            this.addChild((PNode)edge);
        }
        for (PEdge edge : this.nodesToRemove) {
            if (edge.getParent() == null) continue;
            this.removeChild((PNode)edge);
        }
        int i = 0;
        while (i < this.getChildrenCount()) {
            PEdge edge = (PEdge)this.getChild(i);
            RepastEdge redge = (RepastEdge)edge.getAttribute(REL_KEY);
            edge.setStroke(this.style.getStroke(redge));
            edge.setStrokePaint(this.style.getPaint(redge));
            edge.setTargetEndPaint(this.style.getTargetEndPaint(redge));
            edge.setTargetEndType(this.style.getTargetEndStyle(redge));
            edge.setSourceEndPaint(this.style.getSourceEndPaint(redge));
            edge.setSourceEndType(this.style.getSourceEndStyle(redge));
            edge.update();
            ++i;
        }
        this.nodesToRemove.clear();
        this.nodesToAdd.clear();
        this.repaint();
    }

    public void projectionEventOccurred(ProjectionEvent evt) {
        if (evt.getType() == ProjectionEvent.EDGE_ADDED) {
            this.addEdge((RepastEdge)evt.getSubject());
        } else if (evt.getType() == ProjectionEvent.EDGE_REMOVED) {
            this.removeEdge((RepastEdge)evt.getSubject());
        }
    }

    @Override
    public PNode getVisualItem(Object obj) {
        return (PNode)this.visualItemMap.get(obj);
    }

    @Override
    public void addObject(Object o) {
    }

    @Override
    public void removeObject(Object obj) {
    }
}

