/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.network;

import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import repast.simphony.visualization.network.EdgeVisualItem;
import repast.simphony.visualization.visualization3D.Label;
import repast.simphony.visualization.visualization3D.ShapeFactory;
import repast.simphony.visualization.visualization3D.style.EdgeStyle3D;
import repast.simphony.visualization.visualization3D.style.TaggedAppearance;
import repast.simphony.visualization.visualization3D.style.TaggedBranchGroup;

public class DirectedEdgeVisualItem
extends EdgeVisualItem {
    protected Transform3D arrowTranslate = new Transform3D();
    protected TransformGroup arrowTransform = new TransformGroup();
    protected float arrowHeight;
    protected boolean applyUpdate = false;
    protected Vector3f transVec = new Vector3f();

    public DirectedEdgeVisualItem(TaggedBranchGroup tGroup, Object o, Label label, EdgeStyle3D style) {
        super(tGroup, o, label);
        float radius = style.edgeRadius(o);
        this.arrowHeight = 4.0f * radius;
        float arrowRadius = 2.0f * radius;
        Shape3D shape = ShapeFactory.createCone(arrowRadius, this.arrowHeight, "_ARROW_HEAD_");
        TaggedAppearance appearance = style.getAppearance(o, null, "_ARROW_HEAD_");
        this.shapes.put(shape, appearance);
        shape.setAppearance(appearance.getAppearance());
        this.arrowTransform.addChild((Node)shape);
        this.transVec.set(0.0f, 0.5f, 0.0f);
        this.arrowTranslate.setTranslation(this.transVec);
        this.arrowTransform.setTransform(this.arrowTranslate);
        this.arrowTransform.setCapability(18);
        this.arrowTransform.setCapability(17);
        this.rotationGroup.addChild((Node)this.arrowTransform);
    }

    @Override
    public void updateLocation(Point3f source, float sourceRadius, Point3f target, float targetRadius) {
        this.calculateEndPoints(source, sourceRadius, target, targetRadius + this.arrowHeight / 2.0f);
        this.transVec.set(0.0f, this.height / 2.0f + this.arrowHeight / 2.0f, 0.0f);
        this.arrowTranslate.setTranslation(this.transVec);
        this.doUpdateLocation(source, target);
        this.applyUpdate = true;
    }

    @Override
    public void applyTransform() {
        super.applyTransform();
        if (this.applyUpdate) {
            this.arrowTransform.setTransform(this.arrowTranslate);
            this.applyUpdate = false;
        }
    }
}

