/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui.styleBuilder;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import repast.simphony.visualization.gui.styleBuilder.IconFactory2D;
import repast.simphony.visualization.gui.styleBuilder.PreviewIcon;

public class PreviewIcon2D
extends JLabel
implements PreviewIcon {
    private GeneralPath polygonShape;
    private Shape shape;
    private Shape previewShape;
    private Image iconImage;
    private String mark = null;
    private Color fillColor = Color.WHITE;
    private double fillOpacity = 1.0;
    private Color outlineColor = Color.BLACK;
    private double outlineOpacity = 1.0;
    private double outlineThickness = 1.0;
    private float markSize = 6.0f;
    private Image image;
    private Font font = new Font("Arial", 0, 12);
    private Color fontColor = Color.BLACK;

    public PreviewIcon2D() {
        this.image = new BufferedImage(200, 100, 6);
        this.setText("");
        this.setIcon(new ImageIcon(this.image));
        this.polygonShape = new GeneralPath();
        this.polygonShape.moveTo(10.0f, 10.0f);
        this.polygonShape.lineTo(90.0f, 30.0f);
        this.polygonShape.lineTo(70.0f, 90.0f);
        this.polygonShape.lineTo(10.0f, 90.0f);
        this.polygonShape.closePath();
        this.shape = this.polygonShape;
        this.updatePreview();
    }

    @Override
    public void updatePreview() {
        Graphics2D g2d = (Graphics2D)this.image.getGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, 200, 100);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.fillColor);
        g2d.setComposite(AlphaComposite.getInstance(3, (float)this.fillOpacity));
        float maxY = 0.0f;
        if (this.iconImage == null) {
            g2d.fill(this.shape);
            g2d.setColor(this.outlineColor);
            g2d.setComposite(AlphaComposite.getInstance(3, (float)this.outlineOpacity));
            g2d.setStroke(new BasicStroke((float)this.outlineThickness));
            g2d.draw(this.shape);
            maxY = Double.valueOf(this.shape.getBounds2D().getBounds2D().getMaxY()).floatValue();
        } else {
            double xscale = 1.0;
            double yscale = 1.0;
            if (this.markSize != -1.0f) {
                xscale = this.markSize / (float)this.iconImage.getHeight(null);
                yscale = this.markSize / (float)this.iconImage.getHeight(null);
            }
            double x = 80.0;
            double y = 20.0;
            AffineTransform transform = new AffineTransform(xscale, 0.0, 0.0, yscale, x, y);
            g2d.drawImage(this.iconImage, transform, null);
            maxY = (float)((double)this.iconImage.getHeight(null) + y);
        }
        g2d.setColor(this.fontColor);
        g2d.setFont(this.font);
        g2d.drawString("Sample Label", 50.0f, maxY + this.font.getSize2D());
        this.setIcon(new ImageIcon(this.image));
    }

    @Override
    public void setEditorFontColor(Color color) {
        this.fontColor = color;
        this.updatePreview();
    }

    @Override
    public void setEditorFont(Font font) {
        this.font = font;
        this.updatePreview();
    }

    @Override
    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        this.updatePreview();
    }

    public void setFillOpacity(double fillOpacity) {
        this.fillOpacity = fillOpacity;
        this.updatePreview();
    }

    @Override
    public void setMark(String mark) {
        this.mark = mark;
        this.updateShape();
        this.updatePreview();
    }

    public void setShape(Shape shape) {
        this.previewShape = shape;
        this.updateShape();
        this.updatePreview();
    }

    public void setShapeToLine() {
        GeneralPath path = new GeneralPath();
        path.moveTo(10.0f, 10.0f);
        path.lineTo(90.0f, 90.0f);
        this.shape = path;
        this.updatePreview();
    }

    private void updateShape() {
        float ms = this.markSize == -1.0f ? 15.0f : this.markSize;
        this.shape = this.mark != null ? AffineTransform.getScaleInstance(ms, ms).createTransformedShape(IconFactory2D.getShape(this.mark)) : AffineTransform.getScaleInstance(ms, ms).createTransformedShape(this.previewShape);
        AffineTransform transform = AffineTransform.getTranslateInstance(100.0, 50.0);
        this.shape = transform.createTransformedShape(this.shape);
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
        this.updatePreview();
    }

    public void setOutlineOpacity(double outlineOpacity) {
        this.outlineOpacity = outlineOpacity;
        this.updatePreview();
    }

    @Override
    public void setMarkSize(float markSize) {
        this.markSize = markSize;
        this.updateShape();
        this.updatePreview();
    }

    public void setOutlineThickness(double outlineThickness) {
        this.outlineThickness = outlineThickness;
        this.updatePreview();
    }

    @Override
    public void setIconFile(File file) {
        if (file == null) {
            this.iconImage = null;
            this.updatePreview();
            return;
        }
        try {
            this.iconImage = ImageIO.read(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.updatePreview();
    }
}

