/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui.styleBuilder;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XStream11XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import repast.simphony.ui.plugin.editor.SquareIcon;
import repast.simphony.visualization.editedStyle.DefaultEditedValueLayerStyleData2D;
import repast.simphony.visualization.editedStyle.DefaultEditedValueLayerStyleData3D;
import repast.simphony.visualization.editedStyle.EditedStyleUtils;
import repast.simphony.visualization.editedStyle.EditedValueLayerStyleData;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;

public class EditedValueLayerStyleDialog
extends JDialog {
    private boolean save = false;
    private EditedValueLayerStyleData userStyleData;
    private String valueLayerName;
    private String userStyleName;
    private String displayType;
    private JPanel dialogPane;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel panel1;
    private JPanel panel6;
    private JLabel label1;
    private JButton iconColorbutton;
    private JLabel label15;
    private JLabel label2;
    private JLabel label16;
    private JLabel label17;
    private JLabel label18;
    private JLabel label12;
    private JTextField RedTextField;
    private JCheckBox RedCheckBox;
    private JTextField RedMinTextField;
    private JTextField RedMaxTextField;
    private JTextField RedScaleTextField;
    private JLabel label13;
    private JTextField GreenTextField;
    private JCheckBox GreenCheckBox;
    private JTextField GreenMinTextField;
    private JTextField GreenMaxTextField;
    private JTextField GreenScaleTextField;
    private JLabel label14;
    private JTextField BlueTextField;
    private JCheckBox BlueCheckBox;
    private JTextField BlueMinTextField;
    private JTextField BlueMaxTextField;
    private JTextField BlueScaleTextField;
    private JSeparator separator1;
    private JLabel label3;
    private JTextField HeightTextField;
    private JCheckBox HeightCheckBox;
    private JTextField HeightMinTextField;
    private JTextField HeightMaxTextField;
    private JTextField HeightScaleTextField;
    private JSeparator separator2;
    private JLabel label4;
    private JTextField CellTextField;

    public EditedValueLayerStyleDialog(Frame owner) {
        super(owner);
    }

    public EditedValueLayerStyleDialog(Dialog owner) {
        super(owner);
    }

    public void init(String valueLayerName, String userStyleName, CartesianDisplayDescriptor descriptor) {
        this.valueLayerName = valueLayerName;
        this.userStyleName = userStyleName;
        this.displayType = descriptor.getDisplayType();
        this.userStyleData = EditedStyleUtils.getValueLayerStyle(descriptor.getValueLayerEditedStyleName());
        if (this.userStyleData == null) {
            if (this.displayType.equals("2D")) {
                this.userStyleData = new DefaultEditedValueLayerStyleData2D();
            } else if (this.displayType.equals("3D")) {
                this.userStyleData = new DefaultEditedValueLayerStyleData3D();
            }
        }
        this.initComponents();
        this.initMyComponents(this.displayType);
    }

    private void initMyComponents(String displayType) {
        float[] c = this.userStyleData.getColor();
        this.RedTextField.setText(Float.toString(c[0]));
        this.GreenTextField.setText(Float.toString(c[1]));
        this.BlueTextField.setText(Float.toString(c[2]));
        this.iconColorbutton.setIcon((Icon)new SquareIcon(15, 15, new Color(c[0], c[1], c[2])));
        boolean[] cval = this.userStyleData.getColorValue();
        this.RedCheckBox.setSelected(cval[0]);
        this.GreenCheckBox.setSelected(cval[1]);
        this.BlueCheckBox.setSelected(cval[2]);
        c = this.userStyleData.getColorMin();
        this.RedMinTextField.setText(Float.toString(c[0]));
        this.GreenMinTextField.setText(Float.toString(c[1]));
        this.BlueMinTextField.setText(Float.toString(c[2]));
        c = this.userStyleData.getColorMax();
        this.RedMaxTextField.setText(Float.toString(c[0]));
        this.GreenMaxTextField.setText(Float.toString(c[1]));
        this.BlueMaxTextField.setText(Float.toString(c[2]));
        c = this.userStyleData.getColorScale();
        this.RedScaleTextField.setText(Float.toString(c[0]));
        this.GreenScaleTextField.setText(Float.toString(c[1]));
        this.BlueScaleTextField.setText(Float.toString(c[2]));
        this.CellTextField.setText(Float.toString(this.userStyleData.getCellSize()));
        if (displayType.equals("2D")) {
            this.setTitle("2D Value Layer Editor");
            this.HeightTextField.setEnabled(false);
            this.HeightCheckBox.setEnabled(false);
            this.HeightMinTextField.setEnabled(false);
            this.HeightMaxTextField.setEnabled(false);
            this.HeightScaleTextField.setEnabled(false);
        } else {
            this.setTitle("3D Shape Editor");
            this.HeightTextField.setText(Float.toString(this.userStyleData.getY()));
            this.HeightCheckBox.setSelected(this.userStyleData.isYValue());
            this.HeightMinTextField.setText(Float.toString(this.userStyleData.getYMin()));
            this.HeightMaxTextField.setText(Float.toString(this.userStyleData.getYMax()));
            this.HeightScaleTextField.setText(Float.toString(this.userStyleData.getYScale()));
        }
    }

    public void writeStyleData() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver((XmlFriendlyReplacer)new XStream11XmlFriendlyReplacer())){

            protected boolean useXStream11XmlFriendlyMapper() {
                return true;
            }
        };
        File file = null;
        try {
            File dir = new File(EditedStyleUtils.getStyleDirName());
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (this.userStyleName != null) {
                file = new File(dir, this.userStyleName);
            } else {
                int cnt = 0;
                this.userStyleName = String.valueOf(this.valueLayerName) + ".style_" + cnt + ".xml";
                file = new File(dir, this.userStyleName);
                while (file.exists()) {
                    this.userStyleName = String.valueOf(this.valueLayerName) + ".style_" + cnt + ".xml";
                    file = new File(dir, this.userStyleName);
                    ++cnt;
                }
            }
            FileWriter fw = new FileWriter(file);
            xstream.toXML((Object)this.userStyleData, (Writer)fw);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean doSave() {
        return this.save;
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColor();
        c[0] = Float.valueOf(this.RedTextField.getText()).floatValue();
        c[1] = Float.valueOf(this.GreenTextField.getText()).floatValue();
        c[2] = Float.valueOf(this.BlueTextField.getText()).floatValue();
        float[] minc = this.userStyleData.getColorMin();
        minc[0] = Float.valueOf(this.RedMinTextField.getText()).floatValue();
        minc[1] = Float.valueOf(this.GreenMinTextField.getText()).floatValue();
        minc[2] = Float.valueOf(this.BlueMinTextField.getText()).floatValue();
        float[] maxc = this.userStyleData.getColorMax();
        maxc[0] = Float.valueOf(this.RedMaxTextField.getText()).floatValue();
        maxc[1] = Float.valueOf(this.GreenMaxTextField.getText()).floatValue();
        maxc[2] = Float.valueOf(this.BlueMaxTextField.getText()).floatValue();
        float[] scalec = this.userStyleData.getColorScale();
        scalec[0] = Float.valueOf(this.RedScaleTextField.getText()).floatValue();
        scalec[1] = Float.valueOf(this.GreenScaleTextField.getText()).floatValue();
        scalec[2] = Float.valueOf(this.BlueScaleTextField.getText()).floatValue();
        if (this.validateColorRange(c)) {
            this.save = true;
            this.userStyleData.setColor(c);
            this.userStyleData.setColorMin(minc);
            this.userStyleData.setColorMax(maxc);
            this.userStyleData.setColorScale(scalec);
            this.userStyleData.setCellSize(Float.valueOf(this.CellTextField.getText()).floatValue());
            if (this.displayType.equals("3D")) {
                this.userStyleData.setY(Float.valueOf(this.HeightTextField.getText()).floatValue());
                this.userStyleData.setYMin(Float.valueOf(this.HeightMinTextField.getText()).floatValue());
                this.userStyleData.setYMax(Float.valueOf(this.HeightMaxTextField.getText()).floatValue());
                this.userStyleData.setYScale(Float.valueOf(this.HeightScaleTextField.getText()).floatValue());
            }
            this.writeStyleData();
            this.dispose();
        }
    }

    private void iconColorbuttonActionPerformed(ActionEvent e) {
        float[] iconColor = this.userStyleData.getColor();
        Color iconPaint = new Color(iconColor[0], iconColor[1], iconColor[2]);
        Color color = JColorChooser.showDialog(this, "Choose an Icon Color", iconPaint);
        if (color != null) {
            float[] col = color.getRGBColorComponents(null);
            this.userStyleData.setColor(col);
            this.iconColorbutton.setIcon((Icon)new SquareIcon(15, 15, color));
            this.RedTextField.setText(Float.toString(col[0]));
            this.GreenTextField.setText(Float.toString(col[1]));
            this.BlueTextField.setText(Float.toString(col[2]));
        }
    }

    private boolean validateColorRange(float[] c) {
        int i = 0;
        while (i < c.length) {
            if (c[i] < 0.0f || c[i] > 1.0f) {
                JOptionPane.showMessageDialog(null, "The valid range for color values is 0 - 1", "Color value out of bounds", 2);
                return false;
            }
            ++i;
        }
        return true;
    }

    private void RedCheckBoxActionPerformed(ActionEvent e) {
        AbstractButton abstractButton = (AbstractButton)e.getSource();
        boolean selected = abstractButton.getModel().isSelected();
        boolean[] cval = this.userStyleData.getColorValue();
        cval[0] = selected;
        this.userStyleData.setColorValue(cval);
    }

    private void GreenCheckBoxActionPerformed(ActionEvent e) {
        AbstractButton abstractButton = (AbstractButton)e.getSource();
        boolean selected = abstractButton.getModel().isSelected();
        boolean[] cval = this.userStyleData.getColorValue();
        cval[1] = selected;
        this.userStyleData.setColorValue(cval);
    }

    private void BlueCheckBoxActionPerformed(ActionEvent e) {
        AbstractButton abstractButton = (AbstractButton)e.getSource();
        boolean selected = abstractButton.getModel().isSelected();
        boolean[] cval = this.userStyleData.getColorValue();
        cval[2] = selected;
        this.userStyleData.setColorValue(cval);
    }

    private void HeightCheckBoxActionPerformed(ActionEvent e) {
        AbstractButton abstractButton = (AbstractButton)e.getSource();
        boolean selected = abstractButton.getModel().isSelected();
        this.userStyleData.setYValue(selected);
    }

    public String getUserStyleName() {
        return this.userStyleName;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.panel1 = new JPanel();
        this.panel6 = new JPanel();
        this.label1 = new JLabel();
        this.iconColorbutton = new JButton();
        this.label15 = new JLabel();
        this.label2 = new JLabel();
        this.label16 = new JLabel();
        this.label17 = new JLabel();
        this.label18 = new JLabel();
        this.label12 = new JLabel();
        this.RedTextField = new JTextField();
        this.RedCheckBox = new JCheckBox();
        this.RedMinTextField = new JTextField();
        this.RedMaxTextField = new JTextField();
        this.RedScaleTextField = new JTextField();
        this.label13 = new JLabel();
        this.GreenTextField = new JTextField();
        this.GreenCheckBox = new JCheckBox();
        this.GreenMinTextField = new JTextField();
        this.GreenMaxTextField = new JTextField();
        this.GreenScaleTextField = new JTextField();
        this.label14 = new JLabel();
        this.BlueTextField = new JTextField();
        this.BlueCheckBox = new JCheckBox();
        this.BlueMinTextField = new JTextField();
        this.BlueMaxTextField = new JTextField();
        this.BlueScaleTextField = new JTextField();
        this.separator1 = new JSeparator();
        this.label3 = new JLabel();
        this.HeightTextField = new JTextField();
        this.HeightCheckBox = new JCheckBox();
        this.HeightMinTextField = new JTextField();
        this.HeightMaxTextField = new JTextField();
        this.HeightScaleTextField = new JTextField();
        this.separator2 = new JSeparator();
        this.label4 = new JLabel();
        this.CellTextField = new JTextField();
        CellConstraints cc = new CellConstraints();
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG);
        this.dialogPane.setLayout(new BorderLayout());
        this.buttonBar.setBorder(Borders.BUTTON_BAR_PAD);
        this.buttonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.GLUE_COLSPEC, FormSpecs.BUTTON_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedValueLayerStyleDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, cc.xy(2, 1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedValueLayerStyleDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, cc.xy(4, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"left:max(default;166dlu):grow"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)133)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"default")));
        this.panel6.setBorder(new TitledBorder("Value Layer Properties"));
        this.panel6.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.label1.setText("Base Color");
        this.panel6.add((Component)this.label1, cc.xy(1, 1));
        this.iconColorbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedValueLayerStyleDialog.this.iconColorbuttonActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.iconColorbutton, cc.xy(3, 1));
        this.label15.setText("Value");
        this.panel6.add((Component)this.label15, cc.xy(3, 3));
        this.label2.setText("Use Value Layer Data");
        this.panel6.add((Component)this.label2, cc.xy(7, 3));
        this.label16.setText("Minimum");
        this.panel6.add((Component)this.label16, cc.xy(11, 3));
        this.label17.setText("Maximum");
        this.panel6.add((Component)this.label17, cc.xy(15, 3));
        this.label18.setText("Scaling");
        this.panel6.add((Component)this.label18, cc.xy(19, 3));
        this.label12.setText("Red");
        this.panel6.add((Component)this.label12, cc.xy(1, 5));
        this.panel6.add((Component)this.RedTextField, cc.xy(3, 5));
        this.RedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedValueLayerStyleDialog.this.RedCheckBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.RedCheckBox, cc.xy(7, 5));
        this.panel6.add((Component)this.RedMinTextField, cc.xy(11, 5));
        this.panel6.add((Component)this.RedMaxTextField, cc.xy(15, 5));
        this.panel6.add((Component)this.RedScaleTextField, cc.xy(19, 5));
        this.label13.setText("Green");
        this.panel6.add((Component)this.label13, cc.xy(1, 7));
        this.panel6.add((Component)this.GreenTextField, cc.xy(3, 7));
        this.GreenCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedValueLayerStyleDialog.this.GreenCheckBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.GreenCheckBox, cc.xy(7, 7));
        this.panel6.add((Component)this.GreenMinTextField, cc.xy(11, 7));
        this.panel6.add((Component)this.GreenMaxTextField, cc.xy(15, 7));
        this.panel6.add((Component)this.GreenScaleTextField, cc.xy(19, 7));
        this.label14.setText("Blue");
        this.panel6.add((Component)this.label14, cc.xy(1, 9));
        this.panel6.add((Component)this.BlueTextField, cc.xy(3, 9));
        this.BlueCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedValueLayerStyleDialog.this.BlueCheckBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.BlueCheckBox, cc.xy(7, 9));
        this.panel6.add((Component)this.BlueMinTextField, cc.xy(11, 9));
        this.panel6.add((Component)this.BlueMaxTextField, cc.xy(15, 9));
        this.panel6.add((Component)this.BlueScaleTextField, cc.xy(19, 9));
        this.panel6.add((Component)this.separator1, cc.xywh(1, 11, 19, 1));
        this.label3.setText("Height");
        this.panel6.add((Component)this.label3, cc.xy(1, 13));
        this.panel6.add((Component)this.HeightTextField, cc.xy(3, 13));
        this.HeightCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedValueLayerStyleDialog.this.HeightCheckBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.HeightCheckBox, cc.xy(7, 13));
        this.panel6.add((Component)this.HeightMinTextField, cc.xy(11, 13));
        this.panel6.add((Component)this.HeightMaxTextField, cc.xy(15, 13));
        this.panel6.add((Component)this.HeightScaleTextField, cc.xy(19, 13));
        this.panel6.add((Component)this.separator2, cc.xywh(1, 15, 19, 1));
        this.label4.setText("Cell size");
        this.panel6.add((Component)this.label4, cc.xy(1, 17));
        this.panel6.add((Component)this.CellTextField, cc.xy(3, 17));
        this.panel1.add((Component)this.panel6, cc.xywh(1, 1, 5, 1));
        this.dialogPane.add((Component)this.panel1, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(540, 335);
        this.setLocationRelativeTo(this.getOwner());
    }
}

