/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui.styleBuilder;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XStream11XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;
import org.jscience.physics.amount.Amount;
import repast.simphony.scenario.ScenarioUtils;
import repast.simphony.ui.plugin.editor.SquareIcon;
import repast.simphony.visualization.editedStyle.DefaultEditedStyleData2D;
import repast.simphony.visualization.editedStyle.DefaultEditedStyleData3D;
import repast.simphony.visualization.editedStyle.EditedStyleData;
import repast.simphony.visualization.editedStyle.EditedStyleUtils;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.gui.styleBuilder.IconFactory2D;
import repast.simphony.visualization.gui.styleBuilder.IconFile2DFilter;
import repast.simphony.visualization.gui.styleBuilder.ModelFile3DFilter;
import repast.simphony.visualization.gui.styleBuilder.PreviewIcon;
import repast.simphony.visualization.gui.styleBuilder.PreviewIcon2D;
import repast.simphony.visualization.gui.styleBuilder.PreviewIcon3D;

public class EditedStyleDialog
extends JDialog {
    private boolean save = false;
    private EditedStyleData userStyleData;
    private static final Set<Class> pTypes = new HashSet<Class>();
    private List<String> methodList = new ArrayList<String>();
    private List<String> labelMethodList = new ArrayList<String>();
    private DefaultComboBoxModel sizeModel;
    private DefaultComboBoxModel sizeMinModel;
    private DefaultComboBoxModel sizeMaxModel;
    private DefaultComboBoxModel sizeScaleModel;
    private DefaultComboBoxModel labelModel;
    private DefaultComboBoxModel labelFontFamilyModel;
    private DefaultComboBoxModel shapeModel;
    private DefaultComboBoxModel variableIconRedColorValueModel;
    private DefaultComboBoxModel variableIconGreenColorValueModel;
    private DefaultComboBoxModel variableIconBlueColorValueModel;
    private DefaultComboBoxModel variableIconRedColorMinModel;
    private DefaultComboBoxModel variableIconGreenColorMinModel;
    private DefaultComboBoxModel variableIconBlueColorMinModel;
    private DefaultComboBoxModel variableIconRedColorMaxModel;
    private DefaultComboBoxModel variableIconGreenColorMaxModel;
    private DefaultComboBoxModel variableIconBlueColorMaxModel;
    private DefaultComboBoxModel variableIconRedColorScaleModel;
    private DefaultComboBoxModel variableIconGreenColorScaleModel;
    private DefaultComboBoxModel variableIconBlueColorScaleModel;
    private String agentClassName;
    private String userStyleName;
    private String displayType;
    private PreviewIcon preview;
    private JPanel dialogPane;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel panel1;
    private JPanel shapePanel;
    private JComboBox shapeComboBox;
    private JButton iconColorbutton;
    private JButton iconButton;
    private JButton clearFileButton;
    private JButton textureButton;
    private JButton clearTextureButton;
    private JPanel previewPanel;
    private JPanel panel3;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JComboBox sizeComboBox;
    private JComboBox sizeMinComboBox;
    private JComboBox sizeMaxComboBox;
    private JComboBox sizeScaleComboBox;
    private JPanel panel4;
    private JLabel label5;
    private JLabel label6;
    private JLabel label7;
    private JLabel label19;
    private JComboBox labelComboBox;
    private JComboBox labelPositionComboBox;
    private JTextField labelOffsetTextField;
    private JComboBox labelPrecisionComboBox;
    private JPanel panel2;
    private JLabel label8;
    private JLabel label9;
    private JLabel label10;
    private JLabel label11;
    private JComboBox labelFontFamilyComboBox;
    private JComboBox labelFontSizeComboBox;
    private JComboBox labelFontStyleComboBox;
    private JButton fontColorButton;
    private JPanel panel6;
    private JLabel label15;
    private JLabel label16;
    private JLabel label17;
    private JLabel label18;
    private JLabel label12;
    private JComboBox redValueComboBox;
    private JComboBox redMinComboBox;
    private JComboBox redMaxComboBox;
    private JComboBox redScaleComboBox;
    private JLabel label13;
    private JComboBox greenValueComboBox;
    private JComboBox greenMinComboBox;
    private JComboBox greenMaxComboBox;
    private JComboBox greenScaleComboBox;
    private JLabel label14;
    private JComboBox blueValueComboBox;
    private JComboBox blueMinComboBox;
    private JComboBox blueMaxComboBox;
    private JComboBox blueScaleComboBox;

    static {
        pTypes.add(Integer.TYPE);
        pTypes.add(Double.TYPE);
        pTypes.add(Float.TYPE);
        pTypes.add(Long.TYPE);
        pTypes.add(Byte.TYPE);
        pTypes.add(Short.TYPE);
        pTypes.add(Amount.class);
        pTypes.add(Object.class);
    }

    public EditedStyleDialog(Frame owner) {
        super(owner);
    }

    public EditedStyleDialog(Dialog owner) {
        super(owner);
    }

    public void init(Class agentClass, String userStyleName, CartesianDisplayDescriptor descriptor) {
        Method[] methods;
        this.agentClassName = agentClass.getCanonicalName();
        this.userStyleName = userStyleName;
        this.displayType = descriptor.getDisplayType();
        this.userStyleData = EditedStyleUtils.getStyle(descriptor.getEditedStyleName(agentClass.getName()));
        Method[] methodArray = methods = agentClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.isSynthetic()) {
                if (method.getParameterTypes().length == 0 && (pTypes.contains(method.getReturnType()) || Number.class.isAssignableFrom(method.getReturnType()))) {
                    this.methodList.add(method.getName());
                }
                if (method.getParameterTypes().length == 0 && (pTypes.contains(method.getReturnType()) || Number.class.isAssignableFrom(method.getReturnType()) || method.getReturnType().equals(String.class))) {
                    this.labelMethodList.add(method.getName());
                }
            }
            ++n2;
        }
        this.methodList.remove("hashCode");
        this.labelMethodList.remove("hashCode");
        this.labelMethodList.remove("toString");
        this.labelMethodList.add("Name");
        if (this.displayType.equals("2D")) {
            if (this.userStyleData == null) {
                this.userStyleData = new DefaultEditedStyleData2D();
            }
            this.shapeModel = new DefaultComboBoxModel<String>(IconFactory2D.Shape_List);
            this.shapeModel.setSelectedItem(this.userStyleData.getShapeWkt());
        } else {
            if (this.userStyleData == null) {
                this.userStyleData = new DefaultEditedStyleData3D();
            }
            this.shapeModel = new DefaultComboBoxModel<String>(new String[]{"sphere", "cube", "cylinder", "cone"});
            this.shapeModel.setSelectedItem(this.userStyleData.getShapeWkt());
        }
        this.sizeModel = new DefaultComboBoxModel();
        this.sizeMinModel = new DefaultComboBoxModel();
        this.sizeMaxModel = new DefaultComboBoxModel();
        this.sizeScaleModel = new DefaultComboBoxModel();
        this.labelModel = new DefaultComboBoxModel();
        this.labelFontFamilyModel = new DefaultComboBoxModel();
        this.variableIconRedColorValueModel = new DefaultComboBoxModel();
        this.variableIconGreenColorValueModel = new DefaultComboBoxModel();
        this.variableIconBlueColorValueModel = new DefaultComboBoxModel();
        this.variableIconRedColorMinModel = new DefaultComboBoxModel();
        this.variableIconGreenColorMinModel = new DefaultComboBoxModel();
        this.variableIconBlueColorMinModel = new DefaultComboBoxModel();
        this.variableIconRedColorMaxModel = new DefaultComboBoxModel();
        this.variableIconGreenColorMaxModel = new DefaultComboBoxModel();
        this.variableIconBlueColorMaxModel = new DefaultComboBoxModel();
        this.variableIconRedColorScaleModel = new DefaultComboBoxModel();
        this.variableIconGreenColorScaleModel = new DefaultComboBoxModel();
        this.variableIconBlueColorScaleModel = new DefaultComboBoxModel();
        for (String string : this.methodList) {
            this.sizeModel.addElement(string);
            this.sizeMinModel.addElement(string);
            this.sizeMaxModel.addElement(string);
            this.sizeScaleModel.addElement(string);
            this.variableIconRedColorValueModel.addElement(string);
            this.variableIconGreenColorValueModel.addElement(string);
            this.variableIconBlueColorValueModel.addElement(string);
        }
        for (String string : this.labelMethodList) {
            this.labelModel.addElement(string);
        }
        if (this.userStyleData.getSizeMethodName() != null) {
            this.sizeModel.setSelectedItem(this.userStyleData.getSizeMethodName());
        } else {
            this.sizeModel.addElement(Float.valueOf(this.userStyleData.getSize()));
            this.sizeModel.setSelectedItem(Float.valueOf(this.userStyleData.getSize()));
        }
        if (this.userStyleData.getSizeMinMethodName() != null) {
            this.sizeMinModel.setSelectedItem(this.userStyleData.getSizeMinMethodName());
        } else {
            this.sizeMinModel.addElement(Float.valueOf(this.userStyleData.getSizeMin()));
            this.sizeMinModel.setSelectedItem(Float.valueOf(this.userStyleData.getSizeMin()));
        }
        if (this.userStyleData.getSizeMaxMethodName() != null) {
            this.sizeMaxModel.setSelectedItem(this.userStyleData.getSizeMaxMethodName());
        } else {
            this.sizeMaxModel.addElement(Float.valueOf(this.userStyleData.getSizeMax()));
            this.sizeMaxModel.setSelectedItem(Float.valueOf(this.userStyleData.getSizeMax()));
        }
        if (this.userStyleData.getSizeScaleMethodName() != null) {
            this.sizeScaleModel.setSelectedItem(this.userStyleData.getSizeScaleMethodName());
        } else {
            this.sizeScaleModel.addElement(Float.valueOf(this.userStyleData.getSizeScale()));
            this.sizeScaleModel.setSelectedItem(Float.valueOf(this.userStyleData.getSizeScale()));
        }
        if (this.userStyleData.getLabelMethod() != null) {
            if ("toString".equals(this.userStyleData.getLabelMethod())) {
                this.labelModel.setSelectedItem("Name");
            } else {
                this.labelModel.setSelectedItem(this.userStyleData.getLabelMethod());
            }
        } else {
            this.labelModel.addElement(this.userStyleData.getLabel());
            this.labelModel.setSelectedItem(this.userStyleData.getLabel());
        }
        if (this.userStyleData.getRedMethod() != null) {
            this.variableIconRedColorValueModel.setSelectedItem(this.userStyleData.getRedMethod());
        } else {
            this.variableIconRedColorValueModel.addElement(Float.valueOf(this.userStyleData.getColor()[0]));
            this.variableIconRedColorValueModel.setSelectedItem(Float.valueOf(this.userStyleData.getColor()[0]));
        }
        if (this.userStyleData.getGreenMethod() != null) {
            this.variableIconGreenColorValueModel.setSelectedItem(this.userStyleData.getGreenMethod());
        } else {
            this.variableIconGreenColorValueModel.addElement(Float.valueOf(this.userStyleData.getColor()[1]));
            this.variableIconGreenColorValueModel.setSelectedItem(Float.valueOf(this.userStyleData.getColor()[1]));
        }
        if (this.userStyleData.getBlueMethod() != null) {
            this.variableIconBlueColorValueModel.setSelectedItem(this.userStyleData.getBlueMethod());
        } else {
            this.variableIconBlueColorValueModel.addElement(Float.valueOf(this.userStyleData.getColor()[2]));
            this.variableIconBlueColorValueModel.setSelectedItem(Float.valueOf(this.userStyleData.getColor()[2]));
        }
        this.variableIconRedColorMinModel.addElement(Float.valueOf(this.userStyleData.getColorMin()[0]));
        this.variableIconRedColorMinModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMin()[0]));
        this.variableIconGreenColorMinModel.addElement(Float.valueOf(this.userStyleData.getColorMin()[1]));
        this.variableIconGreenColorMinModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMin()[1]));
        this.variableIconBlueColorMinModel.addElement(Float.valueOf(this.userStyleData.getColorMin()[2]));
        this.variableIconBlueColorMinModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMin()[2]));
        this.variableIconRedColorMaxModel.addElement(Float.valueOf(this.userStyleData.getColorMax()[0]));
        this.variableIconRedColorMaxModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMax()[0]));
        this.variableIconGreenColorMaxModel.addElement(Float.valueOf(this.userStyleData.getColorMax()[1]));
        this.variableIconGreenColorMaxModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMax()[1]));
        this.variableIconBlueColorMaxModel.addElement(Float.valueOf(this.userStyleData.getColorMax()[2]));
        this.variableIconBlueColorMaxModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMax()[2]));
        this.variableIconRedColorScaleModel.addElement(Float.valueOf(this.userStyleData.getColorScale()[0]));
        this.variableIconRedColorScaleModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorScale()[0]));
        this.variableIconGreenColorScaleModel.addElement(Float.valueOf(this.userStyleData.getColorScale()[1]));
        this.variableIconGreenColorScaleModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorScale()[1]));
        this.variableIconBlueColorScaleModel.addElement(Float.valueOf(this.userStyleData.getColorScale()[2]));
        this.variableIconBlueColorScaleModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorScale()[2]));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < fontList.length) {
            this.labelFontFamilyModel.addElement(fontList[i]);
            ++i;
        }
        if (this.labelFontFamilyModel.getIndexOf(this.userStyleData.getLabelFontFamily()) != -1) {
            this.labelFontFamilyModel.setSelectedItem(this.userStyleData.getLabelFontFamily());
        }
        this.initComponents();
        this.initMyComponents(this.displayType);
    }

    public void initMyComponents(String displayType) {
        CellConstraints cc = new CellConstraints();
        this.shapeComboBox.setModel(this.shapeModel);
        this.sizeComboBox.setModel(this.sizeModel);
        this.sizeMinComboBox.setModel(this.sizeMinModel);
        this.sizeMaxComboBox.setModel(this.sizeMaxModel);
        this.sizeScaleComboBox.setModel(this.sizeScaleModel);
        this.labelComboBox.setModel(this.labelModel);
        this.labelOffsetTextField.setText(Float.toString(this.userStyleData.getLabelOffset()));
        this.labelFontFamilyComboBox.setModel(this.labelFontFamilyModel);
        this.labelPositionComboBox.getModel().setSelectedItem(this.userStyleData.getLabelPosition());
        this.redValueComboBox.setModel(this.variableIconRedColorValueModel);
        this.greenValueComboBox.setModel(this.variableIconGreenColorValueModel);
        this.blueValueComboBox.setModel(this.variableIconBlueColorValueModel);
        this.redMinComboBox.setModel(this.variableIconRedColorMinModel);
        this.greenMinComboBox.setModel(this.variableIconGreenColorMinModel);
        this.blueMinComboBox.setModel(this.variableIconBlueColorMinModel);
        this.redMaxComboBox.setModel(this.variableIconRedColorMaxModel);
        this.greenMaxComboBox.setModel(this.variableIconGreenColorMaxModel);
        this.blueMaxComboBox.setModel(this.variableIconBlueColorMaxModel);
        this.redScaleComboBox.setModel(this.variableIconRedColorScaleModel);
        this.greenScaleComboBox.setModel(this.variableIconGreenColorScaleModel);
        this.blueScaleComboBox.setModel(this.variableIconBlueColorScaleModel);
        if (displayType.equals("2D")) {
            this.setTitle("2D Shape Editor");
            this.preview = new PreviewIcon2D();
            this.previewPanel.add((Component)((PreviewIcon2D)this.preview), cc.xy(1, 1));
            this.iconButton.setText("Select Icon File");
            this.iconButton.setFont(this.iconButton.getFont().deriveFont(0));
            this.clearFileButton.setText("Clear Icon File");
            if (this.userStyleData.getIconFile2D() != null) {
                this.disableColorButtons();
                this.iconButton.setFont(this.iconButton.getFont().deriveFont(1));
                this.iconButton.setText("Icon Set");
            }
            this.textureButton.setVisible(false);
            this.clearTextureButton.setVisible(false);
        } else {
            this.setTitle("3D Shape Editor");
            this.preview = new PreviewIcon3D();
            this.iconButton.setText("Select Model File");
            this.iconButton.setFont(this.iconButton.getFont().deriveFont(0));
            this.clearFileButton.setText("Clear Model File");
            if (this.userStyleData.getModelFile3D() != null) {
                this.disableColorButtons();
                this.iconButton.setFont(this.iconButton.getFont().deriveFont(1));
                this.iconButton.setText("Model Set");
            }
            if (this.userStyleData.getTextureFile3D() != null) {
                this.disableColorButtons();
                this.textureButton.setFont(this.textureButton.getFont().deriveFont(1));
                this.textureButton.setText("Texture Set");
            }
        }
        if (this.userStyleData.getIconFile2D() != null) {
            File iconFile = new File(this.userStyleData.getIconFile2D());
            this.preview.setIconFile(iconFile);
            this.shapeComboBox.setEnabled(false);
            this.iconColorbutton.setEnabled(false);
        }
        this.preview.setMark(this.userStyleData.getShapeWkt());
        this.preview.setMarkSize(this.userStyleData.getSize());
        float[] col = this.userStyleData.getColor();
        this.preview.setFillColor(new Color(col[0], col[1], col[2]));
        float[] labelColor = this.userStyleData.getLabelColor();
        Color labelPaint = new Color(labelColor[0], labelColor[1], labelColor[2]);
        this.fontColorButton.setIcon((Icon)new SquareIcon(14, 14, labelPaint));
        this.preview.setEditorFontColor(labelPaint);
        this.preview.setEditorFont(new Font(this.userStyleData.getLabelFontFamily(), this.userStyleData.getLabelFontType(), this.userStyleData.getLabelFontSize()));
        float[] iconColor = this.userStyleData.getColor();
        Color iconPaint = new Color(iconColor[0], iconColor[1], iconColor[2]);
        this.iconColorbutton.setIcon((Icon)new SquareIcon(14, 14, iconPaint));
        this.labelPrecisionComboBox.getModel().setSelectedItem(Integer.toString(this.userStyleData.getLabelPrecision()));
    }

    public void writeStyleData() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver((XmlFriendlyReplacer)new XStream11XmlFriendlyReplacer())){

            protected boolean useXStream11XmlFriendlyMapper() {
                return true;
            }
        };
        File file = null;
        try {
            File dir = new File(EditedStyleUtils.getStyleDirName());
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (this.userStyleName != null) {
                file = new File(dir, this.userStyleName);
            } else {
                int cnt = 0;
                this.userStyleName = String.valueOf(this.agentClassName) + ".style_" + cnt + ".xml";
                file = new File(dir, this.userStyleName);
                while (file.exists()) {
                    this.userStyleName = String.valueOf(this.agentClassName) + ".style_" + cnt + ".xml";
                    file = new File(dir, this.userStyleName);
                    ++cnt;
                }
            }
            FileWriter fw = new FileWriter(file);
            xstream.toXML((Object)this.userStyleData, (Writer)fw);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean doSave() {
        return this.save;
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.save = true;
        this.writeStyleData();
        this.dispose();
    }

    private void shapeComboBoxActionPerformed(ActionEvent e) {
        this.userStyleData.setShapeWkT((String)this.shapeComboBox.getSelectedItem());
        this.preview.setMark((String)this.shapeComboBox.getSelectedItem());
    }

    private void sizeComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.sizeComboBox.getSelectedItem();
        if (selection instanceof Number) {
            this.userStyleData.setSize(((Float)selection).floatValue());
            this.preview.setMarkSize(((Float)selection).floatValue());
            this.userStyleData.setSizeMethodName(null);
        } else if (this.isUserTypedNumber(selection)) {
            this.userStyleData.setSize(new Float((String)selection).floatValue());
            this.preview.setMarkSize(new Float((String)selection).floatValue());
            this.userStyleData.setSizeMethodName(null);
        } else {
            this.userStyleData.setSizeMethodName((String)selection);
        }
    }

    private void sizeMinComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.sizeMinComboBox.getSelectedItem();
        if (selection instanceof Number) {
            this.userStyleData.setSizeMin(((Float)selection).floatValue());
            this.userStyleData.setSizeMinMethodName(null);
        } else if (this.isUserTypedNumber(selection)) {
            this.userStyleData.setSizeMin(new Float((String)selection).floatValue());
            this.userStyleData.setSizeMinMethodName(null);
        } else {
            this.userStyleData.setSizeMinMethodName((String)selection);
        }
    }

    private void sizeMaxComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.sizeMaxComboBox.getSelectedItem();
        if (selection instanceof Number) {
            this.userStyleData.setSizeMax(((Float)selection).floatValue());
            this.userStyleData.setSizeMaxMethodName(null);
        } else if (this.isUserTypedNumber(selection)) {
            this.userStyleData.setSizeMax(new Float((String)selection).floatValue());
            this.userStyleData.setSizeMaxMethodName(null);
        } else {
            this.userStyleData.setSizeMaxMethodName((String)selection);
        }
    }

    private void sizeScaleComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.sizeScaleComboBox.getSelectedItem();
        if (selection instanceof Number) {
            this.userStyleData.setSizeScale(((Float)selection).floatValue());
            this.userStyleData.setSizeScaleMethodName(null);
        } else if (this.isUserTypedNumber(selection)) {
            this.userStyleData.setSizeScale(new Float((String)selection).floatValue());
            this.userStyleData.setSizeScaleMethodName(null);
        } else {
            this.userStyleData.setSizeScaleMethodName((String)selection);
        }
    }

    private void labelComboBoxActionPerformed(ActionEvent e) {
        String selection = (String)this.labelComboBox.getSelectedItem();
        if ("Name".equals(selection)) {
            this.userStyleData.setLabelMethod("toString");
        } else if (this.labelMethodList.contains(selection)) {
            this.userStyleData.setLabelMethod(selection);
        } else {
            this.userStyleData.setLabel(selection);
            this.userStyleData.setLabelMethod(null);
        }
    }

    private void labelPositionComboBoxActionPerformed(ActionEvent e) {
        this.userStyleData.setLabelPosition((String)this.labelPositionComboBox.getSelectedItem());
    }

    private void labelOffsetTextFieldActionPerformed(ActionEvent e) {
        this.userStyleData.setLabelOffset(new Float(this.labelOffsetTextField.getText()).floatValue());
    }

    private void labelFontFamilyComboBoxActionPerformed(ActionEvent e) {
        String family = (String)this.labelFontFamilyComboBox.getSelectedItem();
        this.userStyleData.setLabelFontFamily(family);
        int type = this.labelFontStyleComboBox.getSelectedIndex();
        int size = new Integer((String)this.labelFontSizeComboBox.getSelectedItem());
        Font font = new Font(family, type, size);
        this.preview.setEditorFont(font);
    }

    private void labelFontSizeComboBoxActionPerformed(ActionEvent e) {
        String size = (String)this.labelFontSizeComboBox.getSelectedItem();
        this.userStyleData.setLabelFontSize(new Integer(size));
        int type = this.labelFontStyleComboBox.getSelectedIndex();
        String family = (String)this.labelFontFamilyComboBox.getSelectedItem();
        Font font = new Font(family, type, new Integer(size));
        this.preview.setEditorFont(font);
    }

    private void labelFontStyleComboBoxActionPerformed(ActionEvent e) {
        int type = this.labelFontStyleComboBox.getSelectedIndex();
        this.userStyleData.setLabelFontType(type);
        int size = new Integer((String)this.labelFontSizeComboBox.getSelectedItem());
        String family = (String)this.labelFontFamilyComboBox.getSelectedItem();
        Font font = new Font(family, type, size);
        this.preview.setEditorFont(font);
    }

    private void fontColorButtonActionPerformed(ActionEvent e) {
        float[] labelColor = this.userStyleData.getLabelColor();
        Color labelPaint = new Color(labelColor[0], labelColor[1], labelColor[2]);
        Color color = JColorChooser.showDialog(this, "Choose a Font Color", labelPaint);
        if (color != null) {
            this.userStyleData.setLabelColor(color.getRGBColorComponents(null));
            this.fontColorButton.setIcon((Icon)new SquareIcon(14, 14, color));
            this.preview.setEditorFontColor(color);
        }
    }

    private void iconColorbuttonActionPerformed(ActionEvent e) {
        float[] iconColor = this.userStyleData.getColor();
        Color iconPaint = new Color(iconColor[0], iconColor[1], iconColor[2]);
        Color color = JColorChooser.showDialog(this, "Choose an Icon Color", iconPaint);
        if (color != null) {
            float[] col = color.getRGBColorComponents(null);
            this.userStyleData.setColor(col);
            this.userStyleData.setRedMethod(null);
            this.userStyleData.setGreenMethod(null);
            this.userStyleData.setBlueMethod(null);
            this.variableIconRedColorValueModel.addElement(Float.valueOf(col[0]));
            this.variableIconGreenColorValueModel.addElement(Float.valueOf(col[1]));
            this.variableIconBlueColorValueModel.addElement(Float.valueOf(col[2]));
            this.variableIconRedColorValueModel.setSelectedItem(Float.valueOf(col[0]));
            this.variableIconGreenColorValueModel.setSelectedItem(Float.valueOf(col[1]));
            this.variableIconBlueColorValueModel.setSelectedItem(Float.valueOf(col[2]));
            this.iconColorbutton.setIcon((Icon)new SquareIcon(14, 14, color));
            this.preview.setFillColor(color);
        }
    }

    private void redValueComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.redValueComboBox.getSelectedItem();
        if (!(selection instanceof Number) && !this.isUserTypedNumber(selection)) {
            this.userStyleData.setRedMethod((String)selection);
        }
    }

    private void greenValueComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.greenValueComboBox.getSelectedItem();
        if (!(selection instanceof Number) && !this.isUserTypedNumber(selection)) {
            this.userStyleData.setGreenMethod((String)selection);
        }
    }

    private void blueValueComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.blueValueComboBox.getSelectedItem();
        if (!(selection instanceof Number) && !this.isUserTypedNumber(selection)) {
            this.userStyleData.setBlueMethod((String)selection);
        }
    }

    private void redMinComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMin();
        c[0] = ((Float)this.redMinComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMin(c);
    }

    private void greenMinComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMin();
        c[1] = ((Float)this.greenMinComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMin(c);
    }

    private void blueMinComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMin();
        c[2] = ((Float)this.blueMinComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMin(c);
    }

    private void redMaxComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMax();
        c[0] = ((Float)this.redMaxComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMax(c);
    }

    private void greenMaxComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMax();
        c[1] = ((Float)this.greenMaxComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMax(c);
    }

    private void blueMaxComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMax();
        c[2] = ((Float)this.blueMaxComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMax(c);
    }

    private void redScaleComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorScale();
        c[0] = ((Float)this.redScaleComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorScale(c);
    }

    private void greenScaleComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorScale();
        c[1] = ((Float)this.greenScaleComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorScale(c);
    }

    private void blueScaleComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorScale();
        c[2] = ((Float)this.blueScaleComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorScale(c);
    }

    private void iconButtonActionPerformed(ActionEvent e) {
        String projetRoot = ScenarioUtils.getScenarioDir().getParentFile().getAbsolutePath();
        File currentFile = this.userStyleData.getIconFile2D() != null ? new File(this.userStyleData.getIconFile2D()) : new File(projetRoot);
        if (!currentFile.exists()) {
            currentFile = currentFile.getParentFile();
        }
        this.shapeComboBox.setEnabled(false);
        this.iconColorbutton.setEnabled(false);
        JFileChooser chooser = new JFileChooser(currentFile);
        if (this.displayType.equals("2D")) {
            chooser.setFileFilter(new IconFile2DFilter());
            chooser.showOpenDialog(this);
            File chosenFile = chooser.getSelectedFile();
            if (chosenFile != null) {
                this.iconButton.setFont(this.iconButton.getFont().deriveFont(1));
                this.userStyleData.setIconFile2D(this.makeRelativePath(chosenFile.getAbsolutePath()));
                this.iconButton.setText("Icon Set");
                this.preview.setIconFile(chosenFile);
                this.disableColorButtons();
            }
        } else {
            chooser.setFileFilter(new ModelFile3DFilter());
            chooser.showOpenDialog(this);
            File chosenFile = chooser.getSelectedFile();
            if (chosenFile != null) {
                this.iconButton.setFont(this.iconButton.getFont().deriveFont(1));
                this.userStyleData.setModelFile3D(this.makeRelativePath(chosenFile.getAbsolutePath()));
                this.iconButton.setText("Model Set");
            }
        }
    }

    private String makeRelativePath(String fileName) {
        String projectRoot = ScenarioUtils.getScenarioDir().getParentFile().getAbsolutePath();
        String path = fileName.startsWith(projectRoot) ? StringUtils.substringAfter((String)fileName, (String)projectRoot) : fileName;
        if ((path = StringUtils.replace((String)path, (String)"\\", (String)"/")).charAt(0) == '/') {
            path = StringUtils.substringAfter((String)path, (String)String.valueOf(path.charAt(0)));
        }
        return path;
    }

    private void clearFileButtonActionPerformed(ActionEvent e) {
        this.iconButton.setFont(this.iconButton.getFont().deriveFont(0));
        if (this.displayType.equals("2D")) {
            this.userStyleData.setIconFile2D(null);
            this.iconButton.setText("Select Icon File");
            this.preview.setIconFile(null);
            this.enableColorButtons();
        } else {
            this.userStyleData.setModelFile3D(null);
            this.iconButton.setText("Select Model File");
        }
        this.shapeComboBox.setEnabled(true);
        this.iconColorbutton.setEnabled(true);
    }

    private void textureButtonActionPerformed(ActionEvent e) {
        File currentFile = this.userStyleData.getTextureFile3D() != null ? new File(this.userStyleData.getTextureFile3D()) : new File("/");
        if (!currentFile.exists()) {
            currentFile = currentFile.getParentFile();
        }
        JFileChooser chooser = new JFileChooser(currentFile);
        chooser.setFileFilter(new IconFile2DFilter());
        chooser.showOpenDialog(this);
        File chosenFile = chooser.getSelectedFile();
        if (chosenFile != null) {
            this.userStyleData.setTextureFile3D(chosenFile.getAbsolutePath());
            this.textureButton.setFont(this.textureButton.getFont().deriveFont(1));
            this.textureButton.setText("Texture Set");
            this.disableColorButtons();
        }
    }

    private void clearTextureButtonActionPerformed(ActionEvent e) {
        this.userStyleData.setTextureFile3D(null);
        this.textureButton.setFont(this.textureButton.getFont().deriveFont(0));
        this.textureButton.setText("Select Texture");
        this.enableColorButtons();
    }

    private void disableColorButtons() {
        this.redMaxComboBox.setEnabled(false);
        this.redMinComboBox.setEnabled(false);
        this.redScaleComboBox.setEnabled(false);
        this.redValueComboBox.setEnabled(false);
        this.greenMaxComboBox.setEnabled(false);
        this.greenMinComboBox.setEnabled(false);
        this.greenScaleComboBox.setEnabled(false);
        this.greenValueComboBox.setEnabled(false);
        this.blueMaxComboBox.setEnabled(false);
        this.blueMinComboBox.setEnabled(false);
        this.blueScaleComboBox.setEnabled(false);
        this.blueValueComboBox.setEnabled(false);
    }

    private void enableColorButtons() {
        this.redMaxComboBox.setEnabled(true);
        this.redMinComboBox.setEnabled(true);
        this.redScaleComboBox.setEnabled(true);
        this.redValueComboBox.setEnabled(true);
        this.greenMaxComboBox.setEnabled(true);
        this.greenMinComboBox.setEnabled(true);
        this.greenScaleComboBox.setEnabled(true);
        this.greenValueComboBox.setEnabled(true);
        this.blueMaxComboBox.setEnabled(true);
        this.blueMinComboBox.setEnabled(true);
        this.blueScaleComboBox.setEnabled(true);
        this.blueValueComboBox.setEnabled(true);
    }

    private void labelPrecisionComboBoxActionPerformed(ActionEvent e) {
        String precision = (String)this.labelPrecisionComboBox.getSelectedItem();
        this.userStyleData.setLabelPrecision(new Integer(precision));
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.panel1 = new JPanel();
        this.shapePanel = new JPanel();
        this.shapeComboBox = new JComboBox();
        this.iconColorbutton = new JButton();
        this.iconButton = new JButton();
        this.clearFileButton = new JButton();
        this.textureButton = new JButton();
        this.clearTextureButton = new JButton();
        this.previewPanel = new JPanel();
        this.panel3 = new JPanel();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.label4 = new JLabel();
        this.sizeComboBox = new JComboBox();
        this.sizeMinComboBox = new JComboBox();
        this.sizeMaxComboBox = new JComboBox();
        this.sizeScaleComboBox = new JComboBox();
        this.panel4 = new JPanel();
        this.label5 = new JLabel();
        this.label6 = new JLabel();
        this.label7 = new JLabel();
        this.label19 = new JLabel();
        this.labelComboBox = new JComboBox();
        this.labelPositionComboBox = new JComboBox();
        this.labelOffsetTextField = new JTextField();
        this.labelPrecisionComboBox = new JComboBox();
        this.panel2 = new JPanel();
        this.label8 = new JLabel();
        this.label9 = new JLabel();
        this.label10 = new JLabel();
        this.label11 = new JLabel();
        this.labelFontFamilyComboBox = new JComboBox();
        this.labelFontSizeComboBox = new JComboBox();
        this.labelFontStyleComboBox = new JComboBox();
        this.fontColorButton = new JButton();
        this.panel6 = new JPanel();
        this.label15 = new JLabel();
        this.label16 = new JLabel();
        this.label17 = new JLabel();
        this.label18 = new JLabel();
        this.label12 = new JLabel();
        this.redValueComboBox = new JComboBox();
        this.redMinComboBox = new JComboBox();
        this.redMaxComboBox = new JComboBox();
        this.redScaleComboBox = new JComboBox();
        this.label13 = new JLabel();
        this.greenValueComboBox = new JComboBox();
        this.greenMinComboBox = new JComboBox();
        this.greenMaxComboBox = new JComboBox();
        this.greenScaleComboBox = new JComboBox();
        this.label14 = new JLabel();
        this.blueValueComboBox = new JComboBox();
        this.blueMinComboBox = new JComboBox();
        this.blueMaxComboBox = new JComboBox();
        this.blueScaleComboBox = new JComboBox();
        CellConstraints cc = new CellConstraints();
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG);
        this.dialogPane.setLayout(new BorderLayout());
        this.buttonBar.setBorder(Borders.BUTTON_BAR_PAD);
        this.buttonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.GLUE_COLSPEC, FormSpecs.BUTTON_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, cc.xy(2, 1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, cc.xy(4, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"left:max(default;166dlu):grow"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)133)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.shapePanel.setBorder(new TitledBorder("Icon Shape and Color"));
        this.shapePanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec((Size)Sizes.dluX((int)79)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, new RowSpec((Size)Sizes.dluY((int)17))}));
        this.shapeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.shapeComboBoxActionPerformed(e);
            }
        });
        this.shapePanel.add((Component)this.shapeComboBox, cc.xy(1, 1));
        this.iconColorbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.iconColorbuttonActionPerformed(e);
            }
        });
        this.shapePanel.add((Component)this.iconColorbutton, cc.xy(3, 1));
        this.iconButton.setText("text");
        this.iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.iconButtonActionPerformed(e);
            }
        });
        this.shapePanel.add((Component)this.iconButton, cc.xy(1, 5));
        this.clearFileButton.setText("text");
        this.clearFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.clearFileButtonActionPerformed(e);
            }
        });
        this.shapePanel.add((Component)this.clearFileButton, cc.xy(3, 5));
        this.textureButton.setText("Select Texture");
        this.textureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.textureButtonActionPerformed(e);
            }
        });
        this.shapePanel.add((Component)this.textureButton, cc.xy(1, 7));
        this.clearTextureButton.setText("Clear Texture");
        this.clearTextureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.clearTextureButtonActionPerformed(e);
            }
        });
        this.shapePanel.add((Component)this.clearTextureButton, cc.xy(3, 7));
        this.panel1.add((Component)this.shapePanel, cc.xywh(1, 1, 2, 1));
        this.previewPanel.setBorder(new TitledBorder("Icon Preview"));
        this.previewPanel.setLayout((LayoutManager)new FormLayout("101dlu:grow", "top:57dlu:grow"));
        this.panel1.add((Component)this.previewPanel, cc.xywh(5, 1, 3, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.panel3.setBorder(new TitledBorder("Icon Size"));
        this.panel3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"max(pref;66dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.label1.setText("Value");
        this.panel3.add((Component)this.label1, cc.xy(1, 1));
        this.label2.setText("Minimum");
        this.panel3.add((Component)this.label2, cc.xy(5, 1));
        this.label3.setText("Maximum");
        this.panel3.add((Component)this.label3, cc.xy(9, 1));
        this.label4.setText("Scaling");
        this.panel3.add((Component)this.label4, cc.xy(13, 1));
        this.sizeComboBox.setEditable(true);
        this.sizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.sizeComboBoxActionPerformed(e);
            }
        });
        this.panel3.add((Component)this.sizeComboBox, cc.xy(1, 3));
        this.sizeMinComboBox.setEditable(true);
        this.sizeMinComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.sizeMinComboBoxActionPerformed(e);
            }
        });
        this.panel3.add((Component)this.sizeMinComboBox, cc.xy(5, 3));
        this.sizeMaxComboBox.setEditable(true);
        this.sizeMaxComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.sizeMaxComboBoxActionPerformed(e);
            }
        });
        this.panel3.add((Component)this.sizeMaxComboBox, cc.xy(9, 3));
        this.sizeScaleComboBox.setEditable(true);
        this.sizeScaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.sizeScaleComboBoxActionPerformed(e);
            }
        });
        this.panel3.add((Component)this.sizeScaleComboBox, cc.xy(13, 3));
        this.panel1.add((Component)this.panel3, cc.xywh(1, 3, 7, 1));
        this.panel4.setBorder(new TitledBorder("Icon Label"));
        this.panel4.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"max(pref;67dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)33)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.label5.setText("Value");
        this.panel4.add((Component)this.label5, cc.xy(1, 1));
        this.label6.setText("Position");
        this.panel4.add((Component)this.label6, cc.xy(5, 1));
        this.label7.setText("Offset");
        this.panel4.add((Component)this.label7, cc.xy(9, 1));
        this.label19.setText("Precision");
        this.panel4.add((Component)this.label19, cc.xy(13, 1));
        this.labelComboBox.setEditable(true);
        this.labelComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.labelComboBoxActionPerformed(e);
            }
        });
        this.panel4.add((Component)this.labelComboBox, cc.xy(1, 3));
        this.labelPositionComboBox.setEditable(true);
        this.labelPositionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"bottom", "top", "left", "right"}));
        this.labelPositionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.labelPositionComboBoxActionPerformed(e);
            }
        });
        this.panel4.add((Component)this.labelPositionComboBox, cc.xy(5, 3));
        this.labelOffsetTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.labelOffsetTextFieldActionPerformed(e);
            }
        });
        this.panel4.add((Component)this.labelOffsetTextField, cc.xy(9, 3));
        this.labelPrecisionComboBox.setEditable(true);
        this.labelPrecisionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}));
        this.labelPrecisionComboBox.setSelectedIndex(2);
        this.labelPrecisionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.labelPrecisionComboBoxActionPerformed(e);
            }
        });
        this.panel4.add((Component)this.labelPrecisionComboBox, cc.xy(13, 3));
        this.panel1.add((Component)this.panel4, cc.xywh(1, 5, 7, 1));
        this.panel2.setBorder(new TitledBorder("Icon Label Font"));
        this.panel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.label8.setText("Font");
        this.panel2.add((Component)this.label8, cc.xy(1, 1));
        this.label9.setText("Font Size");
        this.panel2.add((Component)this.label9, cc.xy(5, 1));
        this.label10.setText("Font Style");
        this.panel2.add((Component)this.label10, cc.xy(9, 1));
        this.label11.setText("Font Color");
        this.panel2.add((Component)this.label11, cc.xy(13, 1));
        this.labelFontFamilyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.labelFontFamilyComboBoxActionPerformed(e);
            }
        });
        this.panel2.add((Component)this.labelFontFamilyComboBox, cc.xy(1, 3));
        this.labelFontSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"8", "10", "11", "12", "14", "16", "18", "20", "24", "30", "36", "40", "48", "60", "72 "}));
        this.labelFontSizeComboBox.setEditable(true);
        this.labelFontSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.labelFontSizeComboBoxActionPerformed(e);
            }
        });
        this.panel2.add((Component)this.labelFontSizeComboBox, cc.xy(5, 3));
        this.labelFontStyleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Plain", "Bold", "Italic"}));
        this.labelFontStyleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.labelFontStyleComboBoxActionPerformed(e);
            }
        });
        this.panel2.add((Component)this.labelFontStyleComboBox, cc.xy(9, 3));
        this.fontColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.fontColorButtonActionPerformed(e);
            }
        });
        this.panel2.add((Component)this.fontColorButton, cc.xy(13, 3));
        this.panel1.add((Component)this.panel2, cc.xywh(1, 7, 7, 1));
        this.panel6.setBorder(new TitledBorder("Variable Icon Color"));
        this.panel6.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.label15.setText("Value");
        this.panel6.add((Component)this.label15, cc.xy(3, 1));
        this.label16.setText("Minimum");
        this.panel6.add((Component)this.label16, cc.xy(7, 1));
        this.label17.setText("Maximum");
        this.panel6.add((Component)this.label17, cc.xy(11, 1));
        this.label18.setText("Scaling");
        this.panel6.add((Component)this.label18, cc.xy(15, 1));
        this.label12.setText("Red");
        this.panel6.add((Component)this.label12, cc.xy(1, 3));
        this.redValueComboBox.setEditable(true);
        this.redValueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.redValueComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.redValueComboBox, cc.xy(3, 3));
        this.redMinComboBox.setEditable(true);
        this.redMinComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.redMinComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.redMinComboBox, cc.xy(7, 3));
        this.redMaxComboBox.setEditable(true);
        this.redMaxComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.redMaxComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.redMaxComboBox, cc.xy(11, 3));
        this.redScaleComboBox.setEditable(true);
        this.redScaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.redScaleComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.redScaleComboBox, cc.xy(15, 3));
        this.label13.setText("Green");
        this.panel6.add((Component)this.label13, cc.xy(1, 5));
        this.greenValueComboBox.setEditable(true);
        this.greenValueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.greenValueComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.greenValueComboBox, cc.xy(3, 5));
        this.greenMinComboBox.setEditable(true);
        this.greenMinComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.greenMinComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.greenMinComboBox, cc.xy(7, 5));
        this.greenMaxComboBox.setEditable(true);
        this.greenMaxComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.greenMaxComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.greenMaxComboBox, cc.xy(11, 5));
        this.greenScaleComboBox.setEditable(true);
        this.greenScaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.greenScaleComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.greenScaleComboBox, cc.xy(15, 5));
        this.label14.setText("Blue");
        this.panel6.add((Component)this.label14, cc.xy(1, 7));
        this.blueValueComboBox.setEditable(true);
        this.blueValueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.blueValueComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.blueValueComboBox, cc.xy(3, 7));
        this.blueMinComboBox.setEditable(true);
        this.blueMinComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.blueMinComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.blueMinComboBox, cc.xy(7, 7));
        this.blueMaxComboBox.setEditable(true);
        this.blueMaxComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.blueMaxComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.blueMaxComboBox, cc.xy(11, 7));
        this.blueScaleComboBox.setEditable(true);
        this.blueScaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedStyleDialog.this.blueScaleComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.blueScaleComboBox, cc.xy(15, 7));
        this.panel1.add((Component)this.panel6, cc.xywh(1, 9, 7, 1));
        this.dialogPane.add((Component)this.panel1, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(520, 595);
        this.setLocationRelativeTo(this.getOwner());
    }

    public String getUserStyleName() {
        return this.userStyleName;
    }

    private boolean isUserTypedNumber(Object obj) {
        String validChars = "0123456789";
        boolean isNumber = true;
        if (obj instanceof String) {
            String s = (String)obj;
            char c = s.charAt(0);
            return validChars.indexOf(c) != -1;
        }
        return false;
    }
}

