/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui.styleBuilder;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XStream11XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jscience.physics.amount.Amount;
import repast.simphony.scenario.data.Attribute;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.ui.plugin.editor.SquareIcon;
import repast.simphony.visualization.editedStyle.DefaultEditedEdgeStyleData2D;
import repast.simphony.visualization.editedStyle.DefaultEditedEdgeStyleData3D;
import repast.simphony.visualization.editedStyle.EditedEdgeStyleData;
import repast.simphony.visualization.editedStyle.EditedStyleUtils;
import repast.simphony.visualization.editedStyle.LineStyle;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.gui.styleBuilder.PreviewEdge;
import repast.simphony.visualization.gui.styleBuilder.PreviewEdge2D;
import repast.simphony.visualization.gui.styleBuilder.PreviewEdge3D;
import simphony.util.messages.MessageCenter;

public class EditedEdgeStyleDialog
extends JDialog {
    private boolean save = false;
    private EditedEdgeStyleData userStyleData;
    private static final Set<Class> pTypes = new HashSet<Class>();
    private List<String> methodList = new ArrayList<String>();
    private DefaultComboBoxModel sizeModel;
    private DefaultComboBoxModel sizeMinModel;
    private DefaultComboBoxModel sizeMaxModel;
    private DefaultComboBoxModel sizeScaleModel;
    private DefaultComboBoxModel shapeModel;
    private DefaultComboBoxModel variableIconRedColorValueModel;
    private DefaultComboBoxModel variableIconGreenColorValueModel;
    private DefaultComboBoxModel variableIconBlueColorValueModel;
    private DefaultComboBoxModel variableIconRedColorMinModel;
    private DefaultComboBoxModel variableIconGreenColorMinModel;
    private DefaultComboBoxModel variableIconBlueColorMinModel;
    private DefaultComboBoxModel variableIconRedColorMaxModel;
    private DefaultComboBoxModel variableIconGreenColorMaxModel;
    private DefaultComboBoxModel variableIconBlueColorMaxModel;
    private DefaultComboBoxModel variableIconRedColorScaleModel;
    private DefaultComboBoxModel variableIconGreenColorScaleModel;
    private DefaultComboBoxModel variableIconBlueColorScaleModel;
    private String netID;
    private String userStyleName;
    CartesianDisplayDescriptor descriptor;
    private PreviewEdge preview;
    private JPanel dialogPane;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel panel1;
    private JPanel shapePanel;
    private JComboBox shapeComboBox;
    private JButton iconColorbutton;
    private JPanel panel3;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JComboBox sizeComboBox;
    private JComboBox sizeMinComboBox;
    private JComboBox sizeMaxComboBox;
    private JComboBox sizeScaleComboBox;
    private JPanel panel6;
    private JLabel label15;
    private JLabel label16;
    private JLabel label17;
    private JLabel label18;
    private JLabel label12;
    private JComboBox redValueComboBox;
    private JComboBox redMinComboBox;
    private JComboBox redMaxComboBox;
    private JComboBox redScaleComboBox;
    private JLabel label13;
    private JComboBox greenValueComboBox;
    private JComboBox greenMinComboBox;
    private JComboBox greenMaxComboBox;
    private JComboBox greenScaleComboBox;
    private JLabel label14;
    private JComboBox blueValueComboBox;
    private JComboBox blueMinComboBox;
    private JComboBox blueMaxComboBox;
    private JComboBox blueScaleComboBox;
    private JPanel previewPanel;

    static {
        pTypes.add(Integer.TYPE);
        pTypes.add(Double.TYPE);
        pTypes.add(Float.TYPE);
        pTypes.add(Long.TYPE);
        pTypes.add(Byte.TYPE);
        pTypes.add(Short.TYPE);
        pTypes.add(Amount.class);
    }

    public EditedEdgeStyleDialog(Frame owner) {
        super(owner);
    }

    public EditedEdgeStyleDialog(Dialog owner) {
        super(owner);
    }

    public void init(ContextData context, String netID, String userStyleName, CartesianDisplayDescriptor descriptor) {
        this.netID = netID;
        this.userStyleName = userStyleName;
        for (ProjectionData proj : context.projections()) {
            if (!proj.getType().equals("network")) continue;
            for (Attribute attrib : proj.attributes()) {
                this.findAttributes(attrib);
            }
        }
        if (!this.methodList.contains("getWeight")) {
            this.methodList.add("getWeight");
        }
        String displayType = descriptor.getDisplayType();
        this.userStyleData = EditedStyleUtils.getEdgeStyle(descriptor.getNetworkEditedStyleName(netID));
        if (displayType.equals("2D")) {
            if (this.userStyleData == null) {
                this.userStyleData = new DefaultEditedEdgeStyleData2D();
            }
            this.shapeModel = new DefaultComboBoxModel<Object>(new Object[]{new LineStyleIcon(LineStyle.SOLID, 3.0f), new LineStyleIcon(LineStyle.DASH, 3.0f), new LineStyleIcon(LineStyle.DASH_DOT, 3.0f), new LineStyleIcon(LineStyle.DASH_DASH_DOT, 3.0f)});
        } else {
            if (this.userStyleData == null) {
                this.userStyleData = new DefaultEditedEdgeStyleData3D();
            }
            this.shapeModel = new DefaultComboBoxModel<Object>(new Object[]{new LineStyleIcon(LineStyle.SOLID, 3.0f)});
        }
        int i = 0;
        while (i < this.shapeModel.getSize()) {
            LineStyleIcon icon = (LineStyleIcon)this.shapeModel.getElementAt(i);
            if (icon.getLineStyle().equals((Object)this.userStyleData.getLineStyle())) {
                this.shapeModel.setSelectedItem(icon);
                break;
            }
            ++i;
        }
        this.sizeModel = new DefaultComboBoxModel();
        this.sizeMinModel = new DefaultComboBoxModel();
        this.sizeMaxModel = new DefaultComboBoxModel();
        this.sizeScaleModel = new DefaultComboBoxModel();
        this.variableIconRedColorValueModel = new DefaultComboBoxModel();
        this.variableIconGreenColorValueModel = new DefaultComboBoxModel();
        this.variableIconBlueColorValueModel = new DefaultComboBoxModel();
        this.variableIconRedColorMinModel = new DefaultComboBoxModel();
        this.variableIconGreenColorMinModel = new DefaultComboBoxModel();
        this.variableIconBlueColorMinModel = new DefaultComboBoxModel();
        this.variableIconRedColorMaxModel = new DefaultComboBoxModel();
        this.variableIconGreenColorMaxModel = new DefaultComboBoxModel();
        this.variableIconBlueColorMaxModel = new DefaultComboBoxModel();
        this.variableIconRedColorScaleModel = new DefaultComboBoxModel();
        this.variableIconGreenColorScaleModel = new DefaultComboBoxModel();
        this.variableIconBlueColorScaleModel = new DefaultComboBoxModel();
        this.sizeMinModel.addElement(Float.valueOf(this.userStyleData.getSizeMin()));
        this.sizeMaxModel.addElement(Float.valueOf(this.userStyleData.getSizeMax()));
        this.sizeScaleModel.addElement(Float.valueOf(this.userStyleData.getSizeScale()));
        for (String method : this.methodList) {
            this.sizeModel.addElement(method);
            this.sizeMinModel.addElement(method);
            this.sizeMaxModel.addElement(method);
            this.sizeScaleModel.addElement(method);
            this.variableIconRedColorValueModel.addElement(method);
            this.variableIconGreenColorValueModel.addElement(method);
            this.variableIconBlueColorValueModel.addElement(method);
        }
        if (this.userStyleData.getSizeMethodName() != null) {
            this.sizeModel.setSelectedItem(this.userStyleData.getSizeMethodName());
        } else {
            this.sizeModel.addElement(Float.valueOf(this.userStyleData.getSize()));
            this.sizeModel.setSelectedItem(Float.valueOf(this.userStyleData.getSize()));
        }
        if (this.userStyleData.getRedMethod() != null) {
            this.variableIconRedColorValueModel.setSelectedItem(this.userStyleData.getRedMethod());
        } else {
            this.variableIconRedColorValueModel.addElement(Float.valueOf(this.userStyleData.getColor()[0]));
            this.variableIconRedColorValueModel.setSelectedItem(Float.valueOf(this.userStyleData.getColor()[0]));
        }
        if (this.userStyleData.getGreenMethod() != null) {
            this.variableIconGreenColorValueModel.setSelectedItem(this.userStyleData.getGreenMethod());
        } else {
            this.variableIconGreenColorValueModel.addElement(Float.valueOf(this.userStyleData.getColor()[1]));
            this.variableIconGreenColorValueModel.setSelectedItem(Float.valueOf(this.userStyleData.getColor()[1]));
        }
        if (this.userStyleData.getBlueMethod() != null) {
            this.variableIconBlueColorValueModel.setSelectedItem(this.userStyleData.getBlueMethod());
        } else {
            this.variableIconBlueColorValueModel.addElement(Float.valueOf(this.userStyleData.getColor()[2]));
            this.variableIconBlueColorValueModel.setSelectedItem(Float.valueOf(this.userStyleData.getColor()[2]));
        }
        this.variableIconRedColorMinModel.addElement(Float.valueOf(this.userStyleData.getColorMin()[0]));
        this.variableIconRedColorMinModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMin()[0]));
        this.variableIconGreenColorMinModel.addElement(Float.valueOf(this.userStyleData.getColorMin()[1]));
        this.variableIconGreenColorMinModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMin()[1]));
        this.variableIconBlueColorMinModel.addElement(Float.valueOf(this.userStyleData.getColorMin()[2]));
        this.variableIconBlueColorMinModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMin()[2]));
        this.variableIconRedColorMaxModel.addElement(Float.valueOf(this.userStyleData.getColorMax()[0]));
        this.variableIconRedColorMaxModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMax()[0]));
        this.variableIconGreenColorMaxModel.addElement(Float.valueOf(this.userStyleData.getColorMax()[1]));
        this.variableIconGreenColorMaxModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMax()[1]));
        this.variableIconBlueColorMaxModel.addElement(Float.valueOf(this.userStyleData.getColorMax()[2]));
        this.variableIconBlueColorMaxModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorMax()[2]));
        this.variableIconRedColorScaleModel.addElement(Float.valueOf(this.userStyleData.getColorScale()[0]));
        this.variableIconRedColorScaleModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorScale()[0]));
        this.variableIconGreenColorScaleModel.addElement(Float.valueOf(this.userStyleData.getColorScale()[1]));
        this.variableIconGreenColorScaleModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorScale()[1]));
        this.variableIconBlueColorScaleModel.addElement(Float.valueOf(this.userStyleData.getColorScale()[2]));
        this.variableIconBlueColorScaleModel.setSelectedItem(Float.valueOf(this.userStyleData.getColorScale()[2]));
        this.initComponents();
        this.initMyComponents(displayType);
    }

    public void findAttributes(Attribute a) {
        if (a.getId().equalsIgnoreCase("edgeClass")) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(a.getValue());
            }
            catch (ClassNotFoundException e) {
                MessageCenter.getMessageCenter(EditedEdgeStyleDialog.class).error((Object)"Problems findingclass to load", (Throwable)e, new Object[0]);
                e.printStackTrace();
            }
            if (clazz != null) {
                Method[] methods;
                Method[] methodArray = methods = clazz.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.getName().startsWith("get") && pTypes.contains(method.getReturnType())) {
                        this.methodList.add(method.getName());
                    }
                    ++n2;
                }
            }
        }
    }

    public void initMyComponents(String displayType) {
        CellConstraints cc = new CellConstraints();
        this.shapeComboBox.setModel(this.shapeModel);
        this.sizeComboBox.setModel(this.sizeModel);
        this.sizeMinComboBox.setModel(this.sizeMinModel);
        this.sizeMaxComboBox.setModel(this.sizeMaxModel);
        this.sizeScaleComboBox.setModel(this.sizeScaleModel);
        this.redValueComboBox.setModel(this.variableIconRedColorValueModel);
        this.greenValueComboBox.setModel(this.variableIconGreenColorValueModel);
        this.blueValueComboBox.setModel(this.variableIconBlueColorValueModel);
        this.redMinComboBox.setModel(this.variableIconRedColorMinModel);
        this.greenMinComboBox.setModel(this.variableIconGreenColorMinModel);
        this.blueMinComboBox.setModel(this.variableIconBlueColorMinModel);
        this.redMaxComboBox.setModel(this.variableIconRedColorMaxModel);
        this.greenMaxComboBox.setModel(this.variableIconGreenColorMaxModel);
        this.blueMaxComboBox.setModel(this.variableIconBlueColorMaxModel);
        this.redScaleComboBox.setModel(this.variableIconRedColorScaleModel);
        this.greenScaleComboBox.setModel(this.variableIconGreenColorScaleModel);
        this.blueScaleComboBox.setModel(this.variableIconBlueColorScaleModel);
        if (displayType.equals("2D")) {
            this.setTitle("2D Edge Style Editor");
            this.preview = new PreviewEdge2D();
            this.previewPanel.add((Component)((PreviewEdge2D)this.preview), cc.xy(1, 1));
        } else {
            this.setTitle("3D Edge Style Editor");
            this.preview = new PreviewEdge3D();
            this.shapeComboBox.setEnabled(false);
        }
        float[] iconColor = this.userStyleData.getColor();
        Color iconPaint = new Color(iconColor[0], iconColor[1], iconColor[2]);
        this.iconColorbutton.setIcon((Icon)new SquareIcon(15, 15, iconPaint));
    }

    private String removeSpaces(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", false);
        String t = "";
        while (st.hasMoreElements()) {
            t = String.valueOf(t) + st.nextElement();
        }
        return t;
    }

    public void writeStyleData() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver((XmlFriendlyReplacer)new XStream11XmlFriendlyReplacer())){

            protected boolean useXStream11XmlFriendlyMapper() {
                return true;
            }
        };
        File file = null;
        try {
            File dir = new File(EditedStyleUtils.getStyleDirName());
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (this.userStyleName != null) {
                file = new File(dir, this.userStyleName);
            } else {
                int cnt = 0;
                this.userStyleName = String.valueOf(this.removeSpaces(this.netID)) + ".style_" + cnt + ".xml";
                file = new File(dir, this.userStyleName);
                while (file.exists()) {
                    this.userStyleName = String.valueOf(this.removeSpaces(this.netID)) + ".style_" + cnt + ".xml";
                    file = new File(dir, this.userStyleName);
                    ++cnt;
                }
            }
            FileWriter fw = new FileWriter(file);
            xstream.toXML((Object)this.userStyleData, (Writer)fw);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean doSave() {
        return this.save;
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.save = true;
        this.writeStyleData();
        this.dispose();
    }

    private void shapeComboBoxActionPerformed(ActionEvent e) {
        this.userStyleData.setLineStyle(((LineStyleIcon)this.shapeComboBox.getSelectedItem()).getLineStyle());
    }

    private void sizeComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.sizeComboBox.getSelectedItem();
        if (selection instanceof Number) {
            this.userStyleData.setSize(((Float)selection).floatValue());
            this.userStyleData.setSizeMethodName(null);
        } else if (this.isUserTypedNumber(selection)) {
            this.userStyleData.setSize(new Float((String)selection).floatValue());
            this.userStyleData.setSizeMethodName(null);
        } else {
            this.userStyleData.setSizeMethodName((String)selection);
        }
    }

    private void sizeMinComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.sizeMinComboBox.getSelectedItem();
        if (selection instanceof Number) {
            this.userStyleData.setSizeMin(((Float)selection).floatValue());
            this.userStyleData.setSizeMinMethodName(null);
        } else if (this.isUserTypedNumber(selection)) {
            this.userStyleData.setSizeMin(new Float((String)selection).floatValue());
            this.userStyleData.setSizeMinMethodName(null);
        } else {
            this.userStyleData.setSizeMinMethodName((String)selection);
        }
    }

    private void sizeMaxComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.sizeMaxComboBox.getSelectedItem();
        if (selection instanceof Number) {
            this.userStyleData.setSizeMax(((Float)selection).floatValue());
            this.userStyleData.setSizeMaxMethodName(null);
        } else if (this.isUserTypedNumber(selection)) {
            this.userStyleData.setSizeMax(new Float((String)selection).floatValue());
            this.userStyleData.setSizeMaxMethodName(null);
        } else {
            this.userStyleData.setSizeMaxMethodName((String)selection);
        }
    }

    private void sizeScaleComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.sizeScaleComboBox.getSelectedItem();
        if (selection instanceof Number) {
            this.userStyleData.setSizeScale(((Float)selection).floatValue());
            this.userStyleData.setSizeScaleMethodName(null);
        } else if (this.isUserTypedNumber(selection)) {
            this.userStyleData.setSizeScale(new Float((String)selection).floatValue());
            this.userStyleData.setSizeScaleMethodName(null);
        } else {
            this.userStyleData.setSizeScaleMethodName((String)selection);
        }
    }

    private void iconColorbuttonActionPerformed(ActionEvent e) {
        float[] iconColor = this.userStyleData.getColor();
        Color iconPaint = new Color(iconColor[0], iconColor[1], iconColor[2]);
        Color color = JColorChooser.showDialog(this, "Choose an Icon Color", iconPaint);
        if (color != null) {
            float[] col = color.getRGBColorComponents(null);
            this.userStyleData.setColor(col);
            this.userStyleData.setRedMethod(null);
            this.userStyleData.setGreenMethod(null);
            this.userStyleData.setBlueMethod(null);
            this.variableIconRedColorValueModel.addElement(Float.valueOf(col[0]));
            this.variableIconGreenColorValueModel.addElement(Float.valueOf(col[1]));
            this.variableIconBlueColorValueModel.addElement(Float.valueOf(col[2]));
            this.variableIconRedColorValueModel.setSelectedItem(Float.valueOf(col[0]));
            this.variableIconGreenColorValueModel.setSelectedItem(Float.valueOf(col[1]));
            this.variableIconBlueColorValueModel.setSelectedItem(Float.valueOf(col[2]));
            this.iconColorbutton.setIcon((Icon)new SquareIcon(20, 20, color));
            this.preview.setColor(color);
        }
    }

    private void redValueComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.redValueComboBox.getSelectedItem();
        if (!(selection instanceof Number) && !this.isUserTypedNumber(selection)) {
            this.userStyleData.setRedMethod((String)selection);
        }
    }

    private void greenValueComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.greenValueComboBox.getSelectedItem();
        if (!(selection instanceof Number) && !this.isUserTypedNumber(selection)) {
            this.userStyleData.setGreenMethod((String)selection);
        }
    }

    private void blueValueComboBoxActionPerformed(ActionEvent e) {
        Object selection = this.blueValueComboBox.getSelectedItem();
        if (!(selection instanceof Number) && !this.isUserTypedNumber(selection)) {
            this.userStyleData.setBlueMethod((String)selection);
        }
    }

    private void redMinComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMin();
        c[0] = ((Float)this.redMinComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMin(c);
    }

    private void greenMinComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMin();
        c[1] = ((Float)this.greenMinComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMin(c);
    }

    private void blueMinComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMin();
        c[2] = ((Float)this.blueMinComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMin(c);
    }

    private void redMaxComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMax();
        c[0] = ((Float)this.redMaxComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMax(c);
    }

    private void greenMaxComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMax();
        c[1] = ((Float)this.greenMaxComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMax(c);
    }

    private void blueMaxComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorMax();
        c[2] = ((Float)this.blueMaxComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorMax(c);
    }

    private void redScaleComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorScale();
        c[0] = ((Float)this.redScaleComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorScale(c);
    }

    private void greenScaleComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorScale();
        c[1] = ((Float)this.greenScaleComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorScale(c);
    }

    private void blueScaleComboBoxActionPerformed(ActionEvent e) {
        float[] c = this.userStyleData.getColorScale();
        c[2] = ((Float)this.blueScaleComboBox.getSelectedItem()).floatValue();
        this.userStyleData.setColorScale(c);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.panel1 = new JPanel();
        this.shapePanel = new JPanel();
        this.shapeComboBox = new JComboBox();
        this.iconColorbutton = new JButton();
        this.panel3 = new JPanel();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.label4 = new JLabel();
        this.sizeComboBox = new JComboBox();
        this.sizeMinComboBox = new JComboBox();
        this.sizeMaxComboBox = new JComboBox();
        this.sizeScaleComboBox = new JComboBox();
        this.panel6 = new JPanel();
        this.label15 = new JLabel();
        this.label16 = new JLabel();
        this.label17 = new JLabel();
        this.label18 = new JLabel();
        this.label12 = new JLabel();
        this.redValueComboBox = new JComboBox();
        this.redMinComboBox = new JComboBox();
        this.redMaxComboBox = new JComboBox();
        this.redScaleComboBox = new JComboBox();
        this.label13 = new JLabel();
        this.greenValueComboBox = new JComboBox();
        this.greenMinComboBox = new JComboBox();
        this.greenMaxComboBox = new JComboBox();
        this.greenScaleComboBox = new JComboBox();
        this.label14 = new JLabel();
        this.blueValueComboBox = new JComboBox();
        this.blueMinComboBox = new JComboBox();
        this.blueMaxComboBox = new JComboBox();
        this.blueScaleComboBox = new JComboBox();
        this.previewPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG);
        this.dialogPane.setLayout(new BorderLayout());
        this.buttonBar.setBorder(Borders.BUTTON_BAR_PAD);
        this.buttonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.GLUE_COLSPEC, FormSpecs.BUTTON_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, cc.xy(2, 1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, cc.xy(4, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.GROWING_BUTTON_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.shapePanel.setBorder(new TitledBorder("Edge Style and Color"));
        this.shapePanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec((Size)Sizes.dluX((int)66)), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.GROWING_BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"default")));
        this.shapeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.shapeComboBoxActionPerformed(e);
            }
        });
        this.shapePanel.add((Component)this.shapeComboBox, cc.xy(1, 1));
        this.iconColorbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.iconColorbuttonActionPerformed(e);
            }
        });
        this.shapePanel.add((Component)this.iconColorbutton, cc.xy(5, 1));
        this.panel1.add((Component)this.shapePanel, cc.xywh(1, 1, 11, 1));
        this.panel3.setBorder(new TitledBorder("Edge Thickness"));
        this.panel3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"max(pref;66dlu)"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.label1.setText("Value");
        this.panel3.add((Component)this.label1, cc.xy(1, 1));
        this.label2.setText("Minimum");
        this.panel3.add((Component)this.label2, cc.xy(5, 1));
        this.label3.setText("Maximum");
        this.panel3.add((Component)this.label3, cc.xy(9, 1));
        this.label4.setText("Scaling");
        this.panel3.add((Component)this.label4, cc.xy(13, 1));
        this.sizeComboBox.setEditable(true);
        this.sizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.sizeComboBoxActionPerformed(e);
            }
        });
        this.panel3.add((Component)this.sizeComboBox, cc.xy(1, 3));
        this.sizeMinComboBox.setEditable(true);
        this.sizeMinComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.sizeMinComboBoxActionPerformed(e);
            }
        });
        this.panel3.add((Component)this.sizeMinComboBox, cc.xy(5, 3));
        this.sizeMaxComboBox.setEditable(true);
        this.sizeMaxComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.sizeMaxComboBoxActionPerformed(e);
            }
        });
        this.panel3.add((Component)this.sizeMaxComboBox, cc.xy(9, 3));
        this.sizeScaleComboBox.setEditable(true);
        this.sizeScaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.sizeScaleComboBoxActionPerformed(e);
            }
        });
        this.panel3.add((Component)this.sizeScaleComboBox, cc.xy(13, 3));
        this.panel1.add((Component)this.panel3, cc.xywh(1, 3, 11, 1));
        this.panel6.setBorder(new TitledBorder("Variable Icon Color"));
        this.panel6.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LINE_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.label15.setText("Value");
        this.panel6.add((Component)this.label15, cc.xy(3, 1));
        this.label16.setText("Minimum");
        this.panel6.add((Component)this.label16, cc.xy(7, 1));
        this.label17.setText("Maximum");
        this.panel6.add((Component)this.label17, cc.xy(11, 1));
        this.label18.setText("Scaling");
        this.panel6.add((Component)this.label18, cc.xy(15, 1));
        this.label12.setText("Red");
        this.panel6.add((Component)this.label12, cc.xy(1, 3));
        this.redValueComboBox.setEditable(true);
        this.redValueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.redValueComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.redValueComboBox, cc.xy(3, 3));
        this.redMinComboBox.setEditable(true);
        this.redMinComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.redMinComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.redMinComboBox, cc.xy(7, 3));
        this.redMaxComboBox.setEditable(true);
        this.redMaxComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.redMaxComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.redMaxComboBox, cc.xy(11, 3));
        this.redScaleComboBox.setEditable(true);
        this.redScaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.redScaleComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.redScaleComboBox, cc.xy(15, 3));
        this.label13.setText("Green");
        this.panel6.add((Component)this.label13, cc.xy(1, 5));
        this.greenValueComboBox.setEditable(true);
        this.greenValueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.greenValueComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.greenValueComboBox, cc.xy(3, 5));
        this.greenMinComboBox.setEditable(true);
        this.greenMinComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.greenMinComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.greenMinComboBox, cc.xy(7, 5));
        this.greenMaxComboBox.setEditable(true);
        this.greenMaxComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.greenMaxComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.greenMaxComboBox, cc.xy(11, 5));
        this.greenScaleComboBox.setEditable(true);
        this.greenScaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.greenScaleComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.greenScaleComboBox, cc.xy(15, 5));
        this.label14.setText("Blue");
        this.panel6.add((Component)this.label14, cc.xy(1, 7));
        this.blueValueComboBox.setEditable(true);
        this.blueValueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.blueValueComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.blueValueComboBox, cc.xy(3, 7));
        this.blueMinComboBox.setEditable(true);
        this.blueMinComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.blueMinComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.blueMinComboBox, cc.xy(7, 7));
        this.blueMaxComboBox.setEditable(true);
        this.blueMaxComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.blueMaxComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.blueMaxComboBox, cc.xy(11, 7));
        this.blueScaleComboBox.setEditable(true);
        this.blueScaleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditedEdgeStyleDialog.this.blueScaleComboBoxActionPerformed(e);
            }
        });
        this.panel6.add((Component)this.blueScaleComboBox, cc.xy(15, 7));
        this.panel1.add((Component)this.panel6, cc.xy(1, 5));
        this.previewPanel.setBorder(new TitledBorder("Icon Preview"));
        this.previewPanel.setLayout((LayoutManager)new FormLayout("default:grow", "default:grow"));
        this.panel1.add((Component)this.previewPanel, cc.xywh(1, 15, 11, 1));
        this.dialogPane.add((Component)this.panel1, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(615, 530);
        this.setLocationRelativeTo(this.getOwner());
    }

    public String getUserStyleName() {
        return this.userStyleName;
    }

    private boolean isUserTypedNumber(Object obj) {
        String validChars = "0123456789";
        boolean isNumber = true;
        if (obj instanceof String) {
            String s = (String)obj;
            char c = s.charAt(0);
            return validChars.indexOf(c) != -1;
        }
        return false;
    }

    class LineStyleIcon
    implements Icon {
        protected float[] dash;
        protected float width;
        LineStyle lineStyle;

        public LineStyleIcon(LineStyle lineStyle, float width) {
            this.dash = lineStyle == LineStyle.DASH ? new float[]{10.0f, 10.0f} : (lineStyle == LineStyle.DASH_DOT ? new float[]{10.0f, 4.0f, 2.0f, 4.0f} : (float[])(lineStyle == LineStyle.DASH_DASH_DOT ? new float[]{10.0f, 4.0f, 10.0f, 4.0f, 2.0f, 4.0f} : null));
            this.width = width;
            this.lineStyle = lineStyle;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }

        @Override
        public int getIconWidth() {
            return 100;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.WHITE);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(Color.BLACK);
            ((Graphics2D)g).setStroke(new BasicStroke(this.width, 0, 0, 10.0f, this.dash, 0.0f));
            g.drawLine(0, this.getIconHeight() / 2, this.getIconWidth(), this.getIconHeight() / 2);
        }

        public LineStyle getLineStyle() {
            return this.lineStyle;
        }
    }
}

