/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.pietschy.wizard.InvalidStateException;
import org.pietschy.wizard.WizardModel;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.ui.plugin.editor.PluginWizardStep;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.cgd.CGDLayout;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.gui.DisplayWizardModel;
import repast.simphony.visualization.visualization2D.Random2DLayout;
import repast.simphony.visualization.visualization2D.layout.CircleLayout2D;
import repast.simphony.visualization.visualization2D.layout.FRLayout2D;
import repast.simphony.visualization.visualization2D.layout.ISOMLayout2D;
import repast.simphony.visualization.visualization2D.layout.KKLayout2D;
import repast.simphony.visualization.visualization3D.layout.FR3DLayout;
import repast.simphony.visualization.visualization3D.layout.GEM3DLayout;
import repast.simphony.visualization.visualization3D.layout.Random3DLayout;
import repast.simphony.visualization.visualization3D.layout.SphericalLayout;
import saf.core.ui.util.IntegerDocument;

public class NetLayoutStep
extends PluginWizardStep {
    private static final long serialVersionUID = -1853984603197206862L;
    private DisplayWizardModel model;
    private JComboBox frequencyBox;
    private JTextField intervalFld;
    private JComboBox layoutClassNameBox;
    private JComboBox layoutNetworkBox;
    private ComboBoxModel model2DLayout;
    private ComboBoxModel model3DLayout;

    public NetLayoutStep() {
        super("Layout Details", "Please select a network layout and the frequency at which the layout will be updated, and the network that determines the layout");
        this.setComplete(true);
    }

    protected JPanel getContentPanel() {
        this.frequencyBox = new JComboBox<Object>(new Object[]{IDisplay.LayoutFrequency.ON_NEW, IDisplay.LayoutFrequency.AT_UPDATE, IDisplay.LayoutFrequency.AT_INTERVAL});
        this.intervalFld = new JTextField();
        this.layoutClassNameBox = new JComboBox();
        this.layoutNetworkBox = new JComboBox();
        this.model2DLayout = new DefaultComboBoxModel<String>(new String[]{Random2DLayout.class.getName(), CircleLayout2D.class.getName(), FRLayout2D.class.getName(), KKLayout2D.class.getName(), ISOMLayout2D.class.getName(), CGDLayout.class.getName()});
        this.model3DLayout = new DefaultComboBoxModel<String>(new String[]{GEM3DLayout.class.getName(), FR3DLayout.class.getName(), SphericalLayout.class.getName(), Random3DLayout.class.getName()});
        this.intervalFld.setDocument((Document)new IntegerDocument());
        this.intervalFld.setText("1");
        FormLayout layout = new FormLayout("pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addLabel("Network:", cc.xy(1, 1));
        builder.add((Component)this.layoutNetworkBox, cc.xy(1, 3));
        builder.addLabel("Class Name:", cc.xy(1, 5));
        builder.add((Component)this.layoutClassNameBox, cc.xy(1, 7));
        builder.addLabel("Frequency:", cc.xy(1, 9));
        builder.add((Component)this.frequencyBox, cc.xy(1, 11));
        builder.addLabel("Interval:", cc.xy(1, 13));
        builder.add((Component)this.intervalFld, cc.xy(1, 15));
        this.frequencyBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NetLayoutStep.this.intervalFld.setEnabled(NetLayoutStep.this.frequencyBox.getSelectedItem() == IDisplay.LayoutFrequency.AT_INTERVAL);
            }
        });
        return builder.getPanel();
    }

    public void init(WizardModel wizardModel) {
        this.model = (DisplayWizardModel)wizardModel;
    }

    public void applyState() throws InvalidStateException {
        DisplayDescriptor descriptor = this.model.getDescriptor();
        String layout = this.layoutClassNameBox.getSelectedItem().toString();
        descriptor.setLayoutClassName(layout);
        descriptor.setLayoutFrequency((IDisplay.LayoutFrequency)this.frequencyBox.getSelectedItem());
        if (descriptor.getLayoutFrqeuency() == IDisplay.LayoutFrequency.AT_INTERVAL) {
            String val = this.intervalFld.getText().trim();
            descriptor.setLayoutInterval(Integer.parseInt(val));
        }
        descriptor.setLayoutProjection(this.layoutNetworkBox.getSelectedItem().toString());
    }

    public void prepare() {
        DisplayDescriptor descriptor = this.model.getDescriptor();
        if (descriptor.getDisplayType().equals("3D")) {
            this.layoutClassNameBox.setModel(this.model3DLayout);
        } else {
            this.layoutClassNameBox.setModel(this.model2DLayout);
        }
        this.frequencyBox.setSelectedItem(descriptor.getLayoutFrqeuency());
        this.intervalFld.setText(String.valueOf(descriptor.getLayoutInterval()));
        this.intervalFld.setEnabled(this.frequencyBox.getSelectedItem() == IDisplay.LayoutFrequency.AT_INTERVAL);
        this.layoutClassNameBox.setEditable(true);
        String layoutClassName = descriptor.getLayoutClassName();
        if (layoutClassName != null) {
            this.layoutClassNameBox.setSelectedItem(layoutClassName);
        } else {
            this.layoutClassNameBox.setSelectedIndex(0);
        }
        Vector<String> netIDs = new Vector<String>();
        for (ProjectionData proj : this.model.getDescriptor().getProjections()) {
            if (!proj.getType().equals("network")) continue;
            netIDs.add(proj.getId());
        }
        this.layoutNetworkBox.setModel(new DefaultComboBoxModel(netIDs));
        if (descriptor.getLayoutProjection() != null) {
            this.layoutNetworkBox.setSelectedItem(descriptor.getLayoutProjection());
        }
    }
}

