/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.pietschy.wizard.InvalidStateException;
import org.pietschy.wizard.WizardModel;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.ui.plugin.editor.PluginWizardStep;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.gui.DisplayWizardModel;

public class NameOnlyGeneralStep
extends PluginWizardStep {
    private DisplayWizardModel model;
    private JTextField nameFld;
    private JLabel typeLbl;
    private JList projections;

    public NameOnlyGeneralStep() {
        super("Display Details", "Enter the name of the display");
    }

    protected JPanel getContentPanel() {
        this.nameFld = new JTextField();
        this.typeLbl = new JLabel();
        this.projections = new JList(new DefaultListModel());
        FormLayout layout = new FormLayout("right:pref, 3dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, 60dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        this.typeLbl.setFont(this.typeLbl.getFont().deriveFont(1));
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("General", cc.xyw(1, 1, 3));
        builder.addLabel("Name:", cc.xy(1, 3));
        builder.add((Component)this.nameFld, cc.xy(3, 3));
        builder.addLabel("Type:", cc.xy(1, 5));
        builder.add((Component)this.typeLbl, cc.xy(3, 5));
        builder.addSeparator("Projections", cc.xyw(1, 7, 3));
        builder.add((Component)new JScrollPane(this.projections), cc.xyw(1, 9, 3));
        return builder.getPanel();
    }

    public void init(WizardModel wizardModel) {
        this.model = (DisplayWizardModel)wizardModel;
    }

    public void prepare() {
        super.prepare();
        DisplayDescriptor descriptor = this.model.getDescriptor();
        this.nameFld.setText(descriptor.getName());
        this.typeLbl.setText(descriptor.getDisplayType());
        DefaultListModel model = (DefaultListModel)this.projections.getModel();
        model.clear();
        for (ProjectionData data : descriptor.getProjections()) {
            model.addElement(data.getId());
        }
    }

    public void applyState() throws InvalidStateException {
        super.applyState();
        this.model.getDescriptor().setName(this.nameFld.getText().trim());
    }
}

