/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.pietschy.wizard.InvalidStateException;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.ui.plugin.editor.SquareIcon;
import repast.simphony.util.wizard.ModelAwarePanelStep;
import repast.simphony.visualization.IDisplay;
import repast.simphony.visualization.UnitSizeLayoutProperties;
import repast.simphony.visualization.VisualizationProperties;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.ProjectionDescriptor;
import repast.simphony.visualization.grid.GridDecorator;
import repast.simphony.visualization.gui.DisplayWizardModel;
import saf.core.ui.util.FloatDocument;

public class GridStyleStep
extends ModelAwarePanelStep<DisplayWizardModel> {
    private static final long serialVersionUID = 716163719399246726L;
    private JTextField sizeFld = new JTextField();
    private JLabel nameLbl = new JLabel();
    private JCheckBox gridBox = new JCheckBox();
    private JButton colorBtn = new JButton();
    private Color color = null;
    private boolean prepared;
    private boolean applied;

    public GridStyleStep() {
        super("Grid Style", "Please enter the grid style details");
        this.setLayout(new BorderLayout());
        this.sizeFld.setDocument((Document)new FloatDocument());
        FormLayout layout = new FormLayout("right:pref, 3dlu, 30dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Grid Parameters", cc.xyw(1, 1, 4));
        builder.addLabel("Grid Name:", cc.xy(1, 3));
        this.nameLbl.setFont(this.nameLbl.getFont().deriveFont(1));
        builder.add((Component)this.nameLbl, cc.xy(3, 3));
        builder.addLabel("Unit size:", cc.xy(1, 5));
        builder.add((Component)this.sizeFld, cc.xy(3, 5));
        builder.addLabel("Show Grid:", cc.xy(1, 7));
        builder.add((Component)this.gridBox, cc.xy(3, 7));
        final JLabel gridLabel = builder.addLabel("Grid Color:", cc.xy(1, 9));
        builder.add((Component)this.colorBtn, cc.xy(3, 9));
        this.add(builder.getPanel(), "Center");
        this.gridBox.setSelected(true);
        this.gridBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GridStyleStep.this.colorBtn.setEnabled(GridStyleStep.this.gridBox.isSelected());
                gridLabel.setEnabled(GridStyleStep.this.gridBox.isSelected());
            }
        });
        this.colorBtn.setIcon((Icon)new SquareIcon(10, 10, this.color));
        this.colorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Color c = JColorChooser.showDialog((Component)((Object)GridStyleStep.this), "Select Color", GridStyleStep.this.color);
                if (c != null) {
                    GridStyleStep.this.color = c;
                    GridStyleStep.this.colorBtn.setIcon((Icon)new SquareIcon(10, 10, GridStyleStep.this.color));
                }
            }
        });
        this.setComplete(true);
    }

    private void prepareLayoutProps() {
        DisplayDescriptor descriptor = ((DisplayWizardModel)this.model).getDescriptor();
        VisualizationProperties props = descriptor.getLayoutProperties();
        if (props != null) {
            if (props.getProperty(UnitSizeLayoutProperties.UNIT_SIZE_LAYOUT_PROPERTIES_ID) == null) {
                this.resetLayoutProperties(descriptor);
            } else {
                UnitSizeLayoutProperties hints = (UnitSizeLayoutProperties)props;
                this.sizeFld.setText(String.valueOf(hints.getUnitSize()));
            }
        } else {
            this.resetLayoutProperties(descriptor);
        }
    }

    private void prepareDecoratorProps() {
        if (this.color == null) {
            this.color = ((DisplayWizardModel)this.model).getDescriptor().getDisplayType().equals("2D") ? Color.BLACK : Color.WHITE;
        }
        DisplayDescriptor descriptor = ((DisplayWizardModel)this.model).getDescriptor();
        ProjectionDescriptor pd = ((DisplayWizardModel)this.model).getTypeDescriptor("grid");
        Boolean show = (Boolean)pd.getProperty(GridDecorator.GRID_DECORATOR, "SHOW");
        if (show == null) {
            this.gridBox.setSelected(true);
            pd.setProperty(GridDecorator.GRID_DECORATOR, "COLOR", this.color.getRGB());
            pd.setProperty(GridDecorator.GRID_DECORATOR, "SHOW", true);
            VisualizationProperties lProps = descriptor.getLayoutProperties();
            Float cellSize = (Float)lProps.getProperty("cellSize");
            pd.setProperty(GridDecorator.GRID_DECORATOR, "UNIT_SIZE", cellSize);
        } else {
            this.gridBox.setSelected(show);
            Integer colorAsInt = (Integer)pd.getProperty(GridDecorator.GRID_DECORATOR, "COLOR");
            this.color = new Color(colorAsInt);
            this.colorBtn.setIcon((Icon)new SquareIcon(10, 10, this.color));
        }
    }

    public void prepare() {
        super.prepare();
        String name = ((DisplayWizardModel)this.model).getTypeDescriptor("grid").getProjectionName();
        if (name != null) {
            this.nameLbl.setText(name);
        }
        if (!this.prepared || this.prepared && this.applied) {
            this.prepareLayoutProps();
            this.prepareDecoratorProps();
        }
        this.prepared = true;
    }

    private void resetLayoutProperties(DisplayDescriptor descriptor) {
        descriptor.setLayoutProperties(new UnitSizeLayoutProperties());
        if (descriptor.getDisplayType().equals("3D")) {
            this.sizeFld.setText(".06");
        } else {
            this.sizeFld.setText("15");
            this.color = Color.BLACK;
            this.colorBtn.setIcon((Icon)new SquareIcon(10, 10, this.color));
        }
    }

    public void applyState() throws InvalidStateException {
        DisplayDescriptor descriptor = ((DisplayWizardModel)this.model).getDescriptor();
        UnitSizeLayoutProperties props = (UnitSizeLayoutProperties)descriptor.getLayoutProperties();
        float cellSize = Float.parseFloat(this.sizeFld.getText());
        props.setUnitSize(cellSize);
        ProjectionDescriptor pd = ((DisplayWizardModel)this.model).getTypeDescriptor("grid");
        pd.setProperty(GridDecorator.GRID_DECORATOR, "COLOR", this.color.getRGB());
        pd.setProperty(GridDecorator.GRID_DECORATOR, "SHOW", this.gridBox.isSelected());
        pd.setProperty(GridDecorator.GRID_DECORATOR, "UNIT_SIZE", Float.valueOf(cellSize));
        for (ProjectionData proj : descriptor.getProjections()) {
            if (!proj.getType().equals("grid")) continue;
            descriptor.setLayoutProjection(proj.getId());
            descriptor.setLayoutFrequency(IDisplay.LayoutFrequency.ON_MOVE);
            descriptor.setLayoutClassName("foo.bar.baz");
        }
        this.applied = true;
    }
}

