/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.pietschy.wizard.InvalidStateException;
import org.pietschy.wizard.WizardModel;
import repast.simphony.engine.environment.ProjectionRegistry;
import repast.simphony.engine.environment.ProjectionRegistryData;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.ui.plugin.editor.ListSelector;
import repast.simphony.ui.plugin.editor.PluginWizardStep;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.engine.CartesianProjectionDescritorFactory;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.DisplayValidator;
import repast.simphony.visualization.engine.ProjectionDescriptorFactory;
import repast.simphony.visualization.engine.ValueLayerDescriptor;
import repast.simphony.visualization.engine.VisualizationRegistry;
import repast.simphony.visualization.engine.VisualizationRegistryData;
import repast.simphony.visualization.gui.DisplayWizardModel;
import simphony.util.messages.MessageCenter;

public class GeneralStep
extends PluginWizardStep {
    private static final MessageCenter msg = MessageCenter.getMessageCenter(GeneralStep.class);
    public static final String DEFAULT_DISPLAY_TITLE = "New Display";
    private DisplayWizardModel model;
    private JTextField nameFld;
    private JComboBox<String> typeBox;
    private ListSelector<DisplayItem> selector;
    private Map<String, DisplayDescriptor> descriptorCache = new HashMap<String, DisplayDescriptor>();

    public GeneralStep() {
        super("Display Details", "Please enter the name and type of the display as well the projections the display should visualize");
    }

    protected JPanel getContentPanel() {
        this.nameFld = new JTextField();
        this.typeBox = new JComboBox();
        FormLayout layout = new FormLayout("right:pref, 3dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("General", cc.xyw(1, 1, 3));
        builder.addLabel("Name:", cc.xy(1, 3));
        builder.add((Component)this.nameFld, cc.xy(3, 3));
        builder.addLabel("Type:", cc.xy(1, 5));
        builder.add(this.typeBox, cc.xy(3, 5));
        ArrayList list = new ArrayList();
        this.selector = new ListSelector(list, list, false);
        builder.addSeparator("Projections and Value Layers", cc.xyw(1, 7, 3));
        builder.add((Component)this.selector.getPanel(), cc.xyw(1, 9, 3));
        this.selector.addActionListeners(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralStep.this.setComplete(GeneralStep.this.selector.getSelectedItems().size() > 0 && GeneralStep.this.nameFld.getText().length() > 0);
            }
        });
        return builder.getPanel();
    }

    private boolean doValidate() {
        boolean hasCart = false;
        boolean hasValue = false;
        boolean hasNet = false;
        boolean hasOther = false;
        int valCount = 0;
        ArrayList<String> selectedProjectionTypes = new ArrayList<String>();
        for (DisplayItem item : this.selector.getSelectedItems()) {
            selectedProjectionTypes.add(item.getProjectionData().getType());
            if (item.getProjectionData().getType().equals("value layer")) {
                hasValue = true;
                ++valCount;
                continue;
            }
            if (item.getProjectionData().getType().equals("network")) {
                hasNet = true;
                continue;
            }
            if (item.getProjectionData().getType().equals("continuous space") || item.getProjectionData().getType().equals("grid")) {
                hasCart = true;
                continue;
            }
            hasOther = true;
        }
        String displayType = (String)this.typeBox.getSelectedItem();
        if (displayType.equals("2D") || displayType.equals("3D")) {
            if (hasOther) {
                JOptionPane.showMessageDialog(this.selector, "Only 2D, 3D, Network, and Value layer projections are supported by " + displayType, "Display Error", 0);
                return false;
            }
            if (hasValue) {
                if (!hasCart) {
                    JOptionPane.showMessageDialog(this.selector, "Displays containing Value Layers must also contain at least one Grid or Continuous projection.", "Display Error", 0);
                    return false;
                }
                if (valCount > 1) {
                    JOptionPane.showMessageDialog(this.selector, "Displays may only contain one Value Layer.", "Display Error", 0);
                    return false;
                }
            }
        } else {
            DisplayValidator validator = VisualizationRegistry.getDataFor(displayType).getDisplayValidator();
            return validator.validateDisplay(selectedProjectionTypes);
        }
        return true;
    }

    public void init(WizardModel wizardModel) {
        this.model = (DisplayWizardModel)wizardModel;
    }

    public void prepare() {
        super.prepare();
        DefaultComboBoxModel<String> cmbModel = new DefaultComboBoxModel<String>();
        if (this.model.contextContainsProjectionType("continuous space") || this.model.contextContainsProjectionType("grid") || this.model.contextContainsProjectionType("network") || this.model.contextContainsProjectionType("value layer")) {
            cmbModel.addElement("2D");
            cmbModel.addElement("3D");
        }
        for (ProjectionRegistryData prd : ProjectionRegistry.getRegistryData()) {
            String projectionType = prd.getTypeName();
            if (!this.model.contextContainsProjectionType(projectionType)) continue;
            for (VisualizationRegistryData visualizationRegistryData : VisualizationRegistry.getRegistryData()) {
                if (!visualizationRegistryData.handlesProjectionType(projectionType)) continue;
                cmbModel.addElement(visualizationRegistryData.getVisualizationType());
            }
        }
        this.typeBox.setModel(cmbModel);
        this.descriptorCache.put("2D", new CartesianDisplayDescriptor(this.nameFld.getText().trim()));
        this.descriptorCache.put("3D", new CartesianDisplayDescriptor(this.nameFld.getText().trim()));
        for (VisualizationRegistryData data : VisualizationRegistry.getRegistryData()) {
            DisplayDescriptor newDesc = data.getDescriptorFactory().createDescriptor(this.nameFld.getText().trim());
            this.descriptorCache.put(data.getVisualizationType(), newDesc);
        }
        ArrayList<DisplayItem> source = new ArrayList<DisplayItem>();
        ArrayList<DisplayItem> target = new ArrayList<DisplayItem>();
        for (ProjectionData proj : this.model.getContext().projections()) {
            DisplayItem item = null;
            item = new DisplayItem(proj.getId(), proj);
            source.add(item);
        }
        DisplayDescriptor descriptor = this.model.getDescriptor();
        if (descriptor != null) {
            this.nameFld.setText(descriptor.getName());
            String string = descriptor.getDisplayType();
            this.typeBox.setSelectedItem(string);
            for (ProjectionData proj : descriptor.getProjections()) {
                DisplayItem item = null;
                item = new DisplayItem(proj.getId(), proj);
                source.remove(item);
                target.add(item);
            }
        } else {
            this.nameFld.setText(DEFAULT_DISPLAY_TITLE);
            this.model.setDescriptor(new CartesianDisplayDescriptor(DEFAULT_DISPLAY_TITLE));
        }
        this.selector.setLists(source, target);
        this.setComplete(target.size() > 0);
        this.typeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String type = (String)GeneralStep.this.typeBox.getSelectedItem();
                if (GeneralStep.this.model.getDescriptor() == null || !GeneralStep.this.model.getDescriptor().getDisplayType().equals(type)) {
                    GeneralStep.this.model.setDescriptor((DisplayDescriptor)GeneralStep.this.descriptorCache.get(type));
                }
            }
        });
    }

    public void applyState() throws InvalidStateException {
        super.applyState();
        if (!this.doValidate()) {
            throw new InvalidStateException();
        }
        DisplayDescriptor descriptor = this.model.getDescriptor();
        descriptor.setName(this.nameFld.getText().trim());
        String curType = descriptor.getDisplayType();
        String newType = (String)this.typeBox.getSelectedItem();
        if (curType != newType) {
            descriptor.setDisplayType(newType, true);
        }
        descriptor.clearProjections();
        descriptor.clearProjectionDescriptors();
        if (descriptor instanceof ValueLayerDescriptor) {
            ((ValueLayerDescriptor)((Object)descriptor)).clearValueLayerNames();
        }
        for (DisplayItem item : this.selector.getSelectedItems()) {
            if (item.proj == null) continue;
            if (item.getProjectionData().getType().equals("value layer")) {
                if (!(descriptor instanceof ValueLayerDescriptor)) continue;
                ((ValueLayerDescriptor)((Object)descriptor)).addValueLayerName(item.displayName);
                continue;
            }
            ProjectionDescriptorFactory pdf = null;
            pdf = "2D".equals(curType) || "3D".equals(curType) ? new CartesianProjectionDescritorFactory() : VisualizationRegistry.getDataFor(curType).getProjectionDescriptorFactory();
            if (pdf != null) {
                descriptor.addProjection(item.proj, pdf.createDescriptor(item.proj));
                continue;
            }
            msg.error((Object)("No ProjectionDescriptorFactory found for type: " + curType), null, new Object[0]);
        }
    }

    class DisplayItem {
        String displayName;
        ProjectionData proj;

        public DisplayItem(String displayName, ProjectionData proj) {
            this.proj = proj;
            this.displayName = displayName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DisplayItem) {
                DisplayItem other = (DisplayItem)obj;
                if (this.proj == null) {
                    if (other.proj == null) {
                        return other.displayName.equals(this.displayName);
                    }
                    return false;
                }
                if (other.proj != null) {
                    return this.proj.equals(other.proj);
                }
                return false;
            }
            return false;
        }

        public String toString() {
            return this.displayName;
        }

        public ProjectionData getProjectionData() {
            return this.proj;
        }
    }
}

