/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pietschy.wizard.InvalidStateException;
import org.pietschy.wizard.WizardModel;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.ui.plugin.editor.PluginWizardStep;
import repast.simphony.visualization.engine.CartesianDisplayDescriptor;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.VisualizationRegistry;
import repast.simphony.visualization.engine.VisualizationRegistryData;
import repast.simphony.visualization.gui.DisplayWizardModel;
import repast.simphony.visualization.gui.StyleClassFinder;
import repast.simphony.visualization.gui.styleBuilder.EditedEdgeStyleDialog;
import repast.simphony.visualization.gui.styleBuilder.SimpleEditedEdgeStyleDialog;
import repast.simphony.visualization.visualization3D.style.DefaultEdgeStyle3D;
import repast.simphony.visualization.visualization3D.style.EdgeStyle3D;
import repast.simphony.visualizationOGL2D.DefaultEdgeStyleOGL2D;
import repast.simphony.visualizationOGL2D.EdgeStyleOGL2D;
import simphony.util.messages.MessageCenter;

public class EdgeStyleStep
extends PluginWizardStep {
    private static final long serialVersionUID = 8604762391209707526L;
    private static final MessageCenter msg = MessageCenter.getMessageCenter(EdgeStyleStep.class);
    private DisplayWizardModel model;
    private JList objList;
    private DefaultComboBoxModel styleModel;
    private int currentIndex;
    private JComboBox styleBox;
    private Map<String, String> editedStyleFileMap;
    private JButton buildStyleButton = new JButton();
    private String defaultStyle;

    public EdgeStyleStep() {
        super("Edge Style", "Please provide an edge style for each network in the display");
    }

    protected JPanel getContentPanel() {
        this.objList = new JList(new DefaultListModel());
        this.styleModel = new DefaultComboBoxModel();
        this.currentIndex = -1;
        this.editedStyleFileMap = new HashMap<String, String>();
        this.buildStyleButton = new JButton();
        FormLayout layout = new FormLayout("pref, 6dlu, pref, 4dlu, pref, 4dlu, fill:pref:grow, 4dlu, pref", "pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, fill:pref:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        final JTextField netNameFld = new JTextField();
        netNameFld.setEditable(false);
        this.styleBox = new JComboBox(this.styleModel);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Networks", cc.xyw(1, 1, 1));
        builder.add((Component)new JScrollPane(this.objList), cc.xywh(1, 3, 1, 12));
        builder.addLabel("Network Name:", cc.xyw(3, 3, 7));
        builder.add((Component)netNameFld, cc.xyw(3, 5, 7));
        builder.addLabel("Edge Style Class:", cc.xyw(3, 7, 7));
        builder.add((Component)this.styleBox, cc.xyw(3, 9, 5));
        builder.add((Component)this.buildStyleButton, cc.xy(9, 9));
        this.buildStyleButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("edit.png")));
        this.buildStyleButton.setToolTipText("Edit the style of the selected edge type");
        this.buildStyleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (EdgeStyleStep.this.model.getDescriptor().getDisplayType().equals("2D")) {
                        SimpleEditedEdgeStyleDialog dialog = new SimpleEditedEdgeStyleDialog((JDialog)SwingUtilities.getWindowAncestor((Component)((Object)EdgeStyleStep.this)));
                        String userStyleName = EdgeStyleStep.this.model.getDescriptor().getNetworkEditedStyleName(netNameFld.getText());
                        dialog.init(EdgeStyleStep.this.model.getContext(), netNameFld.getText(), userStyleName, EdgeStyleStep.this.model.getDescriptor());
                        dialog.pack();
                        dialog.setVisible(true);
                        if (dialog.doSave()) {
                            String styleClassName = EdgeStyleStep.this.model.getDescriptor().getDisplayType().equals("2D") ? "repast.simphony.visualization.editedStyle.EditedEdgeStyle2D" : (EdgeStyleStep.this.model.getDescriptor().getDisplayType().equals("3D") ? "repast.simphony.visualization.editedStyle.EditedEdgeStyle3D" : "repast.simphony.visualization.editedStyle.EditedEdgeStyleGIS3D");
                            if (EdgeStyleStep.this.styleModel.getIndexOf(styleClassName) < 0) {
                                EdgeStyleStep.this.styleModel.addElement(styleClassName);
                            }
                            EdgeStyleStep.this.styleBox.setSelectedItem(styleClassName);
                            EdgeStyleStep.this.editedStyleFileMap.put(netNameFld.getText(), dialog.getUserStyleName());
                        }
                    } else {
                        EditedEdgeStyleDialog dialog = new EditedEdgeStyleDialog((JDialog)SwingUtilities.getWindowAncestor((Component)((Object)EdgeStyleStep.this)));
                        String userStyleName = EdgeStyleStep.this.model.getDescriptor().getNetworkEditedStyleName(netNameFld.getText());
                        dialog.init(EdgeStyleStep.this.model.getContext(), netNameFld.getText(), userStyleName, (CartesianDisplayDescriptor)EdgeStyleStep.this.model.getDescriptor());
                        dialog.pack();
                        dialog.setVisible(true);
                        if (dialog.doSave()) {
                            String styleClassName = EdgeStyleStep.this.model.getDescriptor().getDisplayType().equals("2D") ? "repast.simphony.visualization.editedStyle.EditedEdgeStyle2D" : (EdgeStyleStep.this.model.getDescriptor().getDisplayType().equals("3D") ? "repast.simphony.visualization.editedStyle.EditedEdgeStyle3D" : "repast.simphony.visualization.editedStyle.EditedEdgeStyleGIS3D");
                            if (EdgeStyleStep.this.styleModel.getIndexOf(styleClassName) < 0) {
                                EdgeStyleStep.this.styleModel.addElement(styleClassName);
                            }
                            EdgeStyleStep.this.styleBox.setSelectedItem(styleClassName);
                            EdgeStyleStep.this.editedStyleFileMap.put(netNameFld.getText(), dialog.getUserStyleName());
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.styleBox.setEditable(true);
        this.objList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    EdgeStyleStep.this.setElementValues(EdgeStyleStep.this.currentIndex);
                    EdgeStyleStep.this.currentIndex = EdgeStyleStep.this.objList.getSelectedIndex();
                    if (EdgeStyleStep.this.objList.getSelectedValue() == null) {
                        netNameFld.setText("");
                    } else {
                        ListElement element = (ListElement)EdgeStyleStep.this.objList.getSelectedValue();
                        netNameFld.setText(element.netName);
                        EdgeStyleStep.this.styleBox.setSelectedItem(element.styleClassName);
                    }
                }
            }
        });
        return builder.getPanel();
    }

    public void prepare() {
        this.currentIndex = -1;
        DefaultListModel listModel = (DefaultListModel)this.objList.getModel();
        listModel.clear();
        DisplayDescriptor descriptor = this.model.getDescriptor();
        Class[] defaultEdgeStyles3D = new Class[]{DefaultEdgeStyle3D.class};
        Class[] defaultEdgeStyles2D = new Class[]{DefaultEdgeStyleOGL2D.class};
        if (descriptor.getDisplayType().equals("3D")) {
            this.defaultStyle = defaultEdgeStyles3D[0].getName();
        } else if (descriptor.getDisplayType().equals("2D")) {
            this.defaultStyle = defaultEdgeStyles2D[0].getName();
        } else {
            VisualizationRegistryData data = VisualizationRegistry.getDataFor(descriptor.getDisplayType());
            if (data != null) {
                Class<?>[] defaultStyleClasses = data.getDefaultEdgeStyles();
                if (defaultStyleClasses != null) {
                    this.defaultStyle = defaultStyleClasses[0].getName();
                }
            } else {
                msg.error((Object)("Error creating edge style step for " + descriptor.getDisplayType() + ". No visualization registry data found."), null, new Object[0]);
            }
        }
        if (this.model.getDescriptor() instanceof CartesianDisplayDescriptor) {
            this.buildStyleButton.setEnabled(true);
        } else {
            this.buildStyleButton.setEnabled(false);
        }
        List<String> vals = null;
        Class<EdgeStyle3D> edgeStyle3DInterface = EdgeStyle3D.class;
        Class<EdgeStyleOGL2D> edgeStyle2DInterface = EdgeStyleOGL2D.class;
        if (descriptor.getDisplayType().equals("3D")) {
            vals = StyleClassFinder.getAvailableStyles(this.model.getContext(), edgeStyle3DInterface);
        } else if (descriptor.getDisplayType().equals("2D")) {
            vals = StyleClassFinder.getAvailableStyles(this.model.getContext(), edgeStyle2DInterface);
        } else {
            Class<?> edgeStyleInterface = VisualizationRegistry.getDataFor(descriptor.getDisplayType()).getEdgeStyleInterface();
            if (edgeStyleInterface != null) {
                vals = StyleClassFinder.getAvailableStyles(this.model.getContext(), edgeStyleInterface);
            } else {
                msg.warn((Object)("No edge styles found that implement " + edgeStyleInterface.getName()), new Object[0]);
            }
        }
        if (vals == null) {
            vals = new ArrayList<String>();
        }
        if (this.defaultStyle != null) {
            vals.add(this.defaultStyle);
        } else {
            msg.warn((Object)("No default edge styles found for " + descriptor.getDisplayType()), new Object[0]);
        }
        Collections.sort(vals);
        this.styleModel.removeAllElements();
        for (String val : vals) {
            this.styleModel.addElement(val);
        }
        for (ProjectionData proj : this.model.getDescriptor().getProjections()) {
            if (!proj.getType().equals("network")) continue;
            String name = proj.getId();
            String style = descriptor.getNetworkStyleClassName(name);
            String editedStyle = descriptor.getNetworkEditedStyleName(name);
            if (style == null) {
                style = this.defaultStyle;
            }
            listModel.addElement(new ListElement(name, style, editedStyle));
            this.editedStyleFileMap.put(name, editedStyle);
        }
        this.objList.setSelectedIndex(0);
        this.setComplete(true);
    }

    private void setCurrentElementValues() {
        this.setElementValues(this.currentIndex);
    }

    private void setElementValues(int elementIndex) {
        DefaultListModel listModel = (DefaultListModel)this.objList.getModel();
        if (elementIndex != -1 && elementIndex < listModel.getSize()) {
            ListElement element = (ListElement)listModel.get(elementIndex);
            Object obj = this.styleBox.getSelectedItem();
            if (obj != null) {
                element.styleClassName = obj.toString();
            }
            element.editedStyleName = "repast.simphony.visualization.editedStyle.EditedEdgeStyle2D".equals(element.styleClassName) || "repast.simphony.visualization.editedStyle.EditedEdgeStyle3D".equals(element.styleClassName) || "repast.simphony.visualization.editedStyle.EditedEdgeStyleGIS3D".equals(element.styleClassName) ? this.editedStyleFileMap.get(element.netName) : null;
        }
    }

    public void applyState() throws InvalidStateException {
        this.setCurrentElementValues();
        DefaultListModel listModel = (DefaultListModel)this.objList.getModel();
        DisplayDescriptor descriptor = this.model.getDescriptor();
        int i = 0;
        int n = listModel.size();
        while (i < n) {
            ListElement element = (ListElement)listModel.get(i);
            descriptor.addNetworkStyle(element.netName, element.styleClassName);
            descriptor.addNetworkEditedStyle(element.netName, element.editedStyleName);
            ++i;
        }
    }

    public void init(WizardModel wizardModel) {
        this.model = (DisplayWizardModel)wizardModel;
    }

    static class ListElement {
        String netName;
        String styleClassName;
        String editedStyleName;

        public ListElement(String netName, String styleClassName, String editedStyleName) {
            this.netName = netName;
            this.styleClassName = styleClassName;
            this.editedStyleName = editedStyleName;
        }

        public String toString() {
            return this.netName;
        }
    }
}

