/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.visualization.gui;

import org.pietschy.wizard.WizardEvent;
import org.pietschy.wizard.WizardListener;
import org.pietschy.wizard.models.DynamicModel;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.visualization.engine.DisplayDescriptor;
import repast.simphony.visualization.engine.ProjectionDescriptor;
import repast.simphony.visualization.engine.ValueLayerDescriptor;
import repast.simphony.visualization.engine.VisualizationRegistry;
import repast.simphony.visualization.visualization3D.style.DefaultStyle3D;
import repast.simphony.visualizationOGL2D.DefaultStyleOGL2D;

public class DisplayWizardModel
extends DynamicModel
implements WizardListener {
    private ContextData context;
    private DisplayDescriptor descriptor;
    private boolean cancelled = false;

    public DisplayWizardModel(Object contextID, DisplayDescriptor descriptor, ContextData rootContext) {
        this.descriptor = descriptor;
        this.context = rootContext.find(contextID.toString());
    }

    public void wizardCancelled(WizardEvent wizardEvent) {
        this.cancelled = true;
    }

    public void wizardClosed(WizardEvent wizardEvent) {
    }

    public DisplayDescriptor getDescriptor() {
        return this.cancelled ? null : this.descriptor;
    }

    public ProjectionDescriptor getTypeDescriptor(String type) {
        for (ProjectionData proj : this.getDescriptor().getProjections()) {
            if (!type.equals(proj.getType())) continue;
            return this.getDescriptor().getProjectionDescriptor(proj.getId());
        }
        return null;
    }

    public String getDefaultStyle() {
        Class[] styles3D = new Class[]{DefaultStyle3D.class};
        Class[] styles2D = new Class[]{DefaultStyleOGL2D.class};
        if (this.descriptor.getDisplayType().equals("3D")) {
            return styles3D[0].getName();
        }
        if (this.descriptor.getDisplayType().equals("2D")) {
            return styles2D[0].getName();
        }
        Class<?>[] styles = VisualizationRegistry.getDataFor(this.descriptor.getDisplayType()).getDefaultStyles();
        if (styles != null) {
            return styles[0].getName();
        }
        return null;
    }

    public boolean contextContainsOnlyProjectionType(String type) {
        for (ProjectionData proj : this.context.projections()) {
            if (type.equals(proj.getType())) continue;
            return false;
        }
        return true;
    }

    public boolean contextContainsProjectionType(String type) {
        for (ProjectionData proj : this.context.projections()) {
            if (!type.equals(proj.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnlyProjectionType(String type) {
        for (ProjectionData proj : this.getDescriptor().getProjections()) {
            if (type.equals(proj.getType())) continue;
            return false;
        }
        return true;
    }

    public boolean containsProjectionType(String type) {
        for (ProjectionData proj : this.getDescriptor().getProjections()) {
            if (!type.equals(proj.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValueLayer() {
        return this.descriptor instanceof ValueLayerDescriptor && ((ValueLayerDescriptor)((Object)this.descriptor)).getValueLayerCount() > 0;
    }

    public ContextData getContext() {
        return this.context;
    }

    public void setDescriptor(DisplayDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

